/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.html;

import com.opensymphony.module.sitemesh.SitemeshBufferFragment;
import com.opensymphony.module.sitemesh.html.HTMLProcessorContext;
import com.opensymphony.module.sitemesh.html.TagRule;

public abstract class BasicRule
implements TagRule {
    private final String[] acceptableTagNames;
    protected HTMLProcessorContext context;

    protected BasicRule(String[] acceptableTagNames) {
        this.acceptableTagNames = acceptableTagNames;
    }

    protected BasicRule(String acceptableTagName) {
        this.acceptableTagNames = new String[]{acceptableTagName};
    }

    protected BasicRule() {
        this.acceptableTagNames = null;
    }

    @Override
    public void setContext(HTMLProcessorContext context) {
        this.context = context;
    }

    @Override
    public boolean shouldProcess(String name) {
        if (this.acceptableTagNames == null || this.acceptableTagNames.length < 1) {
            throw new UnsupportedOperationException(this.getClass().getName() + " should be constructed with acceptableTagNames OR should implement shouldProcess()");
        }
        for (String acceptableTagName : this.acceptableTagNames) {
            if (!name.equals(acceptableTagName)) continue;
            return true;
        }
        return false;
    }

    protected SitemeshBufferFragment.Builder currentBuffer() {
        return this.context.currentBuffer();
    }

    protected String getCurrentBufferContent() {
        return this.context.currentBuffer().build().getStringContent();
    }
}

