/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.mapper.ConfigDecoratorMapper;
import com.opensymphony.module.sitemesh.mapper.DefaultDecorator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvEntryDecoratorMapper
extends ConfigDecoratorMapper {
    private static final Logger logger = LoggerFactory.getLogger(EnvEntryDecoratorMapper.class);

    @Override
    public Decorator getNamedDecorator(HttpServletRequest request, String name) {
        String resourceValue = EnvEntryDecoratorMapper.getStringResource(name);
        if (resourceValue == null) {
            return super.getNamedDecorator(request, name);
        }
        return new DefaultDecorator(name, resourceValue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringResource(String name) {
        String value = null;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Object o = ctx.lookup("java:comp/env/" + name);
            if (o != null) {
                value = o.toString();
            }
        }
        catch (NamingException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                logger.error("", (Throwable)e);
            }
        }
        return value;
    }
}

