/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.mapper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PathMapper {
    private Map<String, String> mappings = new HashMap<String, String>();

    public void put(String key, String pattern) {
        if (key != null) {
            this.mappings.put(pattern, key);
        }
    }

    public String get(String path) {
        String mapped;
        if (path == null) {
            path = "/";
        }
        if ((mapped = PathMapper.findKey(path, this.mappings)) == null) {
            return null;
        }
        return this.mappings.get(mapped);
    }

    private static String findKey(String path, Map<String, String> mappings) {
        String result = PathMapper.findExactKey(path, mappings);
        if (result == null) {
            result = PathMapper.findComplexKey(path, mappings);
        }
        if (result == null) {
            result = PathMapper.findDefaultKey(mappings);
        }
        return result;
    }

    private static String findExactKey(String path, Map<String, String> mappings) {
        if (mappings.containsKey(path)) {
            return path;
        }
        return null;
    }

    private static String findComplexKey(String path, Map<String, String> mappings) {
        Iterator<String> i = mappings.keySet().iterator();
        String result = null;
        String key = null;
        while (i.hasNext()) {
            key = i.next();
            if (key.length() <= 1 || key.indexOf(63) == -1 && key.indexOf(42) == -1 || !PathMapper.match(key, path, false) || result != null && key.length() <= result.length()) continue;
            result = key;
        }
        return result;
    }

    private static String findDefaultKey(Map<String, String> mappings) {
        String[] defaultKeys;
        for (String defaultKey : defaultKeys = new String[]{"/", "*", "/*"}) {
            if (!mappings.containsKey(defaultKey)) continue;
            return defaultKey;
        }
        return null;
    }

    private static boolean match(String pattern, String str, boolean isCaseSensitive) {
        char ch;
        char[] patArr = pattern.toCharArray();
        char[] strArr = str.toCharArray();
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char element : patArr) {
            if (element != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i = 0; i <= patIdxEnd; ++i) {
                char ch2 = patArr[i];
                if (ch2 == '?' || (!isCaseSensitive || ch2 == strArr[i]) && (isCaseSensitive || Character.toUpperCase(ch2) == Character.toUpperCase(strArr[i]))) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart]))) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxEnd] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd]))) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i = patIdxStart; i <= patIdxEnd; ++i) {
                if (patArr[i] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i = patIdxStart + 1; i <= patIdxEnd; ++i) {
                if (patArr[i] != '*') continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && (isCaseSensitive && ch != strArr[strIdxStart + i + j] || !isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart + i + j]))) continue block8;
                }
                foundIdx = strIdxStart + i;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i = patIdxStart; i <= patIdxEnd; ++i) {
            if (patArr[i] == '*') continue;
            return false;
        }
        return true;
    }
}

