/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.parser;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.SitemeshBuffer;
import com.opensymphony.module.sitemesh.parser.PageRequest;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractPage
implements Page {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final SitemeshBuffer sitemeshBuffer;
    private HttpServletRequest request;

    protected AbstractPage(SitemeshBuffer sitemeshBuffer) {
        this.sitemeshBuffer = sitemeshBuffer;
    }

    @Override
    public void writePage(Writer out) throws IOException {
        this.sitemeshBuffer.writeTo(out, 0, this.sitemeshBuffer.getBufferLength());
    }

    @Override
    public String getPage() {
        try {
            StringWriter writer = new StringWriter();
            this.writePage(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not get page " + e.getMessage(), e);
        }
    }

    @Override
    public abstract void writeBody(Writer var1) throws IOException;

    @Override
    public String getBody() {
        try {
            StringWriter writer = new StringWriter();
            this.writeBody(writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not get body " + e.getMessage(), e);
        }
    }

    @Override
    public String getTitle() {
        return AbstractPage.noNull(this.getProperty("title"));
    }

    @Override
    public String getProperty(String name) {
        if (!this.isPropertySet(name)) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public int getIntProperty(String name) {
        try {
            return Integer.parseInt(AbstractPage.noNull(this.getProperty(name)));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public long getLongProperty(String name) {
        try {
            return Long.parseLong(AbstractPage.noNull(this.getProperty(name)));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public boolean getBooleanProperty(String name) {
        String property = this.getProperty(name);
        if (property == null || property.trim().length() == 0) {
            return false;
        }
        switch (property.charAt(0)) {
            case '1': 
            case 'T': 
            case 'Y': 
            case 't': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPropertySet(String name) {
        return this.properties.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPropertyKeys() {
        Map<String, String> map = this.properties;
        synchronized (map) {
            Set<String> keys = this.properties.keySet();
            return keys.toArray(new String[keys.size()]);
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = new PageRequest(request);
    }

    @Override
    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    protected static String noNull(String in) {
        return in == null ? "" : in;
    }
}

