/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.taglib.page;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.DefaultSitemeshBuffer;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.SitemeshBufferWriter;
import com.opensymphony.module.sitemesh.filter.PageRequestWrapper;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ApplyDecoratorTag
extends BodyTagSupport
implements RequestConstants {
    private static final long serialVersionUID = 1L;
    private String page = null;
    private String decorator = null;
    private String contentType = null;
    private String encoding = null;
    private Map<String, String> params = new HashMap<String, String>(6);
    private Config config = null;
    private DecoratorMapper decoratorMapper = null;
    private Factory factory;

    public void setPage(String page) {
        this.page = page;
    }

    void addParam(String name, String value) {
        this.params.put(name, value);
    }

    public void setTitle(String title) {
        this.addParam("title", title);
    }

    public void setId(String id) {
        this.addParam("id", id);
    }

    public void setName(String decorator) {
        if (decorator != null) {
            this.decorator = decorator;
        }
    }

    @Deprecated
    public void setDecorator(String decorator) {
        this.setName(decorator);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public int doStartTag() {
        if (this.config == null) {
            this.config = new Config(this.pageContext.getServletConfig());
            this.factory = Factory.getInstance(this.config);
            this.decoratorMapper = this.factory.getDecoratorMapper();
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            Page pageObj;
            Page oldPage;
            block32: {
                oldPage = (Page)this.pageContext.getRequest().getAttribute("__sitemesh__page");
                PageParser parser = this.getParserSelector().getPageParser(this.contentType != null ? this.contentType : "text/html");
                if (this.page == null) {
                    if (this.bodyContent != null) {
                        SitemeshBufferWriter sitemeshWriter = new SitemeshBufferWriter();
                        this.bodyContent.writeOut((Writer)sitemeshWriter);
                        pageObj = parser.parse(sitemeshWriter.getSitemeshBuffer());
                    } else {
                        pageObj = parser.parse(new DefaultSitemeshBuffer(new char[0]));
                    }
                } else {
                    if (this.page.startsWith("http://") || this.page.startsWith("https://")) {
                        try {
                            URL url = new URL(this.page);
                            URLConnection urlConn = url.openConnection();
                            urlConn.setUseCaches(true);
                            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), Charset.forName(this.encoding)));
                                 SitemeshBufferWriter sitemeshWriter = new SitemeshBufferWriter();){
                                int moved;
                                char[] buf = new char[1000];
                                while ((moved = in.read(buf)) >= 0) {
                                    sitemeshWriter.write(buf, 0, moved);
                                }
                                pageObj = parser.parse(sitemeshWriter.getSitemeshBuffer());
                                break block32;
                            }
                        }
                        catch (IOException e) {
                            throw new JspException((Throwable)e);
                        }
                    }
                    String fullPath = this.page;
                    if (fullPath.length() > 0 && fullPath.charAt(0) != '/') {
                        int dotdot;
                        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
                        String thisPath = request.getServletPath();
                        if (thisPath == null) {
                            String requestURI = request.getRequestURI();
                            thisPath = request.getPathInfo() != null ? requestURI.substring(0, requestURI.indexOf(request.getPathInfo())) : requestURI;
                        }
                        fullPath = thisPath.substring(0, thisPath.lastIndexOf(47) + 1) + fullPath;
                        while ((dotdot = fullPath.indexOf("..")) > -1) {
                            int prevSlash = fullPath.lastIndexOf(47, dotdot - 2);
                            fullPath = fullPath.substring(0, prevSlash) + fullPath.substring(dotdot + 2);
                        }
                    }
                    RequestDispatcher rd = this.pageContext.getServletContext().getRequestDispatcher(fullPath);
                    PageRequestWrapper pageRequest = new PageRequestWrapper((HttpServletRequest)this.pageContext.getRequest());
                    PageResponseWrapper pageResponse = new PageResponseWrapper((HttpServletResponse)this.pageContext.getResponse(), this.factory);
                    StringBuilder sb = new StringBuilder(this.contentType != null ? this.contentType : "text/html");
                    if (this.encoding != null) {
                        sb.append(";charset=").append(this.encoding);
                    }
                    pageResponse.setContentType(sb.toString());
                    if (rd == null) {
                        throw new ApplyDecoratorException("The specified resource in applyDecorator tag (" + fullPath + ") was not found.");
                    }
                    rd.include((ServletRequest)pageRequest, (ServletResponse)pageResponse);
                    pageObj = pageResponse.getPage();
                }
            }
            if (pageObj == null) {
                throw new ApplyDecoratorException(this.page + " did not create a valid page to decorate.");
            }
            for (String k : this.params.keySet()) {
                String v = this.params.get(k);
                pageObj.addProperty(k, v);
            }
            if (this.decorator == null) {
                this.decorator = "";
            }
            pageObj.setRequest((HttpServletRequest)this.pageContext.getRequest());
            this.pageContext.getRequest().setAttribute("__sitemesh__decorator", (Object)this.decorator);
            Decorator d = this.decoratorMapper.getDecorator((HttpServletRequest)this.pageContext.getRequest(), pageObj);
            this.pageContext.getRequest().removeAttribute("__sitemesh__decorator");
            if (d == null || d.getPage() == null) {
                throw new JspException("Cannot locate inline Decorator: " + this.decorator);
            }
            this.pageContext.getRequest().setAttribute("__sitemesh__page", (Object)pageObj);
            this.pageContext.include(d.getPage());
            this.pageContext.getRequest().setAttribute("__sitemesh__page", (Object)oldPage);
            this.params.clear();
        }
        catch (IOException | ServletException e) {
            throw new JspException(e);
        }
        catch (ApplyDecoratorException e) {
            try {
                this.pageContext.getOut().println(e.getMessage());
            }
            catch (IOException ioe) {
                System.err.println("IOException thrown in applyDecorator tag: " + e.toString());
            }
        }
        return 6;
    }

    private PageParserSelector getParserSelector() {
        return Factory.getInstance(this.config);
    }

    class ApplyDecoratorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ApplyDecoratorException(String s) {
            super(s);
        }
    }
}

