/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.util;

import com.opensymphony.module.sitemesh.util.CharArrayWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputConverter {
    private static final Logger logger = LoggerFactory.getLogger(OutputConverter.class);
    public static final String WORK_AROUND_RESIN_I18N_BUG = "sitemesh.resin.i18n.workaround";

    public static Writer getWriter(Writer out) {
        if (Boolean.getBoolean(WORK_AROUND_RESIN_I18N_BUG)) {
            return new ResinWriter(out);
        }
        return out;
    }

    public static String convert(String inputString) {
        if (Boolean.getBoolean(WORK_AROUND_RESIN_I18N_BUG)) {
            StringWriter sr = new StringWriter();
            OutputConverter.resinConvert(inputString, sr);
            return sr.getBuffer().toString();
        }
        return inputString;
    }

    private static void resinConvert(String inputString, Writer writer) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(inputString.getBytes(StandardCharsets.UTF_8)), StandardCharsets.ISO_8859_1);){
            int i;
            while ((i = reader.read()) != -1) {
                writer.write(i);
            }
        }
        catch (IOException e) {
            logger.error("Unable to perform resinConvert", (Throwable)e);
        }
    }

    static class ResinWriter
    extends Writer {
        private final Writer target;
        private final CharArrayWriter buffer = new CharArrayWriter();

        public ResinWriter(Writer target) {
            this.target = target;
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            OutputConverter.resinConvert(this.buffer.toString(), this.target);
            this.buffer.reset();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.write(cbuf, off, len);
            this.flush();
        }
    }
}

