/*
 * Decompiled with CFR 0.152.
 */
package com.github.heqiao2010.lunar;

import com.github.heqiao2010.lunar.LunarData;
import com.github.heqiao2010.lunar.LunarUtils;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;

public class LunarCodes {
    public static short[] monthCodes(int year) {
        return LunarData.LUNAR_INFO[year - 1850];
    }

    public static int codeYear(int code) {
        return code / 100 > 12 ? 1 : 0;
    }

    public static int codeMonth(int code) {
        int m = code / 100;
        if (m > 12) {
            m -= 12;
        }
        return m;
    }

    public static int codeDay(int code) {
        return code % 100;
    }

    public static long lengthOfMonth(int lunarYear, int month, short code) {
        short md2;
        short[] starts = LunarCodes.monthCodes(lunarYear);
        int y2 = lunarYear;
        if (month + 1 < starts.length && starts[month] == code) {
            md2 = starts[month + 1];
        } else if (month + 2 < starts.length && starts[month + 1] == code) {
            md2 = starts[month + 2];
        } else if (lunarYear - 1850 + 1 < LunarData.LUNAR_INFO.length) {
            md2 = LunarCodes.monthCodes(lunarYear + 1)[1];
            ++y2;
        } else {
            throw new IllegalArgumentException("lunar date out of range");
        }
        int y1 = lunarYear + LunarCodes.codeYear(code);
        int m1 = LunarCodes.codeMonth(code);
        int d1 = LunarCodes.codeDay(code);
        y2 += LunarCodes.codeYear(md2);
        int m2 = LunarCodes.codeMonth(md2);
        int d2 = LunarCodes.codeDay(md2);
        Calendar c1 = Calendar.getInstance();
        c1.set(y1, m1 - 1, d1);
        Calendar c2 = Calendar.getInstance();
        c2.set(y2, m2 - 1, d2);
        return LunarUtils.solarDiff(c2, c1, 5);
    }

    public static Map.Entry<Integer, Boolean> month(int year, int index) {
        short[] a = LunarCodes.monthCodes(year);
        int i = index;
        if (index == -1) {
            i = a.length - 1;
        }
        boolean isLeap = a[0] > 0 && a[0] + 1 == i;
        int month = isLeap || a[0] > 0 && a[0] < i ? i - 1 : i;
        return new AbstractMap.SimpleImmutableEntry<Integer, Boolean>(month, isLeap);
    }

    public static int monthIndex(int year, int month, boolean isLeapMonth) {
        short[] a = LunarCodes.monthCodes(year);
        if (a[0] > 0 && a[0] < month || a[0] == month && isLeapMonth) {
            return month + 1;
        }
        return month;
    }

    public static long solarDateCodesDiff(int solarCode1, int solarCode2, int field) {
        GregorianCalendar c1 = new GregorianCalendar(solarCode1 / 10000, solarCode1 % 10000 / 100 - 1, solarCode1 % 10000 % 100);
        GregorianCalendar c2 = new GregorianCalendar(solarCode2 / 10000, solarCode2 % 10000 / 100 - 1, solarCode2 % 10000 % 100);
        return LunarUtils.solarDiff(c1, c2, field);
    }

    public static short lunarMonthCode(int lunarYear, int lunarMonth, boolean isLeapMonth) {
        short[] codes = LunarCodes.monthCodes(lunarYear);
        int index = lunarMonth;
        if (codes[0] > 0 && codes[0] < lunarMonth || codes[0] == lunarMonth && isLeapMonth) {
            ++index;
        }
        return codes[index];
    }
}

