/*
 * Decompiled with CFR 0.152.
 */
package com.github.heqiao2010.lunar;

public class LunarData {
    public static final int MINI_YEAR = 1850;
    public static final int MINI_MONTH = 1;
    public static final int MINI_DATE = 12;
    public static final int MAX_YEAR = 2150;
    public static final int MAX_MONTH = 11;
    public static final int MAX_DATE = 31;
    static final char[] LunarGan = new char[]{'\u7532', '\u4e59', '\u4e19', '\u4e01', '\u620a', '\u5df1', '\u5e9a', '\u8f9b', '\u58ec', '\u7678'};
    static final char[] LunarZhi = new char[]{'\u5b50', '\u4e11', '\u5bc5', '\u536f', '\u8fb0', '\u5df3', '\u5348', '\u672a', '\u7533', '\u9149', '\u620c', '\u4ea5'};
    static final char[] LunarAnimalName = new char[]{'\u9f20', '\u725b', '\u864e', '\u5154', '\u9f8d', '\u86c7', '\u99ac', '\u7f8a', '\u7334', '\u96de', '\u72ac', '\u8c6c'};
    static final char[] LunarYearName = new char[]{'\u3007', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    static final char[] LunarMonthName = new char[]{'\u6b63', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341', '\u51ac', '\u814a'};
    static final String[] LunarDayName = new String[]{"\u521d\u4e00", "\u521d\u4e8c", "\u521d\u4e09", "\u521d\u56db", "\u521d\u4e94", "\u521d\u516d", "\u521d\u4e03", "\u521d\u516b", "\u521d\u4e5d", "\u521d\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u5eff\u4e00", "\u5eff\u4e8c", "\u5eff\u4e09", "\u5eff\u56db", "\u5eff\u4e94", "\u5eff\u516d", "\u5eff\u4e03", "\u5eff\u516b", "\u5eff\u4e5d", "\u4e09\u5341"};
    static final short[][] LUNAR_INFO = new short[][]{{0, 212, 314, 412, 512, 610, 709, 808, 906, 1005, 1104, 1204, 1302}, {8, 201, 303, 402, 501, 531, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, {0, 220, 321, 331, 419, 519, 618, 717, 815, 914, 1013, 1112, 1211, 1309}, {0, 208, 310, 408, 508, 607, 706, 805, 903, 1003, 1101, 1201, 1230}, {7, 129, 227, 329, 427, 527, 625, 725, 824, 922, 1022, 1120, 1220, 1318}, {0, 217, 318, 416, 516, 614, 714, 813, 911, 1011, 1110, 1209, 1308}, {0, 206, 307, 405, 504, 603, 702, 801, 830, 929, 1029, 1128, 1227}, {5, 126, 224, 326, 424, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1315}, {0, 214, 315, 414, 513, 611, 711, 809, 907, 1007, 1106, 1205, 1304}, {0, 203, 305, 403, 503, 601, 630, 730, 828, 926, 1026, 1124, 1224}, {3, 123, 222, 322, 421, 521, 619, 718, 817, 915, 1014, 1113, 1212, 1311}, {0, 210, 311, 410, 510, 608, 708, 806, 905, 1004, 1103, 1202, 1231}, {8, 130, 301, 330, 429, 528, 627, 727, 825, 924, 1023, 1122, 1221, 1319}, {0, 218, 319, 418, 518, 616, 716, 814, 913, 1013, 1111, 1211, 1309}, {0, 208, 308, 406, 506, 604, 704, 802, 901, 1001, 1030, 1129, 1229, 1327}, {6, 127, 226, 327, 425, 525, 623, 723, 821, 920, 1020, 1118, 1218, 1317}, {0, 215, 317, 415, 514, 613, 712, 810, 909, 1009, 1107, 1207, 1306}, {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1027, 1126, 1226}, {4, 125, 223, 324, 423, 522, 620, 720, 818, 916, 1016, 1114, 1214, 1313}, {0, 211, 313, 412, 512, 610, 709, 808, 906, 1005, 1104, 1203, 1302}, {10, 131, 302, 401, 501, 530, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, {0, 219, 321, 420, 519, 618, 718, 816, 915, 1014, 1113, 1212, 1310}, {0, 209, 309, 408, 507, 606, 706, 804, 903, 1002, 1101, 1201, 1230}, {6, 129, 227, 328, 427, 526, 625, 724, 823, 922, 1021, 1120, 1220, 1318}, {0, 217, 318, 416, 516, 614, 714, 812, 911, 1010, 1109, 1209, 1308}, {0, 206, 308, 406, 505, 604, 703, 801, 831, 929, 1029, 1128, 1228}, {5, 126, 225, 326, 424, 523, 622, 721, 819, 918, 1017, 1116, 1216, 1314}, {0, 213, 315, 414, 513, 611, 711, 809, 907, 1007, 1105, 1205, 1303}, {0, 202, 304, 403, 502, 601, 630, 730, 828, 926, 1026, 1124, 1224}, {3, 122, 221, 323, 421, 521, 620, 719, 818, 916, 1015, 1114, 1213, 1312}, {0, 210, 311, 409, 509, 608, 707, 806, 905, 1004, 1103, 1202, 1231}, {7, 130, 228, 330, 428, 528, 626, 726, 825, 923, 1023, 1122, 1221, 1320}, {0, 218, 319, 418, 517, 616, 715, 814, 912, 1012, 1111, 1210, 1309}, {0, 208, 309, 407, 507, 605, 704, 803, 901, 1001, 1031, 1130, 1229}, {5, 128, 227, 327, 425, 525, 623, 722, 821, 919, 1019, 1118, 1217, 1316}, {0, 215, 317, 415, 514, 613, 712, 810, 909, 1008, 1107, 1206, 1305}, {0, 204, 306, 404, 504, 602, 702, 731, 829, 928, 1027, 1126, 1225}, {4, 124, 223, 325, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, {0, 212, 313, 411, 511, 610, 709, 808, 906, 1005, 1104, 1203, 1302}, {12, 131, 302, 331, 430, 530, 628, 728, 826, 925, 1024, 1123, 1222, 1321}, {0, 219, 321, 419, 519, 617, 717, 816, 914, 1014, 1112, 1212, 1310}, {0, 209, 310, 409, 508, 607, 706, 805, 903, 1003, 1102, 1201, 1231}, {6, 130, 228, 328, 427, 526, 624, 724, 822, 921, 1021, 1119, 1219, 1318}, {0, 217, 318, 416, 516, 614, 713, 812, 910, 1010, 1108, 1208, 1307}, {0, 206, 307, 406, 505, 604, 703, 801, 831, 929, 1029, 1127, 1227}, {5, 126, 225, 326, 425, 524, 623, 722, 820, 919, 1018, 1117, 1216, 1315}, {0, 214, 314, 413, 513, 611, 711, 809, 907, 1007, 1105, 1205, 1303}, {0, 202, 303, 402, 502, 531, 630, 730, 828, 926, 1026, 1124, 1224}, {3, 122, 221, 322, 421, 520, 619, 719, 817, 916, 1015, 1114, 1213, 1312}, {0, 210, 312, 410, 510, 608, 708, 806, 905, 1005, 1103, 1203, 1301}, {8, 131, 301, 331, 429, 528, 627, 726, 825, 924, 1023, 1122, 1222, 1320}, {0, 219, 320, 419, 518, 616, 716, 814, 913, 1012, 1111, 1211, 1310}, {0, 208, 310, 408, 508, 606, 705, 804, 902, 1002, 1031, 1130, 1230}, {5, 129, 227, 329, 427, 527, 625, 724, 823, 921, 1020, 1119, 1219, 1317}, {0, 216, 317, 416, 515, 614, 713, 811, 910, 1009, 1107, 1207, 1306}, {0, 204, 306, 405, 504, 603, 703, 801, 830, 929, 1028, 1127, 1226}, {4, 125, 223, 325, 424, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1314}, {0, 213, 314, 413, 512, 611, 710, 809, 908, 1007, 1106, 1205, 1304}, {0, 202, 303, 401, 430, 530, 629, 728, 827, 925, 1025, 1124, 1223}, {2, 122, 220, 322, 420, 519, 618, 717, 816, 914, 1014, 1113, 1213, 1311}, {0, 210, 311, 410, 509, 607, 707, 805, 904, 1003, 1102, 1202, 1301}, {6, 130, 301, 330, 429, 528, 626, 726, 824, 922, 1022, 1121, 1220, 1319}, {0, 218, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1209, 1307}, {0, 206, 308, 407, 506, 605, 704, 802, 901, 930, 1029, 1128, 1227}, {5, 126, 225, 327, 425, 525, 623, 723, 821, 920, 1019, 1117, 1217, 1315}, {0, 214, 316, 414, 514, 613, 712, 811, 909, 1009, 1107, 1207, 1305}, {0, 203, 304, 403, 502, 601, 630, 730, 829, 927, 1027, 1125, 1225}, {2, 123, 222, 323, 421, 521, 619, 719, 818, 916, 1016, 1115, 1214, 1313}, {0, 211, 313, 411, 510, 609, 708, 807, 905, 1005, 1104, 1203, 1302}, {7, 201, 302, 401, 430, 529, 628, 727, 825, 924, 1024, 1122, 1222, 1321}, {0, 220, 320, 419, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1309}, {0, 208, 310, 408, 508, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, {5, 128, 227, 328, 427, 527, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, {0, 216, 317, 416, 516, 614, 714, 812, 911, 1010, 1108, 1208, 1306}, {0, 205, 305, 404, 504, 602, 702, 801, 830, 929, 1028, 1127, 1226}, {4, 124, 223, 324, 423, 522, 621, 721, 819, 918, 1018, 1116, 1216, 1314}, {0, 213, 314, 412, 512, 610, 710, 808, 907, 1007, 1105, 1205, 1304}, {0, 202, 304, 402, 501, 531, 629, 729, 827, 926, 1025, 1124, 1224}, {2, 123, 221, 322, 420, 519, 618, 717, 815, 914, 1013, 1112, 1212, 1311}, {0, 210, 311, 410, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1231}, {6, 130, 228, 330, 429, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1319}, {0, 217, 319, 418, 517, 616, 715, 814, 912, 1011, 1110, 1209, 1308}, {0, 206, 307, 406, 506, 604, 704, 802, 901, 930, 1029, 1128, 1227}, {5, 126, 224, 326, 425, 524, 623, 723, 821, 920, 1019, 1118, 1217, 1315}, {0, 214, 315, 414, 513, 612, 712, 810, 909, 1008, 1107, 1207, 1305}, {0, 204, 305, 403, 503, 601, 701, 730, 829, 928, 1027, 1126, 1226}, {3, 124, 223, 323, 421, 521, 619, 718, 817, 916, 1015, 1114, 1214, 1313}, {0, 211, 313, 411, 510, 609, 708, 806, 905, 1004, 1103, 1203, 1302}, {7, 131, 302, 401, 430, 529, 628, 727, 825, 924, 1023, 1122, 1222, 1320}, {0, 219, 321, 420, 519, 617, 717, 815, 913, 1013, 1111, 1211, 1309}, {0, 208, 309, 408, 507, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, {6, 127, 226, 328, 426, 526, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, {0, 215, 317, 415, 515, 614, 713, 812, 910, 1010, 1108, 1208, 1306}, {0, 205, 306, 405, 504, 603, 702, 801, 831, 929, 1029, 1127, 1227}, {4, 125, 224, 324, 423, 522, 621, 720, 819, 917, 1017, 1116, 1215, 1314}, {0, 213, 314, 412, 512, 610, 709, 808, 906, 1006, 1105, 1205, 1303}, {0, 202, 304, 402, 501, 531, 629, 728, 827, 925, 1025, 1124, 1223}, {2, 122, 221, 323, 421, 520, 619, 718, 816, 915, 1014, 1113, 1212, 1311}, {0, 210, 311, 409, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1230}, {7, 129, 228, 329, 428, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1318}, {0, 217, 318, 417, 517, 615, 715, 814, 912, 1011, 1110, 1209, 1308}, {0, 206, 308, 406, 506, 605, 704, 803, 901, 1001, 1030, 1129, 1228}, {5, 127, 225, 326, 424, 524, 622, 722, 820, 919, 1019, 1117, 1217, 1315}, {0, 214, 315, 414, 513, 611, 711, 810, 908, 1008, 1107, 1206, 1305}, {0, 203, 305, 403, 503, 601, 630, 730, 828, 927, 1027, 1125, 1225}, {3, 124, 222, 324, 422, 522, 620, 719, 818, 916, 1016, 1114, 1214, 1313}, {0, 212, 312, 411, 510, 609, 708, 806, 905, 1004, 1103, 1202, 1301}, {8, 131, 302, 331, 430, 529, 628, 727, 825, 924, 1023, 1122, 1221, 1320}, {0, 218, 320, 419, 519, 617, 717, 815, 913, 1013, 1111, 1211, 1309}, {0, 208, 309, 408, 508, 606, 706, 804, 903, 1002, 1101, 1130, 1230}, {6, 128, 227, 327, 426, 525, 624, 724, 822, 921, 1020, 1119, 1218, 1317}, {0, 215, 317, 415, 515, 613, 713, 811, 910, 1010, 1108, 1208, 1306}, {0, 205, 306, 405, 504, 602, 702, 731, 830, 929, 1028, 1127, 1227}, {4, 125, 224, 325, 424, 523, 621, 721, 819, 918, 1017, 1116, 1216, 1315}, {0, 213, 314, 412, 512, 610, 709, 808, 906, 1006, 1104, 1204, 1303}, {0, 202, 303, 402, 501, 531, 629, 728, 827, 925, 1024, 1123, 1223}, {3, 121, 220, 322, 421, 520, 619, 718, 816, 915, 1014, 1112, 1212, 1311}, {0, 209, 311, 410, 509, 608, 708, 806, 904, 1004, 1102, 1202, 1231}, {7, 130, 228, 329, 427, 527, 626, 725, 824, 922, 1022, 1120, 1220, 1318}, {0, 217, 318, 417, 516, 615, 714, 813, 912, 1011, 1110, 1209, 1308}, {0, 206, 308, 406, 505, 604, 703, 802, 901, 930, 1030, 1129, 1228}, {5, 127, 225, 327, 425, 524, 623, 722, 821, 919, 1019, 1118, 1218, 1316}, {0, 215, 315, 414, 513, 611, 711, 809, 908, 1007, 1106, 1206, 1304}, {0, 203, 305, 403, 503, 601, 630, 730, 828, 926, 1026, 1125, 1224}, {4, 123, 222, 324, 422, 522, 620, 719, 818, 916, 1015, 1114, 1214, 1312}, {0, 211, 313, 412, 511, 610, 709, 807, 906, 1005, 1103, 1203, 1301}, {8, 131, 301, 331, 429, 529, 627, 727, 825, 924, 1023, 1121, 1221, 1319}, {0, 218, 320, 418, 518, 617, 716, 815, 913, 1013, 1111, 1211, 1309}, {0, 207, 309, 407, 507, 606, 705, 804, 903, 1002, 1101, 1130, 1230}, {6, 128, 227, 328, 426, 526, 624, 724, 823, 921, 1021, 1120, 1219, 1318}, {0, 216, 317, 415, 514, 613, 712, 811, 909, 1009, 1108, 1207, 1306}, {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1028, 1126, 1226}, {4, 125, 224, 325, 424, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1314}, {0, 213, 315, 413, 513, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, {10, 202, 303, 401, 501, 531, 629, 728, 827, 925, 1024, 1123, 1222, 1321}, {0, 220, 321, 420, 520, 618, 718, 816, 915, 1014, 1112, 1212, 1310}, {0, 209, 310, 409, 509, 607, 707, 806, 904, 1004, 1102, 1202, 1231}, {6, 129, 228, 329, 428, 527, 626, 726, 824, 923, 1023, 1121, 1221, 1319}, {0, 217, 318, 416, 516, 614, 714, 812, 911, 1011, 1109, 1209, 1308}, {0, 206, 308, 406, 505, 604, 703, 802, 831, 930, 1029, 1128, 1228}, {5, 127, 225, 327, 425, 524, 623, 722, 820, 919, 1018, 1117, 1217, 1316}, {0, 215, 316, 415, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1305}, {0, 204, 304, 403, 503, 601, 630, 730, 828, 926, 1026, 1124, 1224}, {3, 123, 221, 323, 422, 521, 620, 719, 818, 916, 1015, 1114, 1213, 1312}, {0, 210, 312, 411, 511, 609, 709, 807, 906, 1005, 1103, 1203, 1301}, {8, 131, 301, 331, 430, 529, 628, 727, 826, 925, 1024, 1122, 1222, 1320}, {0, 219, 319, 418, 517, 616, 716, 814, 913, 1012, 1111, 1211, 1309}, {0, 207, 309, 407, 507, 605, 705, 803, 902, 1002, 1031, 1130, 1230}, {5, 128, 227, 328, 426, 526, 624, 723, 822, 921, 1020, 1119, 1219, 1317}, {0, 216, 318, 416, 515, 614, 713, 811, 910, 1009, 1108, 1208, 1307}, {0, 205, 306, 405, 504, 602, 702, 731, 829, 928, 1027, 1126, 1226}, {4, 124, 223, 325, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, {0, 212, 314, 413, 512, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, {0, 201, 303, 402, 501, 531, 630, 729, 828, 926, 1025, 1124, 1223}, {2, 122, 220, 321, 419, 519, 618, 717, 816, 914, 1014, 1112, 1212, 1310}, {0, 209, 310, 409, 508, 607, 706, 805, 904, 1003, 1102, 1201, 1231}, {7, 129, 228, 329, 428, 527, 626, 725, 824, 922, 1022, 1121, 1220, 1319}, {0, 218, 319, 417, 517, 615, 714, 813, 911, 1011, 1110, 1210, 1308}, {0, 207, 308, 406, 505, 604, 703, 801, 831, 929, 1029, 1128, 1227}, {5, 126, 225, 327, 425, 524, 623, 722, 820, 919, 1018, 1117, 1216, 1315}, {0, 214, 316, 414, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1304}, {0, 203, 305, 403, 503, 602, 701, 731, 829, 927, 1027, 1125, 1225}, {4, 123, 222, 322, 421, 521, 619, 719, 817, 916, 1015, 1114, 1213, 1312}, {0, 210, 312, 410, 510, 608, 708, 807, 905, 1005, 1103, 1203, 1301}, {9, 131, 301, 331, 429, 529, 627, 727, 825, 924, 1024, 1122, 1222, 1320}, {0, 219, 320, 419, 518, 616, 716, 814, 913, 1013, 1112, 1211, 1310}, {0, 208, 309, 407, 507, 605, 704, 803, 901, 1001, 1031, 1129, 1229}, {6, 128, 226, 328, 426, 526, 624, 723, 822, 920, 1020, 1118, 1218, 1317}, {0, 216, 317, 416, 515, 614, 713, 811, 910, 1009, 1108, 1207, 1306}, {0, 205, 307, 405, 505, 603, 703, 801, 830, 929, 1028, 1126, 1226}, {4, 125, 223, 324, 423, 523, 621, 721, 819, 917, 1017, 1115, 1215, 1313}, {0, 212, 313, 412, 512, 610, 710, 808, 907, 1006, 1105, 1204, 1303}, {0, 201, 303, 401, 501, 530, 629, 729, 827, 926, 1025, 1124, 1223}, {2, 122, 220, 322, 420, 519, 618, 718, 816, 915, 1015, 1113, 1213, 1311}, {0, 210, 310, 409, 508, 606, 706, 804, 903, 1003, 1101, 1201, 1231}, {6, 129, 228, 329, 428, 527, 625, 725, 823, 922, 1021, 1120, 1220, 1319}, {0, 217, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1209, 1308}, {0, 206, 308, 407, 506, 605, 704, 802, 901, 930, 1029, 1128, 1228}, {5, 126, 225, 326, 425, 524, 623, 722, 820, 919, 1018, 1116, 1216, 1315}, {0, 213, 315, 414, 513, 612, 711, 810, 908, 1008, 1106, 1205, 1304}, {0, 203, 304, 403, 502, 601, 701, 730, 829, 927, 1027, 1125, 1225}, {3, 123, 221, 323, 422, 521, 620, 719, 818, 917, 1016, 1115, 1214, 1313}, {0, 211, 312, 410, 509, 608, 707, 806, 905, 1004, 1103, 1203, 1301}, {11, 131, 301, 331, 429, 528, 627, 726, 825, 923, 1023, 1122, 1222, 1320}, {0, 219, 320, 419, 518, 616, 716, 814, 913, 1012, 1111, 1211, 1309}, {0, 208, 310, 408, 508, 606, 705, 804, 902, 1001, 1031, 1130, 1229}, {6, 128, 227, 328, 426, 526, 624, 723, 822, 920, 1019, 1118, 1217, 1316}, {0, 215, 317, 416, 515, 614, 713, 811, 910, 1009, 1107, 1207, 1305}, {0, 204, 306, 405, 504, 603, 702, 801, 830, 929, 1028, 1126, 1226}, {5, 124, 223, 325, 423, 523, 622, 721, 820, 918, 1018, 1116, 1216, 1314}, {0, 212, 313, 411, 511, 610, 709, 808, 906, 1006, 1105, 1204, 1303}, {0, 201, 302, 401, 430, 530, 628, 728, 827, 925, 1025, 1124, 1223}, {2, 122, 220, 322, 420, 519, 618, 717, 816, 914, 1014, 1113, 1212, 1311}, {0, 210, 311, 410, 509, 607, 707, 805, 903, 1003, 1102, 1201, 1231}, {7, 130, 229, 329, 428, 527, 625, 725, 823, 921, 1021, 1119, 1219, 1318}, {0, 217, 319, 417, 517, 615, 714, 813, 911, 1010, 1109, 1208, 1307}, {0, 206, 308, 406, 506, 604, 704, 802, 901, 930, 1029, 1128, 1227}, {5, 126, 225, 326, 425, 525, 623, 723, 821, 920, 1019, 1117, 1217, 1315}, {0, 214, 314, 413, 513, 611, 711, 810, 908, 1008, 1106, 1205, 1304}, {0, 202, 304, 402, 502, 531, 630, 730, 828, 927, 1027, 1125, 1225}, {3, 123, 221, 323, 421, 521, 619, 719, 817, 916, 1016, 1114, 1214, 1313}, {0, 211, 313, 411, 510, 609, 708, 806, 905, 1005, 1103, 1203, 1302}, {8, 201, 301, 331, 429, 528, 627, 726, 824, 923, 1022, 1121, 1221, 1320}, {0, 219, 320, 419, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1309}, {0, 208, 309, 408, 508, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, {6, 128, 226, 328, 427, 526, 625, 724, 823, 921, 1020, 1119, 1218, 1317}, {0, 215, 316, 415, 515, 613, 713, 811, 910, 1009, 1107, 1207, 1305}, {0, 204, 305, 404, 504, 602, 702, 731, 830, 928, 1028, 1126, 1226}, {4, 124, 223, 324, 423, 522, 621, 720, 819, 918, 1017, 1116, 1216, 1314}, {0, 212, 314, 412, 512, 610, 710, 808, 907, 1006, 1105, 1205, 1304}, {0, 202, 303, 401, 430, 530, 628, 727, 826, 924, 1024, 1123, 1223}, {3, 121, 220, 322, 420, 519, 618, 717, 815, 914, 1013, 1112, 1212, 1311}, {0, 209, 311, 410, 509, 607, 707, 805, 903, 1003, 1101, 1201, 1231}, {7, 129, 228, 330, 428, 528, 626, 726, 824, 922, 1022, 1120, 1220, 1318}, {0, 217, 318, 417, 516, 615, 714, 813, 911, 1010, 1109, 1208, 1307}, {0, 205, 307, 406, 505, 604, 704, 802, 901, 930, 1029, 1128, 1227}, {5, 126, 224, 326, 424, 524, 623, 722, 821, 919, 1019, 1117, 1217, 1315}, {0, 214, 315, 414, 513, 612, 711, 810, 909, 1008, 1107, 1206, 1305}, {0, 203, 304, 402, 502, 531, 629, 729, 828, 926, 1026, 1125, 1224}, {4, 123, 221, 323, 421, 521, 619, 718, 817, 915, 1015, 1114, 1214, 1312}, {0, 211, 312, 411, 510, 609, 708, 806, 905, 1004, 1103, 1203, 1301}, {8, 131, 302, 331, 430, 529, 628, 727, 825, 924, 1023, 1122, 1221, 1320}, {0, 219, 320, 418, 518, 616, 716, 814, 912, 1012, 1110, 1210, 1308}, {0, 207, 309, 407, 507, 606, 705, 804, 902, 1001, 1031, 1129, 1229}, {6, 127, 226, 327, 426, 526, 624, 724, 822, 921, 1020, 1119, 1218, 1317}, {0, 215, 317, 415, 515, 613, 713, 812, 910, 1010, 1108, 1208, 1306}, {0, 205, 305, 404, 503, 602, 701, 731, 829, 928, 1028, 1126, 1226}, {4, 124, 223, 324, 423, 522, 620, 720, 818, 917, 1017, 1116, 1215, 1314}, {0, 212, 314, 412, 512, 610, 709, 808, 906, 1006, 1105, 1204, 1303}, {0, 202, 303, 402, 501, 531, 629, 728, 827, 925, 1025, 1123, 1223}, {3, 122, 221, 321, 420, 519, 618, 717, 815, 914, 1013, 1111, 1211, 1310}, {0, 209, 310, 409, 509, 607, 707, 805, 903, 1003, 1101, 1130, 1230}, {7, 129, 227, 329, 428, 528, 626, 725, 824, 922, 1022, 1120, 1219, 1318}, {0, 217, 318, 417, 517, 615, 715, 813, 912, 1011, 1110, 1209, 1308}, {0, 206, 307, 405, 505, 603, 703, 802, 831, 930, 1029, 1128, 1227}, {5, 126, 224, 326, 424, 523, 622, 722, 820, 919, 1019, 1117, 1217, 1315}, {0, 214, 315, 414, 513, 611, 711, 809, 908, 1008, 1106, 1206, 1305}, {0, 203, 305, 403, 503, 601, 630, 730, 828, 927, 1026, 1125, 1225}, {4, 124, 222, 323, 421, 521, 619, 718, 817, 915, 1014, 1113, 1213, 1312}, {0, 210, 312, 411, 510, 609, 708, 806, 904, 1004, 1102, 1202, 1301}, {8, 130, 301, 331, 430, 529, 628, 727, 825, 924, 1023, 1121, 1221, 1320}, {0, 218, 320, 419, 518, 617, 716, 815, 913, 1013, 1111, 1210, 1309}, {0, 207, 308, 407, 506, 605, 705, 803, 902, 1001, 1031, 1129, 1229}, {6, 127, 225, 327, 426, 525, 624, 723, 822, 921, 1020, 1119, 1218, 1317}, {0, 215, 316, 415, 514, 613, 712, 811, 910, 1009, 1108, 1208, 1306}, {0, 205, 306, 405, 504, 602, 702, 731, 830, 928, 1028, 1127, 1227}, {4, 125, 224, 324, 423, 522, 620, 720, 818, 916, 1016, 1115, 1215, 1313}, {0, 212, 314, 412, 512, 610, 709, 807, 906, 1005, 1104, 1204, 1302}, {0, 201, 303, 402, 501, 531, 629, 728, 826, 925, 1024, 1123, 1222}, {2, 121, 220, 322, 420, 520, 619, 718, 816, 915, 1014, 1112, 1212, 1310}, {0, 209, 311, 410, 509, 608, 707, 806, 904, 1004, 1102, 1201, 1231}, {7, 129, 228, 330, 428, 528, 626, 726, 825, 923, 1023, 1121, 1220, 1319}, {0, 217, 319, 417, 517, 616, 715, 814, 912, 1012, 1111, 1210, 1309}, {0, 207, 308, 407, 506, 605, 704, 803, 901, 1001, 1031, 1130, 1229}, {5, 128, 226, 327, 425, 524, 623, 722, 821, 919, 1019, 1118, 1217, 1316}, {0, 215, 316, 415, 514, 612, 712, 810, 908, 1008, 1107, 1206, 1305}, {0, 204, 306, 404, 504, 602, 701, 731, 829, 927, 1027, 1125, 1225}, {4, 124, 223, 325, 423, 523, 621, 720, 819, 917, 1016, 1115, 1214, 1313}, {0, 212, 313, 411, 511, 609, 709, 807, 906, 1005, 1103, 1203, 1301}, {9, 131, 302, 331, 430, 530, 628, 728, 826, 925, 1024, 1122, 1222, 1320}, {0, 219, 320, 419, 519, 617, 717, 816, 914, 1014, 1112, 1211, 1310}, {0, 208, 310, 408, 508, 606, 706, 805, 903, 1003, 1101, 1201, 1231}, {6, 129, 227, 328, 426, 526, 624, 724, 822, 921, 1021, 1119, 1219, 1318}, {0, 216, 318, 416, 515, 614, 713, 811, 910, 1010, 1108, 1208, 1307}, {0, 206, 307, 406, 505, 603, 703, 801, 830, 929, 1028, 1127, 1227}, {4, 126, 225, 326, 425, 524, 622, 722, 820, 918, 1018, 1116, 1216, 1315}, {0, 214, 314, 413, 512, 611, 710, 809, 907, 1006, 1105, 1204, 1303}, {0, 202, 303, 402, 502, 531, 630, 729, 828, 926, 1025, 1124, 1223}, {3, 122, 220, 322, 421, 520, 619, 719, 817, 916, 1015, 1113, 1213, 1311}, {0, 210, 311, 410, 509, 608, 708, 806, 905, 1004, 1103, 1202, 1301}, {7, 130, 229, 329, 428, 527, 626, 725, 824, 923, 1022, 1121, 1220, 1319}, {0, 217, 319, 417, 517, 615, 715, 813, 912, 1011, 1110, 1210, 1309}, {0, 207, 308, 407, 506, 605, 704, 802, 901, 930, 1030, 1129, 1229}, {5, 127, 226, 328, 426, 525, 624, 723, 821, 920, 1019, 1118, 1218, 1317}, {0, 215, 316, 414, 514, 612, 712, 810, 908, 1008, 1106, 1206, 1305}, {0, 203, 305, 404, 503, 602, 701, 731, 829, 927, 1027, 1125, 1225}, {4, 123, 222, 324, 423, 522, 621, 720, 819, 917, 1016, 1115, 1214, 1313}, {0, 211, 313, 412, 511, 610, 710, 808, 906, 1006, 1104, 1204, 1302}, {11, 201, 301, 331, 429, 529, 628, 727, 826, 924, 1024, 1122, 1222, 1320}, {0, 219, 320, 419, 518, 617, 716, 815, 914, 1013, 1112, 1211, 1310}, {0, 208, 310, 408, 508, 606, 705, 804, 903, 1002, 1101, 1201, 1230}, {6, 129, 227, 329, 427, 527, 625, 724, 823, 921, 1021, 1120, 1220, 1318}, {0, 217, 317, 416, 515, 614, 713, 811, 910, 1009, 1108, 1208, 1306}, {0, 205, 307, 405, 505, 603, 703, 801, 830, 928, 1028, 1127, 1226}, {5, 125, 224, 326, 424, 524, 622, 722, 820, 918, 1018, 1116, 1216, 1314}, {0, 213, 315, 413, 513, 612, 711, 809, 908, 1007, 1106, 1205, 1304}, {0, 202, 303, 401, 501, 531, 629, 729, 827, 926, 1025, 1124, 1223}, {2, 122, 220, 322, 420, 520, 618, 718, 817, 915, 1015, 1113, 1213, 1311}, {0, 210, 311, 410, 509, 608, 707, 806, 904, 1004, 1103, 1202, 1301}, {7, 130, 301, 330, 429, 528, 626, 726, 824, 923, 1023, 1122, 1221, 1320}, {0, 218, 319, 417, 517, 615, 714, 813, 911, 1011, 1110, 1209, 1308}, {0, 207, 308, 407, 506, 605, 704, 802, 901, 930, 1030, 1128, 1228}, {5, 127, 226, 327, 426, 525, 624, 723, 821, 919, 1019, 1117, 1217, 1316}, {0, 215, 316, 415, 515, 613, 713, 811, 909, 1008, 1107, 1206, 1305}, {0, 204, 304, 403, 503, 602, 701, 730, 829, 927, 1027, 1125, 1224}, {4, 123, 222, 323, 422, 522, 620, 720, 818, 917, 1016, 1115, 1214, 1313}, {0, 211, 312, 411, 511, 609, 709, 807, 906, 1006, 1104, 1204, 1302}, {0, 201, 302, 331, 430, 529, 628, 728, 826, 925, 1025, 1123, 1223}, {1, 121, 220, 320, 419, 518, 616, 716, 814, 913, 1013, 1111, 1211, 1310}, {0, 208, 310, 408, 508, 606, 705, 804, 902, 1002, 1031, 1130, 1230}, {6, 129, 227, 329, 427, 527, 625, 724, 822, 921, 1020, 1119, 1219, 1318}};

    public static String getDayName(int lunarDay) {
        return LunarDayName[lunarDay - 1];
    }

    public static char getMonthName(int lunarMonth) {
        return LunarMonthName[lunarMonth - 1];
    }

    public static String getYearName(int lunarYear) {
        StringBuilder sb = new StringBuilder();
        sb.append(LunarYearName[lunarYear / 1000]);
        sb.append(LunarYearName[lunarYear % 1000 / 100]);
        sb.append(LunarYearName[lunarYear % 100 / 10]);
        sb.append(LunarYearName[lunarYear % 10]);
        return sb.toString();
    }

    public static String getTraditionalYearName(int y) {
        return "" + LunarGan[(y -= 1804) % 10] + LunarZhi[y % 12] + "\u5e74";
    }

    public static char getAnimalYearName(int y) {
        return LunarAnimalName[(y - 4) % 12];
    }
}

