/*
 * Decompiled with CFR 0.152.
 */
package top.hihuzi.collection.cache;

import java.util.HashMap;
import java.util.Map;
import top.hihuzi.collection.cache.ParameterCache;
import top.hihuzi.collection.cache.TableCache;
import top.hihuzi.collection.cache.TypeCache;
import top.hihuzi.collection.config.CacheBean;
import top.hihuzi.collection.sql.config.SqlBean;

public class ClassCache {
    public static volatile Map<String, Map<String, TypeCache>> cache = null;
    private static volatile Map<String, Map<String, ParameterCache>> paramCache = null;
    private static volatile Map<String, TableCache> tableCache = null;
    private static volatile Map<String, Object> objectCache = null;
    private static ClassCache classCache = null;

    public static Map<String, TypeCache> getCache(Class<?> clazz) {
        Map<String, TypeCache> result = null;
        if (cache == null || (result = cache.get(clazz.getName())) == null) {
            return null;
        }
        return result;
    }

    public static TypeCache getCache(Class<?> clazz, String paramterName) {
        Map<String, TypeCache> result = null;
        if (cache == null || (result = cache.get(clazz.getName())) == null) {
            return null;
        }
        return result.get(paramterName);
    }

    public static Map<String, ParameterCache> getPCache(Object clacc) {
        Class clazz = null;
        if (clacc instanceof Class) {
            clazz = (Class)clacc;
            if (paramCache == null || paramCache.get(clazz.getName()) == null) {
                return null;
            }
            return paramCache.get(clazz.getName());
        }
        if (clacc instanceof String) {
            if (paramCache == null || paramCache.get(clacc) == null) {
                return null;
            }
            return paramCache.get(clacc);
        }
        return null;
    }

    public static ParameterCache getPCache(Object clacc, String paramterName) {
        Class clazz = null;
        if (clacc instanceof Class) {
            clazz = (Class)clacc;
            Map<String, ParameterCache> result = null;
            if (null == paramCache || (result = paramCache.get(clazz.getName())) == null) {
                return null;
            }
            return paramCache.get(clazz.getName()).get(paramterName);
        }
        if (clacc instanceof String) {
            Map<String, ParameterCache> result = null;
            if (null == paramCache || (result = paramCache.get(clacc)) == null) {
                return null;
            }
            return paramCache.get(clacc).get(paramterName);
        }
        return null;
    }

    public static TableCache getTCache(String sqlKey) {
        TableCache result = null;
        if (null == tableCache || (result = tableCache.get(sqlKey)) == null) {
            return null;
        }
        return result;
    }

    public static CacheBean getOCache(String sqlKey) {
        CacheBean result = null;
        if (null == objectCache || (result = (CacheBean)objectCache.get(sqlKey)) == null) {
            return null;
        }
        return result;
    }

    public void add(Class<?> clazz, String paramterName) {
        this.add(clazz, paramterName, null);
    }

    public void add(Class<?> clazz, String paramterName, Class<?> paramtertype) {
        Map<Object, Object> typeCacheMap = null;
        if (cache != null) {
            typeCacheMap = cache.containsKey(clazz.getName()) ? cache.get(clazz.getName()) : new HashMap(1);
        } else {
            cache = new HashMap<String, Map<String, TypeCache>>(20);
            typeCacheMap = new HashMap(1);
        }
        this.joinTheCache(clazz, paramterName, typeCacheMap, paramtertype);
    }

    public void add(Class<?> clazz, String paramterName, Class<?> paramtertype, String tableName, String sqlKey) {
        Map<Object, Object> parameterCacheMap = null;
        if (sqlKey != null) {
            if (null != paramCache) {
                parameterCacheMap = paramCache.containsKey(sqlKey + clazz.getSimpleName()) ? paramCache.get(sqlKey + clazz.getSimpleName()) : new HashMap(1);
            } else {
                paramCache = new HashMap<String, Map<String, ParameterCache>>(20);
                parameterCacheMap = new HashMap(1);
            }
        } else if (null != paramCache) {
            parameterCacheMap = paramCache.containsKey(clazz.getName()) ? paramCache.get(clazz.getName()) : new HashMap(1);
        } else {
            paramCache = new HashMap<String, Map<String, ParameterCache>>(20);
            parameterCacheMap = new HashMap(1);
        }
        this.joinTheCache(clazz, paramterName, parameterCacheMap, paramtertype, tableName, sqlKey);
    }

    public void add(String sqlKey, String paramterName, String tableName) {
        TableCache tableCacheMap = null;
        if (null == tableCache) {
            tableCache = new HashMap<String, TableCache>(20);
            tableCache.put(sqlKey, new TableCache(paramterName, tableName));
        } else {
            tableCacheMap = tableCache.get(sqlKey);
            if (null == tableCacheMap) {
                tableCache.put(sqlKey, new TableCache(paramterName, tableName));
            } else {
                Map<String, String> cache = tableCacheMap.getCache();
                cache.put(paramterName, tableName);
                tableCache.put(sqlKey, tableCacheMap);
            }
        }
    }

    public void add(String sqlKey, CacheBean bean) {
        SqlBean sqlBean = null;
        if (bean instanceof SqlBean) {
            sqlBean = (SqlBean)bean;
            if (null == objectCache) {
                objectCache = new HashMap<String, Object>(20);
                objectCache.put(sqlKey, sqlBean);
            } else if (null == objectCache.get(sqlKey)) {
                objectCache.put(sqlKey, sqlBean);
            }
        }
    }

    private void joinTheCache(Class<?> clazz, String paramterName, Map<String, TypeCache> cacheTypeMap, Class<?> paramtertype) {
        cacheTypeMap.put(paramterName, TypeCache.add(clazz, paramterName, paramtertype));
        cache.put(clazz.getName(), cacheTypeMap);
    }

    private void joinTheCache(Class<?> clazz, String paramterName, Map<String, ParameterCache> paramterMap, Class<?> paramtertype, String tableName, String sqlKey) {
        paramterMap.put(tableName, ParameterCache.add(clazz, paramterName, paramtertype, tableName));
        if (sqlKey == null) {
            paramCache.put(clazz.getName(), paramterMap);
        } else {
            paramCache.put(sqlKey + clazz.getSimpleName(), paramterMap);
        }
    }

    public static ClassCache get() {
        if (null == classCache) {
            return CacheClazz.CLASS_CACHE;
        }
        return classCache;
    }

    private ClassCache() {
    }

    private static class CacheClazz {
        private static final ClassCache CLASS_CACHE = new ClassCache();

        private CacheClazz() {
        }
    }
}

