/*
 * Decompiled with CFR 0.152.
 */
package top.hihuzi.collection.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.hihuzi.collection.cache.ClassCache;
import top.hihuzi.collection.cache.ParameterCache;
import top.hihuzi.collection.cache.SecondCache;
import top.hihuzi.collection.cache.TypeCache;
import top.hihuzi.collection.common.ValueHandleCache;
import top.hihuzi.collection.config.Config;
import top.hihuzi.collection.exception.NoticeException;
import top.hihuzi.collection.sql.config.SqlBean;
import top.hihuzi.collection.sql.config.SqlConfig;
import top.hihuzi.collection.utils.StrUtils;

public class PublicMethod {
    public static <E> Map getHumpToLine(E e) {
        HashMap<String, String> map = new HashMap<String, String>(((Class)e).getDeclaredFields().length);
        Class clazz = null;
        for (clazz = (Class)e; Object.class != clazz; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                map.put(field.getName(), StrUtils.humpToLine(field.getName()));
                ClassCache.get().add((Class)e, field.getName(), field.getType());
            }
        }
        return map;
    }

    public static <E> Map<String, ParameterCache> tableNameMatchParameter(Map list, E ... e) {
        Map<String, ParameterCache> map;
        if (!PublicMethod.isBeingCache(e)) {
            PublicMethod.addCache(list, e);
        }
        if (null == (map = SecondCache.getCache(StrUtils.splicingObjectName(e))) || 0 == map.size()) {
            map = new HashMap<String, ParameterCache>(e.length);
            for (E es : e) {
                Map<String, ParameterCache> pCache = ClassCache.getPCache(es.getClass());
                map.putAll(pCache);
            }
            SecondCache.addCache(StrUtils.splicingObjectName(e), map);
        }
        return map;
    }

    public static <E> Map<String, ParameterCache> tableNameMatchParameter(SqlConfig config, E ... e) {
        String sqlKey = config.getSqlEeum().get().key();
        Map<String, ParameterCache> map = SecondCache.getCache(sqlKey);
        if (null == map) {
            map = new HashMap<String, ParameterCache>(e.length);
            for (E es : e) {
                Map<String, ParameterCache> pCache = ClassCache.getPCache(sqlKey + ((Class)es).getSimpleName());
                map.putAll(pCache);
            }
            SecondCache.addCache(sqlKey, map);
        }
        return map;
    }

    private static <E> boolean isBeingCache(E ... e) {
        for (E es : e) {
            Map<String, ParameterCache> pCache = ClassCache.getPCache(es.getClass());
            if (null != pCache) continue;
            return false;
        }
        return true;
    }

    private static <E> void addCache(Map list, E ... e) {
        for (E es : e) {
            Class<?> clazz = es.getClass();
            for (Object obj : list.keySet()) {
                while (Object.class != clazz) {
                    for (Field field : clazz.getDeclaredFields()) {
                        if (!StrUtils.isEquals(String.valueOf(obj), field.getName())) continue;
                        ClassCache.get().add(es.getClass(), field.getName(), field.getType());
                        ClassCache.get().add(es.getClass(), field.getName(), field.getType(), String.valueOf(obj), null);
                        break;
                    }
                    clazz = clazz.getSuperclass();
                }
                clazz = es.getClass();
            }
        }
    }

    public static Object processingTimeType(Class<?> type, Config config, Object obj) {
        if (ValueHandleCache.TypeEnum.DATE.getValue().equals(type.getSimpleName())) {
            if (null == obj) {
                return null;
            }
            return config.getDateStyleEnum().getFormartStyle().format(obj);
        }
        if (ValueHandleCache.TypeEnum.STRING.getValue().equals(type.getSimpleName())) {
            if (config.getSaveStyleEnum().getHaving().booleanValue()) {
                return obj;
            }
            return "".equals(String.valueOf(obj).trim()) ? null : obj;
        }
        return obj;
    }

    public static Object processTimeType(Class<?> type, Config config, Object obj) {
        if (ValueHandleCache.TypeEnum.DATE.getValue().equals(type.getSimpleName())) {
            if (null == obj) {
                return null;
            }
            try {
                return obj.toString().substring(0, config.getDateStyleEnum().getFormartStyle().toPattern().length());
            }
            catch (Exception e) {
                return obj;
            }
        }
        if (ValueHandleCache.TypeEnum.STRING.getValue().equals(type.getSimpleName())) {
            if (config.getSaveStyleEnum().getHaving().booleanValue()) {
                return obj;
            }
            return "".equals(String.valueOf(obj).trim()) ? null : obj;
        }
        return obj;
    }

    public static int achieveTimes(Class clazz, List<String> display) {
        int i = 0;
        while (Object.class != clazz) {
            for (Field declaredField : clazz.getDeclaredFields()) {
                if (!display.contains(declaredField.getName())) continue;
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        return i;
    }

    public static void achieveMap(Map map0, String name, Object value, SqlConfig config, TypeCache typeCache) {
        SqlBean sqlBean = config.getSqlEeum().get();
        Map<String, String> displayNickname = sqlBean.getDisplayNickname();
        String paramterName = typeCache.getParamterName();
        if (null == displayNickname) {
            name = sqlBean.getRepeat().contains(paramterName) ? typeCache.getClazz().getSimpleName() + StrUtils.capsHead(paramterName) : paramterName;
        } else if (!sqlBean.getRepeat().contains(paramterName)) {
            name = paramterName;
        } else if (sqlBean.getRepeat().contains(paramterName) && !displayNickname.containsValue(name)) {
            name = typeCache.getClazz().getSimpleName() + StrUtils.capsHead(paramterName);
        }
        Object val = PublicMethod.processTimeType(typeCache.getParamtertype(), config, value);
        PublicMethod.achieveMap(map0, name, val, config);
    }

    public static void achieveMap(Map map, String key, Object invoke, Config config) {
        if (null != invoke) {
            map.put(PublicMethod.achieveKey(key, config), invoke);
        } else if (config.getSaveStyleEnum().getHaving().booleanValue()) {
            map.put(PublicMethod.achieveKey(key, config), "");
        }
    }

    private static String achieveKey(String property, Config config) {
        switch (config.getReturnNameEnum()) {
            case DEFAULT: {
                return property;
            }
            case LOWER_CASE: {
                return property.toLowerCase();
            }
            case UPPER_CASE: {
                return property.toUpperCase();
            }
            case INITIAL_CAPITAL: {
                return StrUtils.capsHead(property);
            }
            case CUSTOM_SUFFIX: {
                return config.getReturnNameEnum().getKey() + property;
            }
            case CLASS_HUMP: {
                return property.substring(0, 1).toLowerCase() + property.substring(1);
            }
        }
        throw new NoticeException("\u547d\u540d\u98ce\u683c\u672a\u5b9a\u4e49");
    }
}

