/*
 * Decompiled with CFR 0.152.
 */
package top.hihuzi.collection.common;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import top.hihuzi.collection.config.Config;
import top.hihuzi.collection.exception.NoticeException;

public class ValueHandleCache {
    public static <E> void invokeValue(E e, Method method, String value, String fieldType, Config config, TypeEnum typeEnum) {
        Object obj;
        block28: {
            block29: {
                obj = null;
                if (fieldType != null) {
                    for (TypeEnum typeEnu : TypeEnum.values()) {
                        if (!typeEnu.getValue().equals(fieldType)) continue;
                        typeEnum = typeEnu;
                        break;
                    }
                }
                if (null == value || "".equals(value)) break block29;
                switch (typeEnum) {
                    case STRING: {
                        obj = value;
                        break block28;
                    }
                    case DATE: {
                        try {
                            obj = config.getDateStyleEnum().getFormartStyle().parse(value);
                            break block28;
                        }
                        catch (ParseException ex) {
                            throw new NoticeException("\u65f6\u95f4\u8f6c\u6362\u9519\u8bef-->\u65f6\u95f4\u683c\u5f0f\u662f: " + config.getDateStyleEnum().getFormartStyle() + " \u5f85\u5904\u7406\u7684\u6570\u636e\u662f: " + value, ex);
                        }
                    }
                    case CHAR: {
                        obj = Character.valueOf(value.toCharArray()[0]);
                        break block28;
                    }
                    case BYTE: 
                    case BYTE_MIN: {
                        obj = Byte.valueOf(value);
                        break block28;
                    }
                    case LONG: 
                    case LONG_MIN: {
                        obj = Long.parseLong(value);
                        break block28;
                    }
                    case SHORT: 
                    case SHORT_MIN: {
                        obj = Short.parseShort(value);
                        break block28;
                    }
                    case FLOAT: 
                    case FLOAT_MIN: {
                        obj = Float.valueOf(Float.parseFloat(value));
                        break block28;
                    }
                    case DOUBLE: 
                    case DOUBLE_MIN: {
                        obj = Double.parseDouble(value);
                        break block28;
                    }
                    case INT: 
                    case INTEGER: {
                        obj = Integer.parseInt(value);
                        break block28;
                    }
                    case BOOLEAN: 
                    case BOOLEAN_MIN: {
                        obj = Boolean.parseBoolean(value);
                        break block28;
                    }
                    case BIGDECIMAL: {
                        obj = new BigDecimal(value);
                        break block28;
                    }
                    default: {
                        throw new NoticeException("\u672a\u5b9a\u4e49\u7c7b\u578b\u9519\u8bef: " + typeEnum.getValue() + " \u5f85\u5904\u7406\u6570\u503c: " + value);
                    }
                }
            }
            switch (typeEnum) {
                case STRING: {
                    obj = value;
                    break;
                }
                case CHAR: {
                    return;
                }
                case SHORT_MIN: {
                    obj = (short)0;
                    break;
                }
                case BYTE_MIN: {
                    obj = Byte.parseByte("0");
                    break;
                }
                case BOOLEAN: 
                case BOOLEAN_MIN: {
                    obj = false;
                    break;
                }
                case LONG_MIN: 
                case FLOAT_MIN: 
                case DOUBLE_MIN: 
                case INT: {
                    obj = 0;
                    break;
                }
                case DATE: 
                case BYTE: 
                case LONG: 
                case SHORT: 
                case FLOAT: 
                case DOUBLE: 
                case INTEGER: 
                case BIGDECIMAL: {
                    obj = null;
                    break;
                }
                default: {
                    throw new NoticeException("\u672a\u5b9a\u4e49\u7c7b\u578b\u9519\u8bef: " + typeEnum.getValue() + " \u5f85\u5904\u7406\u6570\u503c: " + value);
                }
            }
        }
        try {
            method.invoke(e, obj);
        }
        catch (Exception ex) {
            throw new NoticeException("\u586b\u585e\u5bf9\u8c61\u503c\u9519\u8bef-->\u5bf9\u8c61\u540d\u662f: " + e.getClass().getSimpleName() + " \u7c7b\u578b\u53ef\u80fd\u672a\u5728:" + typeEnum.toString() + " \u5f85\u5904\u7406\u6570\u503c: " + value + " \u8f6c\u6362\u4e3a: " + obj);
        }
    }

    public static Object processingTimeType(Class<?> clazz, Config config, Object obj) {
        if (TypeEnum.DATE.getValue().equals(clazz.getSimpleName())) {
            return config.getDateStyleEnum().getFormartStyle().format(obj);
        }
        return obj;
    }

    public static enum TypeEnum {
        BOOLEAN("Boolean"),
        BYTE("Byte"),
        SHORT("Short"),
        INTEGER("Integer"),
        LONG("Long"),
        FLOAT("Float"),
        DOUBLE("Double"),
        STRING("String"),
        BIGDECIMAL("BigDecimal"),
        DATE("Date"),
        CHAR("char"),
        INT("int"),
        BOOLEAN_MIN("boolean"),
        BYTE_MIN("byte"),
        SHORT_MIN("short"),
        LONG_MIN("long"),
        FLOAT_MIN("float"),
        DOUBLE_MIN("double");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

