/*
 * Decompiled with CFR 0.152.
 */
package top.hihuzi.collection.fill.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import top.hihuzi.collection.cache.ClassCache;
import top.hihuzi.collection.cache.ParameterCache;
import top.hihuzi.collection.cache.TypeCache;
import top.hihuzi.collection.common.Invoke;
import top.hihuzi.collection.common.PublicMethod;
import top.hihuzi.collection.common.ValueHandleCache;
import top.hihuzi.collection.exception.NoticeException;
import top.hihuzi.collection.fill.config.FillConfig;
import top.hihuzi.collection.fill.factory.FillMethodFactory;
import top.hihuzi.collection.utils.StrUtils;

abstract class AbstractFill
implements FillMethodFactory {
    AbstractFill() {
    }

    Map fillDefault(ServletRequest request, FillConfig config, String ... key) {
        HashMap map = new HashMap(request.getParameterMap().size());
        List<String> exclude = null;
        if (StrUtils.isNNoE(key).booleanValue()) {
            exclude = Arrays.asList(key);
        }
        Enumeration<String> pars = request.getParameterNames();
        while (pars.hasMoreElements()) {
            String name = pars.nextElement().toString().trim();
            String value = request.getParameter(name);
            if (StrUtils.isNNoEC(exclude).booleanValue()) {
                if (exclude.contains(name)) continue;
                this.fillToMap(config, map, name, value);
                continue;
            }
            this.fillToMap(config, map, name, value);
        }
        return map;
    }

    private void fillToMap(FillConfig config, Map map, String name, String value) {
        if (StrUtils.isNNoE(value).booleanValue()) {
            map.put(name, value);
        } else if (config.getSaveStyleEnum().getHaving().booleanValue()) {
            map.put(name, value);
        }
    }

    <E> E requestFillEntityDefault(ServletRequest request, E e, FillConfig config) {
        Enumeration<String> pars = request.getParameterNames();
        Class<?> clazz = e.getClass();
        while (pars.hasMoreElements()) {
            String name = pars.nextElement().toString().trim();
            String value = request.getParameter(name);
            if (StrUtils.isNNoE(value).booleanValue()) {
                Invoke.processResult(e, config, clazz, name, value);
                continue;
            }
            if (!config.getSaveStyleEnum().getHaving().booleanValue()) continue;
            Invoke.processResult(e, config, clazz, name, value);
        }
        return e;
    }

    <E> E mapFillEntity(Map map, E e, FillConfig config) {
        Iterator iterator = map.entrySet().iterator();
        Class<?> clazz = e.getClass();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            if (StrUtils.isNNoE(value).booleanValue()) {
                Invoke.processResult(e, config, clazz, name, value);
                continue;
            }
            if (null == config || !config.getSaveStyleEnum().getHaving().booleanValue()) continue;
            Invoke.processResult(e, config, clazz, name, value);
        }
        return e;
    }

    public <E> Map fillMapDefault(E e, Map map, FillConfig config) {
        Map<String, TypeCache> caches = ClassCache.getCache(e.getClass());
        if (null != caches) {
            for (Map.Entry<String, TypeCache> typeCache : caches.entrySet()) {
                TypeCache cache = typeCache.getValue();
                Method methodGet = cache.getMethodGet();
                methodGet.setAccessible(true);
                Object invoke = null;
                try {
                    invoke = methodGet.invoke(e, new Object[0]);
                }
                catch (Exception ex) {
                    throw new NoticeException("\u7c7b\u83b7\u53d6\u5c5e\u6027\u503c\u9519\u8bef-->\u7c7b\u662f: " + e.getClass().getSimpleName() + " \u65b9\u6cd5\u540d\u662f: " + methodGet.getName(), ex);
                }
                if (!config.getSaveStyleEnum().getHaving().booleanValue() || null == invoke) continue;
                invoke = ValueHandleCache.processingTimeType(cache.getParamtertype(), config, invoke);
                map.put(typeCache.getKey(), invoke);
            }
        } else {
            Field[] declaredFields;
            Class<?> clazz = e.getClass();
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Class<?> type = field.getType();
                Method method = null;
                Object invoke = null;
                try {
                    method = clazz.getMethod(StrUtils.achieveGetFunction(field.getName()), new Class[0]);
                    invoke = method.invoke(e, new Object[0]);
                }
                catch (Exception ex) {
                    throw new NoticeException("\u7c7b\u83b7\u53d6\u65b9\u6cd5\u6216\u8005\u83b7\u53d6\u65b9\u6cd5\u503c\u9519\u8bef-->\u7c7b\u662f: " + e.getClass().getSimpleName() + " \u5c5e\u6027\u662f\u540d\u662f: " + StrUtils.achieveGetFunction(field.getName()), ex);
                }
                ClassCache.get().add(e.getClass(), field.getName(), type);
                if (!config.getSaveStyleEnum().getHaving().booleanValue() || null == invoke) continue;
                invoke = ValueHandleCache.processingTimeType(type, config, invoke);
                map.put(field.getName(), invoke);
            }
        }
        return map;
    }

    public <E> List<E> listToEntityDefault(List<String> list, E e, FillConfig config) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        ArrayList<String> field = new ArrayList<String>(e.getClass().getDeclaredFields().length);
        ArrayList fieldsMap = new ArrayList(field.size());
        for (Class<?> clazz = e.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field value : fields = clazz.getDeclaredFields()) {
                field.add(value.getName());
                ClassCache.get().add(e.getClass(), value.getName(), value.getType());
            }
        }
        int i = 0;
        Integer[] sort = config.getSortStyleEnum().getSort();
        if (StrUtils.isNNoEE(config).booleanValue() && StrUtils.isNNoEE(sort).booleanValue() && 0 != sort.length) {
            for (Integer integer : sort) {
                if (integer < field.size() && i <= field.size()) {
                    fieldsMap.add(field.get(integer));
                } else {
                    fieldsMap.add("");
                }
                ++i;
            }
        } else {
            fieldsMap = field;
        }
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        i = 0;
        for (String fields : fieldsMap) {
            if (i >= list.size()) continue;
            map.put(fields, list.get(i));
            ++i;
        }
        Object obj = null;
        try {
            obj = e.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new NoticeException("\u7c7b\u521b\u5efa\u5bf9\u8c61\u9519\u8bef-->\u7c7b\u540d\u662f: " + e.getClass().getSimpleName(), ex);
        }
        obj = this.mapFillEntity(map, obj, config);
        result.add(obj);
        return result;
    }

    <E> Object listToClassDefault(List<Map> list, FillConfig config, E ... e) {
        ArrayList lm = new ArrayList(list.size());
        Object newClazz = null;
        Map<String, ParameterCache> tableNameMatchParameter = PublicMethod.tableNameMatchParameter(list.get(0), e);
        switch (config.getReturnEnum()) {
            case DEFAULT: 
            case LISR: {
                for (Map map : list) {
                    HashMap<String, Object> map0 = new HashMap<String, Object>(map.size());
                    Iterator iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry entry = obj = iterator.next();
                        String names = String.valueOf(entry.getKey());
                        String values = String.valueOf(entry.getValue());
                        ParameterCache parameterCache = tableNameMatchParameter.get(names);
                        if (null == parameterCache) continue;
                        TypeCache typeCache = parameterCache.getCache().get(names);
                        map0.put(typeCache.getParamterName(), PublicMethod.processTimeType(typeCache.getParamtertype(), config, values));
                    }
                    lm.add(map0);
                }
                return lm;
            }
        }
        HashMap m = new HashMap(e.length);
        for (E es : e) {
            Class<?> clazz = es.getClass();
            for (Map map : list) {
                try {
                    newClazz = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    throw new NoticeException("\u7c7b\u521b\u5efa\u65b0\u5bf9\u8c61\u9519\u8bef-->\u7c7b\u540d\u662f: " + e.getClass().getSimpleName(), ex);
                }
                Iterator ex = map.entrySet().iterator();
                while (ex.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = ex.next();
                    String names = String.valueOf(entry.getKey());
                    String values = String.valueOf(entry.getValue());
                    ParameterCache pCache = ClassCache.getPCache(clazz, names);
                    if (null == pCache) continue;
                    Map<String, TypeCache> ptCache = pCache.getCache();
                    TypeCache cache = ptCache.get(names);
                    ValueHandleCache.invokeValue(newClazz, cache.getMethodSet(), values, null, config, cache.getType());
                }
                List lis = (List)m.get(newClazz.getClass().getSimpleName());
                if (null != lis) {
                    lis.add(newClazz);
                    continue;
                }
                ArrayList<Object> li = new ArrayList<Object>(list.size());
                li.add(newClazz);
                m.put(newClazz.getClass().getSimpleName(), li);
            }
        }
        switch (config.getReturnEnum()) {
            case MAP: {
                return m;
            }
            case FILL_LIST: {
                int i = 0;
                try {
                    for (E es : e) {
                        config.getReturnEnum().getList()[i].addAll((Collection)m.get(es.getClass().getSimpleName()));
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new NoticeException("\u4ece\u65b0\u914d\u7f6elist\u987a\u5e8f\u6709\u8bef", ex);
                }
                return true;
            }
            case FILL_CLASS: {
                return m.get(e[0].getClass().getSimpleName());
            }
        }
        return null;
    }
}

