/*
 * Decompiled with CFR 0.152.
 */
package top.hihuzi.collection.sql.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.hihuzi.collection.cache.ClassCache;
import top.hihuzi.collection.config.CacheBean;
import top.hihuzi.collection.exception.NoticeException;
import top.hihuzi.collection.utils.Md5;
import top.hihuzi.collection.utils.StrUtils;

public class SqlBean
implements CacheBean {
    private String unique;
    private List<Class<?>> clazz;
    private Map<String, String> nickname;
    private List<String> nick;
    private List<String> repeat;
    private List<String> display;
    private List<String> displayDiy;
    private Map<String, Map<String, String>> displayParamAndNickname;
    private Map<String, String> displayNickname;

    public SqlBean(String unique, List<Class<?>> clazz, Map nickname, List<String> repeat, List<String> display) {
        this.unique = unique;
        this.clazz = clazz;
        this.nickname = nickname;
        this.repeat = repeat;
        this.display = display;
    }

    public SqlBean() {
    }

    public SqlBean addUnique(Object unique) {
        this.unique = String.valueOf(unique);
        return this;
    }

    public List<Class<?>> getClazz() {
        return this.clazz;
    }

    public <E> SqlBean addClazz(E ... e) {
        ArrayList list = new ArrayList();
        for (E es : e) {
            list.add(es.getClass());
        }
        this.clazz = list;
        return this;
    }

    public Map getNickname() {
        return this.nickname;
    }

    public <E> SqlBean addNickname(E ... e) {
        this.nick = Arrays.asList(e);
        return this;
    }

    public List<String> getRepeat() {
        return this.repeat;
    }

    public <E> SqlBean addRepeat(E ... e) {
        this.repeat = Arrays.asList(e);
        return this;
    }

    public List<String> getDisplay() {
        return this.display;
    }

    public Map<String, String> getDisplayNickname() {
        return this.displayNickname;
    }

    public Map<String, Map<String, String>> getDisplayParamAndNickname() {
        return this.displayParamAndNickname;
    }

    public <E> SqlBean addDisplay(E ... e) {
        List<String> displayTemp;
        try {
            displayTemp = Arrays.asList(e);
            this.display = new ArrayList<String>(15);
        }
        catch (Exception ex) {
            throw new NoticeException("\u5f85\u5c55\u793a\u6570\u636e\u5fc5\u987b\u662fString\u7c7b\u578b");
        }
        for (String disp : displayTemp) {
            String dis = disp.trim();
            if (!dis.contains(".") && !dis.contains(" ")) {
                this.display.add(dis);
                continue;
            }
            if (dis.contains(".") && !dis.contains(" ")) {
                String[] clazztableName = dis.split("\\.");
                this.display.add(clazztableName[1]);
                this.deployDisplayNickMap(clazztableName[0], clazztableName[1], clazztableName[1]);
                continue;
            }
            if (dis.contains(".") && dis.contains(" ")) {
                String[] clazzTableName = dis.split("\\.");
                String[] tableName = clazzTableName[1].split("[\\s]{1,}");
                this.display.add(tableName[0]);
                this.deployDisplayNickMap(clazzTableName[0], tableName[0], tableName[1]);
                continue;
            }
            throw new NoticeException("\u672a\u5b9a\u4e49\u7684\u89c4\u5219!\u8bf7\u91cd\u65b0\u4e2a\u914d\u7f6edisplay");
        }
        return this;
    }

    private void deployDisplayNickMap(String className, String param, String nickName) {
        if (null == this.displayParamAndNickname || 0 == this.displayParamAndNickname.size()) {
            this.displayParamAndNickname = new HashMap<String, Map<String, String>>(10);
            this.displayParamAndNickname.put(className, StrUtils.map(param, nickName));
        } else {
            Map<String, String> paramNickNameMap = this.displayParamAndNickname.get(className);
            if (null == paramNickNameMap) {
                this.displayParamAndNickname.put(className, StrUtils.map(param, nickName));
            } else {
                paramNickNameMap.put(param, nickName);
                this.displayParamAndNickname.put(className, paramNickNameMap);
            }
        }
    }

    public SqlBean build() {
        CacheBean oCache = ClassCache.getOCache(this.key());
        if (null != oCache) {
            return (SqlBean)oCache;
        }
        HashMap<String, String> map = null;
        if (1 == this.clazz.size()) {
            map = new HashMap<String, String>(1);
            map.put(this.clazz.get(0).getName(), this.nick != null ? this.nick.get(0) : "");
            this.nickname = map;
            return this;
        }
        if (null == this.clazz || this.clazz.size() == 0) {
            throw new NoticeException("addClass\u4e0d\u53ef\u4e3a\u7a7a");
        }
        HashSet<String> repeatTemp = new HashSet<String>(this.clazz.size());
        HashSet<String> repeats = new HashSet<String>(this.clazz.size());
        map = new HashMap(this.clazz.size());
        for (int i = 0; i < this.clazz.size(); ++i) {
            Map<String, String> paramNickname;
            String mark = this.nick != null && i <= this.nick.size() - 1 ? this.nick.get(i) : "";
            map.put(this.clazz.get(i).getName(), mark);
            this.achieveClassFields(repeatTemp, repeats, this.clazz.get(i));
            this.repeat = new ArrayList<String>(repeats);
            Map<String, String> map2 = paramNickname = this.displayParamAndNickname == null ? null : this.displayParamAndNickname.get(this.clazz.get(i).getSimpleName());
            if (null == paramNickname) continue;
            this.addMark(paramNickname, mark);
        }
        this.nickname = map;
        ClassCache.get().add(this.key(), this);
        return this;
    }

    private void addMark(Map<String, String> paramNickname, String mark) {
        if (null == this.displayNickname || 0 == this.displayNickname.size()) {
            this.displayNickname = new HashMap<String, String>(this.clazz.size() * 5);
        }
        for (String param : paramNickname.keySet()) {
            this.displayNickname.put(mark + StrUtils.humpToLine(param), paramNickname.get(param));
        }
    }

    private void achieveClassFields(Set<String> repeatTemp, Set<String> repeats, Class<?> clazz) {
        this.repeat = new ArrayList<String>(this.clazz.size() * 5);
        while (Object.class != clazz) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean state = repeatTemp.add(field.getName());
                if (state) continue;
                repeats.add(field.getName());
            }
            clazz = clazz.getSuperclass();
        }
    }

    public String key() {
        if (this.unique != null) {
            return this.unique.toString();
        }
        String s = String.valueOf(this.clazz) + String.valueOf(this.display) + String.valueOf(this.nick) + String.valueOf(this.repeat) + String.valueOf(this.displayNickname);
        return Md5.stringToMd5(s);
    }
}

