/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiwepy.ip2region.spring.boot;

import com.github.hiwepy.ip2region.spring.boot.IP2regionProperties;
import com.github.hiwepy.ip2region.spring.boot.IP2regionTemplate;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.nutz.plugins.ip2region.DBReader;
import org.nutz.plugins.ip2region.DbConfig;
import org.nutz.plugins.ip2region.DbMakerConfigException;
import org.nutz.plugins.ip2region.DbSearcher;
import org.nutz.plugins.ip2region.impl.ByteArrayDBReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

@Configuration
@ConditionalOnClass(value={DbSearcher.class})
@EnableConfigurationProperties(value={IP2regionProperties.class})
public class IP2regionAutoConfiguration
implements ResourceLoaderAware {
    protected ResourceLoader resourceLoader = new PathMatchingResourcePatternResolver();
    @Autowired
    private IP2regionProperties properties;

    @Bean
    public IP2regionTemplate ip2regionTemplate() throws IOException, DbMakerConfigException {
        DbSearcher dbSearcher;
        block17: {
            dbSearcher = null;
            if (this.properties.isExternal()) {
                DbConfig dbConfig = new DbConfig(this.properties.getTotalHeaderSize());
                dbConfig.setIndexBlockSize(this.properties.getIndexBlockSize());
                try {
                    if (new File(this.properties.getLocation()).exists()) {
                        ByteArrayDBReader reader = new ByteArrayDBReader(Files.readAllBytes(Paths.get(this.properties.getLocation(), new String[0])));
                        dbSearcher = new DbSearcher(dbConfig, (DBReader)reader);
                        break block17;
                    }
                    Resource resource = this.resourceLoader.getResource(this.properties.getLocation());
                    try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)output);
                        ByteArrayDBReader reader = new ByteArrayDBReader(output.toByteArray());
                        dbSearcher = new DbSearcher(dbConfig, (DBReader)reader);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dbSearcher = new DbSearcher();
                }
            } else {
                dbSearcher = new DbSearcher();
            }
        }
        return new IP2regionTemplate(dbSearcher);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

