/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiwepy.ip2region.spring.boot;

import com.github.hiwepy.ip2region.spring.boot.ext.RegionAddress;
import com.github.hiwepy.ip2region.spring.boot.ext.RegionEnum;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nutz.plugins.ip2region.DataBlock;
import org.nutz.plugins.ip2region.DbSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class IP2regionTemplate
implements DisposableBean {
    protected Logger log = LoggerFactory.getLogger(IP2regionTemplate.class);
    protected DbSearcher dbSearcher = null;
    protected ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    protected static String NOT_MATCH = "\u672a\u5206\u914d\u6216\u8005\u5185\u7f51IP|0|0|0|0";
    protected static RegionAddress NOT_MATCH_REGION_ADDRESS = new RegionAddress(NOT_MATCH.split("\\|"));

    public IP2regionTemplate(DbSearcher dbSearcher) throws IOException {
        this.dbSearcher = dbSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlock memorySearch(long ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.memorySearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public DataBlock memorySearch(String ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.memorySearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlock getByIndexPtr(long ptr) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.getByIndexPtr(ptr);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlock btreeSearch(long ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.btreeSearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public DataBlock btreeSearch(String ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.btreeSearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBlock binarySearch(long ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.binarySearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public DataBlock binarySearch(String ip) throws IOException {
        try {
            this.rwl.readLock().lock();
            DataBlock dataBlock = this.dbSearcher.binarySearch(ip);
            return dataBlock;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegion(String ip) {
        try {
            this.rwl.readLock().lock();
            String region = this.dbSearcher.memorySearch(ip).getRegion();
            this.log.debug(" IP : {} >> Region : {} ", (Object)ip, (Object)region);
            String string = region;
            return string;
        }
        catch (Exception e) {
            this.log.debug("IP : {} >> Country/Region Parser Error\uff1a{}", (Object)ip, (Object)e.getMessage());
            String string = NOT_MATCH;
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionAddress getRegionAddress(String ip) {
        try {
            this.rwl.readLock().lock();
            String region = this.dbSearcher.memorySearch(ip).getRegion();
            this.log.debug(" IP : {} >> Region : {} ", (Object)ip, (Object)region);
            RegionAddress regionAddress = new RegionAddress(region.split("\\|"));
            return regionAddress;
        }
        catch (Exception e) {
            this.log.debug("IP : {} >> Country/Region Parser Error\uff1a{}", (Object)ip, (Object)e.getMessage());
            RegionAddress regionAddress = NOT_MATCH_REGION_ADDRESS;
            return regionAddress;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCountryByIp(String ip) {
        try {
            this.rwl.readLock().lock();
            String region = this.dbSearcher.memorySearch(ip).getRegion();
            this.log.debug(" IP : {} >> Region : {} ", (Object)ip, (Object)region);
            String country = region.split("\\|")[0];
            this.log.debug(" IP : {} >> Country/Region : {} ", (Object)ip, (Object)country);
            String string = NOT_MATCH.contains(country) ? RegionEnum.UK.getCname() : country;
            return string;
        }
        catch (Exception e) {
            this.log.debug("IP : {} >> Country/Region Parser Error\uff1a{}", (Object)ip, (Object)e.getMessage());
            String string = RegionEnum.UK.getCname();
            return string;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionEnum getRegionByIp(String ip) {
        try {
            this.rwl.readLock().lock();
            String region = this.dbSearcher.memorySearch(ip).getRegion();
            this.log.debug(" IP : {} >> Region : {} ", (Object)ip, (Object)region);
            String[] regionArr = region.split("\\|");
            this.log.debug(" IP : {} >> Country : {} ", (Object)ip, (Object)regionArr[0]);
            if (NOT_MATCH.contains(regionArr[0])) {
                RegionEnum regionEnum = RegionEnum.UK;
                return regionEnum;
            }
            RegionAddress address = new RegionAddress(regionArr);
            RegionEnum regionEnum = RegionEnum.getByRegionAddress(address);
            return regionEnum;
        }
        catch (Exception e) {
            this.log.debug("IP : {} >> Country/Region Parser Error\uff1a{}", (Object)ip, (Object)e.getMessage());
            RegionEnum regionEnum = RegionEnum.UK;
            return regionEnum;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public boolean isMainlandIp(String ip) {
        RegionEnum regionEnum = this.getRegionByIp(ip);
        return RegionEnum.CN.compareTo(regionEnum) == 0 && RegionEnum.HK.compareTo(regionEnum) != 0 && RegionEnum.MO.compareTo(regionEnum) != 0 && RegionEnum.TW.compareTo(regionEnum) != 0;
    }

    public void destroy() throws Exception {
        this.dbSearcher.close();
    }
}

