/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiwepy.ip2region.spring.boot.ext;

import com.github.hiwepy.ip2region.spring.boot.ext.RegionAddress;
import org.nutz.plugins.ip2region.DataBlock;

public class DataBlockWrapper {
    private DataBlock block;
    private RegionAddress regionAddr;

    public static DataBlockWrapper wrapper(DataBlock block) {
        return new DataBlockWrapper(block);
    }

    private DataBlockWrapper(DataBlock block) {
        this.block = block;
        this.regionAddr = new RegionAddress(block.getRegion().split("\\|"));
    }

    public int getCityId() {
        return this.block.getCityId();
    }

    public DataBlock setCityId(int city_id) {
        this.block.setCityId(city_id);
        return this.block;
    }

    public String getRegion() {
        return this.block.getRegion();
    }

    public DataBlock setRegion(String region) {
        this.block.setRegion(region);
        return this.block;
    }

    public int getDataPtr() {
        return this.block.getDataPtr();
    }

    public DataBlock setDataPtr(int dataPtr) {
        this.block.setDataPtr(dataPtr);
        return this.block;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.block.getCityId()).append('|').append(this.block.getRegion()).append('|').append(this.block.getDataPtr());
        return sb.toString();
    }

    public RegionAddress getRegionAddr() {
        return this.regionAddr;
    }

    public void setRegionAddr(RegionAddress regionAddr) {
        this.regionAddr = regionAddr;
    }
}

