/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiwepy.ip2region.spring.boot.ext;

import com.github.hiwepy.ip2region.spring.boot.ext.RegionAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RegionEnum {
    AD("020", "AD ", "AND", "ISO 3166-2:AD", "Andorra", "\u5b89\u9053\u5c14 "),
    AE("784", "AE", "ARE", "ISO 3166-2:AE", "United Arab Emirates", "\u963f\u8054\u914b"),
    AF("004", "AF", "AFG", "ISO 3166-2:AF", "Afghanistan", "\u963f\u5bcc\u6c57"),
    AG("028", "AG", "ATG", "ISO 3166-2:AG", "Antigua & Barbuda", "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe"),
    AI("660", "AI", "AIA", "ISO 3166-2:AI", "Anguilla", "\u5b89\u572d\u62c9"),
    AL("008", "AL", "ALB", "ISO 3166-2:AL", "Albania", "\u963f\u5c14\u5df4\u5c3c\u4e9a"),
    AM("051", "AM", "ARM", "ISO 3166-2:AM", "Armenia", "\u4e9a\u7f8e\u5c3c\u4e9a"),
    AO("024", "AO", "AGO", "ISO 3166-2:AO", "Angola", "\u5b89\u54e5\u62c9"),
    AQ("010", "AQ", "ATA", "ISO 3166-2:AQ", "Antarctica", "\u5357\u6781\u6d32"),
    AR("032", "AR", "ARG", "ISO 3166-2:AR", "Argentina", "\u963f\u6839\u5ef7"),
    AS("016", "AS", "ASM", "ISO 3166-2:AS", "American Samoa", "\u7f8e\u5c5e\u8428\u6469\u4e9a"),
    AT("040", "AT", "AUT", "ISO 3166-2:AT", "Austria", "\u5965\u5730\u5229"),
    AU("036", "AU", "AUS", "ISO 3166-2:AU", "Australia", "\u6fb3\u5927\u5229\u4e9a"),
    AW("533", "AW", "ABW", "ISO 3166-2:AW", "Aruba", "\u963f\u9c81\u5df4"),
    AX("248", "AX", "ALA", "ISO 3166-2:AX", "?aland Island", "\u5965\u5170\u7fa4\u5c9b"),
    AZ("031", "AZ", "AZE", "ISO 3166-2:AZ", "Azerbaijan", "\u963f\u585e\u62dc\u7586"),
    BA("070", "BA", "BIH", "ISO 3166-2:BA", "Bosnia & Herzegovina", "\u6ce2\u9ed1"),
    BB("052", "BB", "BRB", "ISO 3166-2:BB", "Barbados", "\u5df4\u5df4\u591a\u65af"),
    BD("050", "BD", "BGD", "ISO 3166-2:BD", "Bangladesh", "\u5b5f\u52a0\u62c9"),
    BE("056", "BE", "BEL", "ISO 3166-2:BE", "Belgium", "\u6bd4\u5229\u65f6"),
    BF("854", "BF", "BFA", "ISO 3166-2:BF", "Burkina", "\u5e03\u57fa\u7eb3\u6cd5\u7d22"),
    BG("100", "BG", "BGR", "ISO 3166-2:BG", "Bulgaria", "\u4fdd\u52a0\u5229\u4e9a"),
    BH("048", "BH", "BHR", "ISO 3166-2:BH", "Bahrain", "\u5df4\u6797"),
    BI("108", "BI", "BDI", "ISO 3166-2:BI", "Burundi", "\u5e03\u9686\u8fea"),
    BJ("204", "BJ", "BEN", "ISO 3166-2:BJ", "Benin", "\u8d1d\u5b81"),
    BL("652", "BL", "BLM", "ISO 3166-2:BL", "Saint Barth\u00e9lemy", "\u5723\u5df4\u6cf0\u52d2\u7c73"),
    BM("060", "BM", "BMU", "ISO 3166-2:BM", "Bermuda", "\u767e\u6155\u5927"),
    BN("096", "BN", "BRN", "ISO 3166-2:BN", "Brunei", "\u6587\u83b1"),
    BO("068", "BO", "BOL", "ISO 3166-2:BO", "Bolivia", "\u73bb\u5229\u7ef4\u4e9a"),
    BQ("535", "BQ", "BES", "ISO 3166-2:BQ", "Caribbean Netherlands", "\u8377\u5170\u52a0\u52d2\u6bd4\u533a"),
    BR("076", "BR", "BRA", "ISO 3166-2:BR", "Brazil", "\u5df4\u897f"),
    BS("044", "BS", "BHS", "ISO 3166-2:BS", "The Bahamas", "\u5df4\u54c8\u9a6c"),
    BT("064", "BT", "BTN", "ISO 3166-2:BT", "Bhutan", "\u4e0d\u4e39"),
    BV("074", "BV", "BVT", "ISO 3166-2:BV", "Bouvet Island", "\u5e03\u97e6\u5c9b"),
    BW("072", "BW", "BWA", "ISO 3166-2:BW", "Botswana", "\u535a\u8328\u74e6\u7eb3"),
    BY("112", "BY", "BLR", "ISO 3166-2:BY", "Belarus", "\u767d\u4fc4\u7f57\u65af"),
    BZ("084", "BZ", "BLZ", "ISO 3166-2:BZ", "Belize", "\u4f2f\u5229\u5179"),
    CA("124", "CA", "CAN", "ISO 3166-2:CA", "Canada", "\u52a0\u62ff\u5927"),
    CC("166", "CC", "CCK", "ISO 3166-2:CC", "Cocos (Keeling) Islands", "\u79d1\u79d1\u65af\u7fa4\u5c9b"),
    CD("180", "CD", "COD", "ISO 3166-2:CD", "Democratic Republic of the Congo", "\u521a\u679c\u91d1"),
    CF("140", "CF", "CAF", "ISO 3166-2:CF", "Central African Republic", "\u4e2d\u975e"),
    CG("178", "CG", "COG", "ISO 3166-2:CG", "Republic of the Congo", "\u521a\u679c\u5e03"),
    CH("756", "CH", "CHE", "ISO 3166-2:CH", "Switzerland", "\u745e\u58eb"),
    CI("384", "CI", "CIV", "ISO 3166-2:CI", "C?te d'Ivoire", "\u79d1\u7279\u8fea\u74e6"),
    CK("184", "CK", "COK", "ISO 3166-2:CK", "Cook Islands", "\u5e93\u514b\u7fa4\u5c9b"),
    CL("152", "CL", "CHL", "ISO 3166-2:CL", "Chile", "\u667a\u5229"),
    CM("120", "CM", "CMR", "ISO 3166-2:CM", "Cameroon", "\u5580\u9ea6\u9686"),
    CN("156", "CN", "CHN", "ISO 3166-2:CN", "China", "\u4e2d\u56fd"),
    CO("170", "CO", "COL", "ISO 3166-2:CO", "Colombia", "\u54e5\u4f26\u6bd4\u4e9a"),
    CR("188", "CR", "CRI", "ISO 3166-2:CR", "Costa Rica", "\u54e5\u65af\u8fbe\u9ece\u52a0"),
    CU("192", "CU", "CUB", "ISO 3166-2:CU", "Cuba", "\u53e4\u5df4"),
    CV("132", "CV", "CPV", "ISO 3166-2:CV", "Cape Verde", "\u4f5b\u5f97\u89d2"),
    CX("162", "CX", "CXR", "ISO 3166-2:CX", "Christmas Island", "\u5723\u8bde\u5c9b"),
    CY("196", "CY", "CYP", "ISO 3166-2:CY", "Cyprus", "\u585e\u6d66\u8def\u65af"),
    CZ("203", "CZ", "CZE", "ISO 3166-2:CZ", "Czech Republic", "\u6377\u514b"),
    DE("276", "DE", "DEU", "ISO 3166-2:DE", "Germany", "\u5fb7\u56fd"),
    DJ("262", "DJ", "DJI", "ISO 3166-2:DJ", "Djibouti", "\u5409\u5e03\u63d0"),
    DK("208", "DK", "DNK", "ISO 3166-2:DK", "Denmark", "\u4e39\u9ea6"),
    DM("212", "DM", "DMA", "ISO 3166-2:DM", "Dominica", "\u591a\u7c73\u5c3c\u514b"),
    DO("214", "DO", "DOM", "ISO 3166-2:DO", "Dominican Republic", "\u591a\u7c73\u5c3c\u52a0"),
    DZ("012", "DZ", "DZA", "ISO 3166-2:DZ", "Algeria", "\u963f\u5c14\u53ca\u5229\u4e9a"),
    EC("218", "EC", "ECU", "ISO 3166-2:EC", "Ecuador", "\u5384\u74dc\u591a\u5c14"),
    EE("233", "EE", "EST", "ISO 3166-2:EE", "Estonia", "\u7231\u6c99\u5c3c\u4e9a"),
    EG("818", "EG", "EGY", "ISO 3166-2:EG", "Egypt", "\u57c3\u53ca"),
    EH("732", "EH", "ESH", "ISO 3166-2:EH", "Western Sahara", "\u897f\u6492\u54c8\u62c9"),
    ER("232", "ER", "ERI", "ISO 3166-2:ER", "Eritrea", "\u5384\u7acb\u7279\u91cc\u4e9a"),
    ES("724", "ES", "ESP", "ISO 3166-2:ES", "Spain", "\u897f\u73ed\u7259"),
    ET("231", "ET", "ETH", "ISO 3166-2:ET", "Ethiopia", "\u57c3\u585e\u4fc4\u6bd4\u4e9a"),
    FI("246", "FI", "FIN", "ISO 3166-2:FI", "Finland", "\u82ac\u5170"),
    FJ("242", "FJ", "FJI", "ISO 3166-2:FJ", "Fiji", "\u6590\u6d4e"),
    FK("238", "FK", "FLK", "ISO 3166-2:FK", "Falkland Islands", "\u9a6c\u5c14\u7ef4\u7eb3\u65af\u7fa4\u5c9b\uff08 \u798f\u514b\u5170\uff09"),
    FM("583", "FM", "FSM", "ISO 3166-2:FM", "Federated States of Micronesia", "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a"),
    FO("234", "FO", "FRO", "ISO 3166-2:FO", "Faroe Islands", "\u6cd5\u7f57\u7fa4\u5c9b"),
    FR("250", "FR", "FRA", "ISO 3166-2:FR", "France", "\u6cd5\u56fd"),
    GA("266", "GA", "GAB", "ISO 3166-2:GA", "Gabon", "\u52a0\u84ec"),
    GB("826", "GB", "GBR", "ISO 3166-2:GB", "Great Britain (United Kingdom; England)", "\u82f1\u56fd"),
    GD("308", "GD", "GRD", "ISO 3166-2:GD", "Grenada", "\u683c\u6797\u7eb3\u8fbe"),
    GE("268", "GE", "GEO", "ISO 3166-2:GE", "Georgia", "\u683c\u9c81\u5409\u4e9a"),
    GF("254", "GF", "GUF", "ISO 3166-2:GF", "French Guiana", "\u6cd5\u5c5e\u572d\u4e9a\u90a3"),
    GG("831", "GG", "GGY", "ISO 3166-2:GG", "Guernsey", "\u6839\u897f\u5c9b"),
    GH("288", "GH", "GHA", "ISO 3166-2:GH", "Ghana", "\u52a0\u7eb3"),
    GI("292", "GI", "GIB", "ISO 3166-2:GI", "Gibraltar", "\u76f4\u5e03\u7f57\u9640"),
    GL("304", "GL", "GRL", "ISO 3166-2:GL", "Greenland", "\u683c\u9675\u5170"),
    GM("270", "GM", "GMB", "ISO 3166-2:GM", "Gambia", "\u5188\u6bd4\u4e9a"),
    GN("324", "GN", "GIN", "ISO 3166-2:GN", "Guinea", "\u51e0\u5185\u4e9a"),
    GP("312", "GP", "GLP", "ISO 3166-2:GP", "Guadeloupe", "\u74dc\u5fb7\u7f57\u666e"),
    GQ("226", "GQ", "GNQ", "ISO 3166-2:GQ", "Equatorial Guinea", "\u8d64\u9053\u51e0\u5185\u4e9a"),
    GR("300", "GR", "GRC", "ISO 3166-2:GR", "Greece", "\u5e0c\u814a"),
    GS("239", "GS", "SGS", "ISO 3166-2:GS", "South Georgia and the South Sandwich Islands", "\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b"),
    GT("320", "GT", "GTM", "ISO 3166-2:GT", "Guatemala", "\u5371\u5730\u9a6c\u62c9"),
    GU("316", "GU", "GUM", "ISO 3166-2:GU", "Guam", "\u5173\u5c9b"),
    GW("624", "GW", "GNB", "ISO 3166-2:GW", "Guinea-Bissau", "\u51e0\u5185\u4e9a\u6bd4\u7ecd"),
    GY("328", "GY", "GUY", "ISO 3166-2:GY", "Guyana", "\u572d\u4e9a\u90a3"),
    HK("344", "HK", "HKG", "ISO 3166-2:HK", "Hong Kong", "\u4e2d\u56fd\u9999\u6e2f"),
    HM("334", "HM", "HMD", "ISO 3166-2:HM", "Heard Island and McDonald Islands", "\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b"),
    HN("340", "HN", "HND", "ISO 3166-2:HN", "Honduras", "\u6d2a\u90fd\u62c9\u65af"),
    HR("191", "HR", "HRV", "ISO 3166-2:HR", "Croatia", "\u514b\u7f57\u5730\u4e9a"),
    HT("332", "HT", "HTI", "ISO 3166-2:HT", "Haiti", "\u6d77\u5730"),
    HU("348", "HU", "HUN", "ISO 3166-2:HU", "Hungary", "\u5308\u7259\u5229"),
    ID("360", "ID", "IDN", "ISO 3166-2:ID", "Indonesia", "\u5370\u5ea6\u5c3c\u897f\u4e9a"),
    IE("372", "IE", "IRL", "ISO 3166-2:IE", "Ireland", "\u7231\u5c14\u5170"),
    IL("376", "IL", "ISR", "ISO 3166-2:IL", "Israel", "\u4ee5\u8272\u5217"),
    IM("833", "IM", "IMN", "ISO 3166-2:IM", "Isle of Man", "\u9a6c\u6069\u5c9b"),
    IN("356", "IN", "IND", "ISO 3166-2:IN", "India", "\u5370\u5ea6"),
    IO("086", "IO", "IOT", "ISO 3166-2:IO", "British Indian Ocean Territory", "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730"),
    IQ("368", "IQ", "IRQ", "ISO 3166-2:IQ", "Iraq", "\u4f0a\u62c9\u514b"),
    IR("364", "IR", "IRN", "ISO 3166-2:IR", "Iran", "\u4f0a\u6717"),
    IS("352", "IS", "ISL", "ISO 3166-2:IS", "Iceland", "\u51b0\u5c9b"),
    IT("380", "IT", "ITA", "ISO 3166-2:IT", "Italy", "\u610f\u5927\u5229"),
    JE("832", "JE", "JEY", "ISO 3166-2:JE", "Jersey", "\u6cfd\u897f\u5c9b"),
    JM("388", "JM", "JAM", "ISO 3166-2:JM", "Jamaica", "\u7259\u4e70\u52a0"),
    JO("400", "JO", "JOR", "ISO 3166-2:JO", "Jordan", "\u7ea6\u65e6"),
    JP("392", "JP", "JPN", "ISO 3166-2:JP", "Japan", "\u65e5\u672c"),
    KE("404", "KE", "KEN", "ISO 3166-2:KE", "Kenya", "\u80af\u5c3c\u4e9a"),
    KG("417", "KG", "KGZ", "ISO 3166-2:KG", "Kyrgyzstan", "\u5409\u5c14\u5409\u65af\u65af\u5766"),
    KH("116", "KH", "KHM", "ISO 3166-2:KH", "Cambodia", "\u67ec\u57d4\u5be8"),
    KI("296", "KI", "KIR", "ISO 3166-2:KI", "Kiribati", "\u57fa\u91cc\u5df4\u65af"),
    KM("174", "KM", "COM", "ISO 3166-2:KM", "The Comoros", "\u79d1\u6469\u7f57"),
    KN("659", "KN", "KNA", "ISO 3166-2:KN", "St. Kitts & Nevis", "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af"),
    KP("408", "KP", "PRK", "ISO 3166-2:KP", "North Korea", "\u671d\u9c9c"),
    KR("410", "KR", "KOR", "ISO 3166-2:KR", "South Korea", "\u97e9\u56fd"),
    KW("414", "KW", "KWT", "ISO 3166-2:KW", "Kuwait", "\u79d1\u5a01\u7279"),
    KY("136", "KY", "CYM", "ISO 3166-2:KY", "Cayman Islands", "\u5f00\u66fc\u7fa4\u5c9b"),
    KZ("398", "KZ", "KAZ", "ISO 3166-2:KZ", "Kazakhstan", "\u54c8\u8428\u514b\u65af\u5766"),
    LA("418", "LA", "LAO", "ISO 3166-2:LA", "Laos", "\u8001\u631d"),
    LB("422", "LB", "LBN", "ISO 3166-2:LB", "Lebanon", "\u9ece\u5df4\u5ae9"),
    LC("662", "LC", "LCA", "ISO 3166-2:LC", "St. Lucia", "\u5723\u5362\u897f\u4e9a"),
    LI("438", "LI", "LIE", "ISO 3166-2:LI", "Liechtenstein", "\u5217\u652f\u6566\u58eb\u767b"),
    LK("144", "LK", "LKA", "ISO 3166-2:LK", "Sri Lanka", "\u65af\u91cc\u5170\u5361"),
    LR("430", "LR", "LBR", "ISO 3166-2:LR", "Liberia", "\u5229\u6bd4\u91cc\u4e9a"),
    LS("426", "LS", "LSO", "ISO 3166-2:LS", "Lesotho", "\u83b1\u7d22\u6258"),
    LT("440", "LT", "LTU", "ISO 3166-2:LT", "Lithuania", "\u7acb\u9676\u5b9b"),
    LU("442", "LU", "LUX", "ISO 3166-2:LU", "Luxembourg", "\u5362\u68ee\u5821"),
    LV("428", "LV", "LVA", "ISO 3166-2:LV", "Latvia", "\u62c9\u8131\u7ef4\u4e9a"),
    LY("434", "LY", "LBY", "ISO 3166-2:LY", "Libya", "\u5229\u6bd4\u4e9a"),
    MA("504", "MA", "MAR", "ISO 3166-2:MA", "Morocco", "\u6469\u6d1b\u54e5"),
    MC("492", "MC", "MCO", "ISO 3166-2:MC", "Monaco", "\u6469\u7eb3\u54e5"),
    MD("498", "MD", "MDA", "ISO 3166-2:MD", "Moldova", "\u6469\u5c14\u591a\u74e6"),
    ME("499", "ME", "MNE", "ISO 3166-2:ME", "Montenegro", "\u9ed1\u5c71"),
    MF("663", "MF", "MAF", "ISO 3166-2:MF", "Saint Martin (France)", "\u5723\u9a6c\u4e01"),
    MG("450", "MG", "MDG", "ISO 3166-2:MG", "Madagascar", "\u9a6c\u8fbe\u52a0\u65af\u52a0"),
    MH("584", "MH", "MHL", "ISO 3166-2:MH", "Marshall islands", "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b"),
    MK("807", "MK", "MKD", "ISO 3166-2:MK", "Republic of Macedonia (FYROM)", "\u9a6c\u5176\u987f"),
    ML("466", "ML", "MLI", "ISO 3166-2:ML", "Mali", "\u9a6c\u91cc"),
    MM("104", "MM", "MMR", "ISO 3166-2:MM", "Myanmar (Burma)", "\u7f05\u7538"),
    MN("496", "MN", "MNG", "ISO 3166-2:MN", "Mongolia", "\u8499\u53e4"),
    MO("446", "MO", "MAC", "ISO 3166-2:MO", "Macao", "\u4e2d\u56fd\u6fb3\u95e8"),
    MP("580", "MP", "MNP", "ISO 3166-2:MP", "Northern Mariana Islands", "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b"),
    MQ("474", "MQ", "MTQ", "ISO 3166-2:MQ", "Martinique", "\u9a6c\u63d0\u5c3c\u514b"),
    MR("478", "MR", "MRT", "ISO 3166-2:MR", "Mauritania", "\u6bdb\u91cc\u5854\u5c3c\u4e9a"),
    MS("500", "MS", "MSR", "ISO 3166-2:MS", "Montserrat", "\u8499\u585e\u62c9\u7279\u5c9b"),
    MT("470", "MT", "MLT", "ISO 3166-2:MT", "Malta", "\u9a6c\u8033\u4ed6"),
    MU("480", "MU", "MUS", "ISO 3166-2:MU", "Mauritius", "\u6bdb\u91cc\u6c42\u65af"),
    MV("462", "MV", "MDV", "ISO 3166-2:MV", "Maldives", "\u9a6c\u5c14\u4ee3\u592b"),
    MW("454", "MW", "MWI", "ISO 3166-2:MW", "Malawi", "\u9a6c\u62c9\u7ef4"),
    MX("484", "MX", "MEX", "ISO 3166-2:MX", "Mexico", "\u58a8\u897f\u54e5"),
    MY("458", "MY", "MYS", "ISO 3166-2:MY", "Malaysia", "\u9a6c\u6765\u897f\u4e9a"),
    MZ("508", "MZ", "MOZ", "ISO 3166-2:MZ", "Mozambique", "\u83ab\u6851\u6bd4\u514b"),
    NA("516", "NA", "NAM", "ISO 3166-2:NA", "Namibia", "\u7eb3\u7c73\u6bd4\u4e9a"),
    NC("540", "NC", "NCL", "ISO 3166-2:NC", "New Caledonia", "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a"),
    NE("562", "NE", "NER", "ISO 3166-2:NE", "Niger", "\u5c3c\u65e5\u5c14"),
    NF("574", "NF", "NFK", "ISO 3166-2:NF", "Norfolk Island", "\u8bfa\u798f\u514b\u5c9b"),
    NG("566", "NG", "NGA", "ISO 3166-2:NG", "Nigeria", "\u5c3c\u65e5\u5229\u4e9a"),
    NI("558", "NI", "NIC", "ISO 3166-2:NI", "Nicaragua", "\u5c3c\u52a0\u62c9\u74dc"),
    NL("528", "NL", "NLD", "ISO 3166-2:NL", "Netherlands", "\u8377\u5170"),
    NO("578", "NO", "NOR", "ISO 3166-2:NO", "Norway", "\u632a\u5a01"),
    NP("524", "NP", "NPL", "ISO 3166-2:NP", "Nepal", "\u5c3c\u6cca\u5c14"),
    NR("520", "NR", "NRU", "ISO 3166-2:NR", "Nauru", "\u7459\u9c81"),
    NU("570", "NU", "NIU", "ISO 3166-2:NU", "Niue", "\u7ebd\u57c3"),
    NZ("554", "NZ", "NZL", "ISO 3166-2:NZ", "New Zealand", "\u65b0\u897f\u5170"),
    OM("512", "OM", "OMN", "ISO 3166-2:OM", "Oman", "\u963f\u66fc"),
    PA("591", "PA", "PAN", "ISO 3166-2:PA", "Panama", "\u5df4\u62ff\u9a6c"),
    PE("604", "PE", "PER", "ISO 3166-2:PE", "Peru", "\u79d8\u9c81"),
    PF("258", "PF", "PYF", "ISO 3166-2:PF", "French polynesia", "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a"),
    PG("598", "PG", "PNG", "ISO 3166-2:PG", "Papua New Guinea", "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a"),
    PH("608", "PH", "PHL", "ISO 3166-2:PH", "The Philippines", "\u83f2\u5f8b\u5bbe"),
    PK("586", "PK", "PAK", "ISO 3166-2:PK", "Pakistan", "\u5df4\u57fa\u65af\u5766"),
    PL("616", "PL", "POL", "ISO 3166-2:PL", "Poland", "\u6ce2\u5170"),
    PM("666", "PM", "SPM", "ISO 3166-2:PM", "Saint-Pierre and Miquelon", "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b"),
    PN("612", "PN", "PCN", "ISO 3166-2:PN", "Pitcairn Islands", "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b"),
    PR("630", "PR", "PRI", "ISO 3166-2:PR", "Puerto Rico", "\u6ce2\u591a\u9ece\u5404"),
    PS("275", "PS", "PSE", "ISO 3166-2:PS", "Palestinian territories", "\u5df4\u52d2\u65af\u5766"),
    PT("620", "PT", "PRT", "ISO 3166-2:PT", "Portugal", "\u8461\u8404\u7259"),
    PW("585", "PW", "PLW", "ISO 3166-2:PW", "Palau", "\u5e15\u52b3"),
    PY("600", "PY", "PRY", "ISO 3166-2:PY", "Paraguay", "\u5df4\u62c9\u572d"),
    QA("634", "QA", "QAT", "ISO 3166-2:QA", "Qatar", "\u5361\u5854\u5c14"),
    RE("638", "RE", "REU", "ISO 3166-2:RE", "R\u00e9union", "\u7559\u5c3c\u65fa"),
    RO("642", "RO", "ROU", "ISO 3166-2:RO", "Romania", "\u7f57\u9a6c\u5c3c\u4e9a"),
    RS("688", "RS", "SRB", "ISO 3166-2:RS", "Serbia", "\u585e\u5c14\u7ef4\u4e9a"),
    RU("643", "RU", "RUS", "ISO 3166-2:RU", "Russian Federation", "\u4fc4\u7f57\u65af"),
    RW("646", "RW", "RWA", "ISO 3166-2:RW", "Rwanda", "\u5362\u65fa\u8fbe"),
    SA("682", "SA", "SAU", "ISO 3166-2:SA", "Saudi Arabia", "\u6c99\u7279\u963f\u62c9\u4f2f"),
    SB("090", "SB", "SLB", "ISO 3166-2:SB", "Solomon Islands", "\u6240\u7f57\u95e8\u7fa4\u5c9b"),
    SC("690", "SC", "SYC", "ISO 3166-2:SC", "Seychelles", "\u585e\u820c\u5c14"),
    SD("729", "SD", "SDN", "ISO 3166-2:SD", "Sudan", "\u82cf\u4e39"),
    SE("752", "SE", "SWE", "ISO 3166-2:SE", "Sweden", "\u745e\u5178"),
    SG("702", "SG", "SGP", "ISO 3166-2:SG", "Singapore", "\u65b0\u52a0\u5761"),
    SH("654", "SH", "SHN", "ISO 3166-2:SH", "St. Helena & Dependencies", "\u5723\u8d6b\u52d2\u62ff"),
    SI("705", "SI", "SVN", "ISO 3166-2:SI", "Slovenia", "\u65af\u6d1b\u6587\u5c3c\u4e9a"),
    SJ("744", "SJ", "SJM", "ISO 3166-2:SJ", "Template:Country data SJM Svalbard", "\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b\u548c\u626c\u9a6c\u5ef6\u5c9b"),
    SK("703", "SK", "SVK", "ISO 3166-2:SK", "Slovakia", "\u65af\u6d1b\u4f10\u514b"),
    SL("694", "SL", "SLE", "ISO 3166-2:SL", "Sierra Leone", "\u585e\u62c9\u5229\u6602"),
    SM("674", "SM", "SMR", "ISO 3166-2:SM", "San Marino", "\u5723\u9a6c\u529b\u8bfa"),
    SN("686", "SN", "SEN", "ISO 3166-2:SN", "Senegal", "\u585e\u5185\u52a0\u5c14"),
    SO("706", "SO", "SOM", "ISO 3166-2:SO", "Somalia", "\u7d22\u9a6c\u91cc"),
    SR("740", "SR", "SUR", "ISO 3166-2:SR", "Suriname", "\u82cf\u91cc\u5357"),
    SS("728", "SS", "SSD", "ISO 3166-2:SS", "South Sudan", "\u5357\u82cf\u4e39"),
    ST("678", "ST", "STP", "ISO 3166-2:ST", "Sao Tome & Principe", "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4"),
    SV("222", "SV", "SLV", "ISO 3166-2:SV", "El Salvador", "\u8428\u5c14\u74e6\u591a"),
    SY("760", "SY", "SYR", "ISO 3166-2:SY", "Syria", "\u53d9\u5229\u4e9a"),
    SZ("748", "SZ", "SWZ", "ISO 3166-2:SZ", "Swaziland", "\u65af\u5a01\u58eb\u5170"),
    TC("796", "TC", "TCA", "ISO 3166-2:TC", "Turks & Caicos Islands", "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b"),
    TD("148", "TD", "TCD", "ISO 3166-2:TD", "Chad", "\u4e4d\u5f97"),
    TF("260", "TF", "ATF", "ISO 3166-2:TF", "French Southern Territories", "\u6cd5\u5c5e\u5357\u90e8\u9886\u5730"),
    TG("768", "TG", "TGO", "ISO 3166-2:TG", "Togo", "\u591a\u54e5"),
    TH("764", "TH", "THA", "ISO 3166-2:TH", "Thailand", "\u6cf0\u56fd"),
    TJ("762", "TJ", "TJK", "ISO 3166-2:TJ", "Tajikistan", "\u5854\u5409\u514b\u65af\u5766"),
    TK("772", "TK", "TKL", "ISO 3166-2:TK", "Tokelau", "\u6258\u514b\u52b3\u7fa4\u5c9b"),
    TL("626", "TL", "TLS", "ISO 3166-2:TP", "Timor-Leste (East Timor)", "\u4e1c\u5e1d\u6c76"),
    TM("795", "TM", "TKM", "ISO 3166-2:TM", "Turkmenistan", "\u571f\u5e93\u66fc\u65af\u5766"),
    TN("788", "TN", "TUN", "ISO 3166-2:TN", "Tunisia", "\u7a81\u5c3c\u65af"),
    TO("776", "TO", "TON", "ISO 3166-2:TO", "Tonga", "\u6c64\u52a0"),
    TR("792", "TR", "TUR", "ISO 3166-2:TR", "Turkey", "\u571f\u8033\u5176"),
    TT("780", "TT", "TTO", "ISO 3166-2:TT", "Trinidad & Tobago", "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5"),
    TV("798", "TV", "TUV", "ISO 3166-2:TV", "Tuvalu", "\u56fe\u74e6\u5362"),
    TW("158", "TW", "TWN", "ISO 3166-2:TW", "Taiwan", "\u4e2d\u56fd\u53f0\u6e7e"),
    TZ("834", "TZ", "TZA", "ISO 3166-2:TZ", "Tanzania", "\u5766\u6851\u5c3c\u4e9a"),
    UA("804", "UA", "UKR", "ISO 3166-2:UA", "Ukraine", "\u4e4c\u514b\u5170"),
    UG("800", "UG", "UGA", "ISO 3166-2:UG", "Uganda", "\u4e4c\u5e72\u8fbe"),
    UM("581", "UM", "UMI", "ISO 3166-2:UM", "United States Minor Outlying Islands", "\u7f8e\u56fd\u672c\u571f\u5916\u5c0f\u5c9b\u5c7f"),
    US("840", "US", "USA", "ISO 3166-2:US", "United States of America (USA)", "\u7f8e\u56fd"),
    UY("858", "UY", "URY", "ISO 3166-2:UY", "Uruguay", "\u4e4c\u62c9\u572d"),
    UZ("860", "UZ", "UZB", "ISO 3166-2:UZ", "Uzbekistan", "\u4e4c\u5179\u522b\u514b\u65af\u5766"),
    VA("336", "VA", "VAT", "ISO 3166-2:VA", "Vatican City (The Holy See)", "\u68b5\u8482\u5188"),
    VC("670", "VC", "VCT", "ISO 3166-2:VC", "St. Vincent & the Grenadines", "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af"),
    VE("862", "VE", "VEN", "ISO 3166-2:VE", "Venezuela", "\u59d4\u5185\u745e\u62c9"),
    VG("092", "VG", "VGB", "ISO 3166-2:VG", "British Virgin Islands", "\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b"),
    VI("850", "VI", "VIR", "ISO 3166-2:VI", "United States Virgin Islands", "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b"),
    VN("704", "VN", "VNM", "ISO 3166-2:VN", "Vietnam", "\u8d8a\u5357"),
    VU("548", "VU", "VUT", "ISO 3166-2:VU", "Vanuatu", "\u74e6\u52aa\u963f\u56fe"),
    WF("876", "WF", "WLF", "ISO 3166-2:WF", "Wallis and Futuna", "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3"),
    WS("882", "WS", "WSM", "ISO 3166-2:WS", "Samoa", "\u8428\u6469\u4e9a"),
    YE("887", "YE", "YEM", "ISO 3166-2:YE", "Yemen", "\u4e5f\u95e8"),
    YT("175", "YT", "MYT", "ISO 3166-2:YT", "Mayotte", "\u9a6c\u7ea6\u7279"),
    ZA("710", "ZA", "ZAF", "ISO 3166-2:ZA", "South Africa", "\u5357\u975e"),
    ZM("894", "ZM", "ZMB", "ISO 3166-2:ZM", "Zambia", "\u8d5e\u6bd4\u4e9a"),
    ZW("716", "ZW", "ZWE", "ISO 3166-2:ZW", "Zimbabwe", "\u6d25\u5df4\u5e03\u97e6"),
    UK("998", "UK", "UNKNOWN", "", "Unknown", "\u672a\u77e5\u56fd\u5bb6\u5730\u533a"),
    TS("999", "TS", "TEST", "", "Test", "\u6d4b\u8bd5\u533a\u57df");

    private String number;
    private String code2;
    private String code3;
    private String iso_code;
    private String iso_name;
    private String cname;
    private String currency;
    private static Logger log;

    private RegionEnum(String number, String code2, String code3, String iso_code, String iso_name, String cname) {
        this.number = number;
        this.code2 = code2;
        this.code3 = code3;
        this.iso_code = iso_code;
        this.iso_name = iso_name;
        this.cname = cname;
    }

    private RegionEnum(String number, String code2, String code3, String iso_code, String iso_name, String cname, String currency) {
        this.number = number;
        this.code2 = code2;
        this.code3 = code3;
        this.iso_code = iso_code;
        this.iso_name = iso_name;
        this.cname = cname;
        this.currency = currency;
    }

    public String getNumber() {
        return this.number;
    }

    public String getCode2() {
        return this.code2;
    }

    public String getCode3() {
        return this.code3;
    }

    public String getIsoCode() {
        return this.iso_code;
    }

    public String getIsoName() {
        return this.iso_name;
    }

    public String getCname() {
        return this.cname;
    }

    public String getCurrency() {
        return this.currency;
    }

    public static RegionEnum getByNumber(String number) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getNumber().equalsIgnoreCase(number)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with number '" + number + "'.");
        return UK;
    }

    public static RegionEnum getByCode2(String code2) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getCode2().equalsIgnoreCase(code2)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with code2 '" + code2 + "'.");
        return UK;
    }

    public static RegionEnum getByCode3(String code3) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getCode3().equalsIgnoreCase(code3)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with code3 '" + code3 + "'.");
        return UK;
    }

    public static RegionEnum getByIsoCode(String iso_code) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getIsoCode().equalsIgnoreCase(iso_code)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with iso_code '" + iso_code + "'.");
        return UK;
    }

    public static RegionEnum getByIsoName(String iso_name) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getIsoName().equalsIgnoreCase(iso_name)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with iso_name '" + iso_name + "'.");
        return UK;
    }

    public static RegionEnum getByCnName(String cn_name) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getCname().equalsIgnoreCase(cn_name)) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with cn_name '" + cn_name + "'.");
        return UK;
    }

    public static RegionEnum getByRegionAddress(RegionAddress adress) {
        for (RegionEnum region : RegionEnum.values()) {
            if (!region.getCname().equalsIgnoreCase(adress.getCountry()) && !region.getCname().equalsIgnoreCase(adress.getCountry() + adress.getCity())) continue;
            return region;
        }
        log.debug("Cannot found RegionEnum with '" + adress.toString() + "'.");
        return UK;
    }

    public static boolean isValidRegion(RegionEnum region) {
        return !UK.equals(region) && !TS.equals(region);
    }

    public static boolean isChinaRegion(RegionEnum region) {
        return CN.equals(region) || HK.equals(region) || MO.equals(region) || TW.equals(region);
    }

    public static boolean isChinaRegion(String countryCode) {
        RegionEnum region = RegionEnum.getByCode2(countryCode);
        if (UK.equals(region)) {
            region = RegionEnum.getByCode3(countryCode);
        }
        return RegionEnum.isChinaRegion(region);
    }

    public static boolean isMainland(String countryCode) {
        RegionEnum region = RegionEnum.getByCode2(countryCode);
        if (UK.equals(region)) {
            region = RegionEnum.getByCode3(countryCode);
        }
        return CN.equals(region);
    }

    public boolean isValidRegion() {
        return !UK.equals(this) && !TS.equals(this);
    }

    public boolean isChinaRegion() {
        return CN.equals(this) || HK.equals(this) || MO.equals(this) || TW.equals(this);
    }

    public boolean isChinaMainland() {
        return CN.equals(this);
    }

    public boolean equals(RegionEnum region) {
        return this.compareTo(region) == 0;
    }

    static {
        log = LoggerFactory.getLogger(RegionEnum.class);
    }
}

