/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.plugin;

import java.util.HashMap;
import java.util.Properties;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.meta.MetaExecutor;
import org.apache.ibatis.plugin.meta.MetaParameterHandler;
import org.apache.ibatis.plugin.meta.MetaResultSetHandler;
import org.apache.ibatis.plugin.meta.MetaStatementHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.utils.MybatisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptor
implements Interceptor {
    protected static Logger LOG = LoggerFactory.getLogger(AbstractInterceptor.class);
    protected HashMap<String, Object> extraContext = new HashMap();

    public abstract Object doExecutorIntercept(Invocation var1, Executor var2, MetaExecutor var3) throws Throwable;

    public abstract Object doParameterIntercept(Invocation var1, ParameterHandler var2, MetaParameterHandler var3) throws Throwable;

    public abstract Object doStatementIntercept(Invocation var1, StatementHandler var2, MetaStatementHandler var3) throws Throwable;

    public abstract Object doResultSetIntercept(Invocation var1, ResultSetHandler var2, MetaResultSetHandler var3) throws Throwable;

    public abstract void doDestroyIntercept(Invocation var1) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        try {
            Object target = invocation.getTarget();
            target = MybatisUtils.getTarget(target);
            if (target instanceof Executor) {
                Executor executor = (Executor)target;
                MetaExecutor meta = MetaExecutor.metaObject(executor);
                Object object = this.doExecutorIntercept(invocation, executor, meta);
                return object;
            }
            if (target instanceof ParameterHandler) {
                ParameterHandler parameterHandler = (ParameterHandler)target;
                MetaParameterHandler meta = MetaParameterHandler.metaObject(parameterHandler);
                Object object = this.doParameterIntercept(invocation, parameterHandler, meta);
                return object;
            }
            if (target instanceof StatementHandler) {
                StatementHandler statementHandler = (StatementHandler)target;
                MetaStatementHandler meta = MetaStatementHandler.metaObject(statementHandler);
                Object object = this.doStatementIntercept(invocation, statementHandler, meta);
                return object;
            }
            if (target instanceof ResultSetHandler) {
                ResultSetHandler resultSetHandler = (ResultSetHandler)target;
                MetaResultSetHandler meta = MetaResultSetHandler.metaObject(resultSetHandler);
                Object object = this.doResultSetIntercept(invocation, resultSetHandler, meta);
                return object;
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.doDestroyIntercept(invocation);
        }
    }

    public abstract void setInterceptProperties(Properties var1);

    public void setProperties(Properties properties) {
        this.setInterceptProperties(properties);
    }

    public SqlSource buildSqlSource(Configuration configuration, String originalSql, Class<?> parameterType) {
        SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
        return builder.parse(originalSql, parameterType, null);
    }
}

