/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.plugin.meta;

import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.transaction.Transaction;

public class MetaExecutor {
    protected MetaObject metaObject;
    protected Transaction transaction;
    protected Configuration configuration;

    protected MetaExecutor(MetaObject metaObject, Transaction transaction, Configuration configuration) {
        this.metaObject = metaObject;
        this.transaction = transaction;
        this.configuration = configuration;
    }

    public static MetaExecutor metaObject(Executor executor) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)executor);
        if (executor instanceof CachingExecutor) {
            Configuration configuration = (Configuration)metaObject.getValue("delegate.configuration");
            Transaction transaction = (Transaction)metaObject.getValue("delegate.transaction");
            return new MetaExecutor(metaObject, transaction, configuration);
        }
        Configuration configuration = (Configuration)metaObject.getValue("configuration");
        Transaction transaction = (Transaction)metaObject.getValue("transaction");
        return new MetaExecutor(metaObject, transaction, configuration);
    }

    public MetaObject getMetaObject() {
        return this.metaObject;
    }

    public void setMetaObject(MetaObject metaObject) {
        this.metaObject = metaObject;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

