/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.springframework.util.StringUtils;

public class StringListTypeHandler
extends BaseTypeHandler<List<String>> {
    public void setNonNullParameter(PreparedStatement ps, int i, List<String> list, JdbcType jdbcType) throws SQLException {
        if (list != null && !list.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String s : list) {
                sb.append(s).append(",");
            }
            ps.setString(i, sb.toString().substring(0, sb.toString().length() - 1));
        } else {
            ps.setString(i, "");
        }
    }

    public List<String> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String rtString = rs.getString(columnName);
        if (StringUtils.hasText((String)rtString)) {
            return Arrays.asList(rtString.split(","));
        }
        return null;
    }

    public List<String> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String rtString = rs.getString(columnIndex);
        if (StringUtils.hasText((String)rtString)) {
            return Arrays.asList(rtString.split(","));
        }
        return null;
    }

    public List<String> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String rtString = cs.getString(columnIndex);
        if (StringUtils.hasText((String)rtString)) {
            return Arrays.asList(rtString.split(","));
        }
        return null;
    }
}

