/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.utils;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.utils.BoundSQLUtils;
import org.apache.ibatis.utils.MyBatisSQL;
import org.springframework.util.StringUtils;

public class MyBatisSQLUtils {
    public static String getParameterValue(Object obj, boolean isReplace) {
        if (StringUtils.isEmpty((Object)obj)) {
            return "";
        }
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            value = formatter.format(new Date());
        } else {
            value = String.valueOf(obj);
        }
        return isReplace ? value.replace("'", "") : value;
    }

    public static String getParameterValue(Object obj) {
        return MyBatisSQLUtils.getParameterValue(obj, false);
    }

    public static String getRunSQL(MappedStatement statement, Object parameterObject) {
        return MyBatisSQLUtils.getRunSQL(statement, parameterObject, false);
    }

    public static String getRunSQL(MappedStatement statement, Object parameterObject, boolean isReplace) {
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        Object[] parameters = MyBatisSQLUtils.getParameters(statement, parameterObject);
        if (parameters != null && parameters.length > 0) {
            for (Object value : parameters) {
                sql = sql.replaceFirst("\\?", MyBatisSQLUtils.getParameterValue(value, isReplace));
            }
        }
        return sql;
    }

    public static Object[] getParameters(MappedStatement statement, Object parameterObject) {
        BoundSql boundSql = statement.getBoundSql(parameterObject);
        BoundSQLUtils.setBoundSql(boundSql, boundSql);
        Configuration configuration = statement.getConfiguration();
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            ParameterMapping parameterMapping = null;
            Object value = null;
            String propertyName = null;
            Object[] parameterArray = new Object[parameterMappings.size()];
            for (int i = 0; i < parameterMappings.size(); ++i) {
                parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                propertyName = parameterMapping.getProperty();
                PropertyTokenizer prop = new PropertyTokenizer(propertyName);
                if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (propertyName.startsWith("__frch_") && boundSql.hasAdditionalParameter(prop.getName())) {
                    value = boundSql.getAdditionalParameter(prop.getName());
                    if (value != null) {
                        value = configuration.newMetaObject(value).getValue(propertyName.substring(prop.getName().length()));
                    }
                } else {
                    value = metaObject == null ? null : metaObject.getValue(propertyName);
                }
                parameterArray[i] = value;
            }
            return parameterArray;
        }
        return null;
    }

    public static MyBatisSQL getMyBatisSQL(String statementID, Object parameterObject, Collection<SqlSessionFactory> sqlSessionFactorys, boolean isReplace) {
        SqlSessionFactory[] sqlSessionFactoryArray = new SqlSessionFactory[sqlSessionFactorys.size()];
        Iterator<SqlSessionFactory> iterator = sqlSessionFactorys.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            SqlSessionFactory sqlSessionFactory;
            sqlSessionFactoryArray[index] = sqlSessionFactory = iterator.next();
            ++index;
        }
        return MyBatisSQLUtils.getMyBatisSQL(statementID, parameterObject, isReplace, sqlSessionFactoryArray);
    }

    public static MyBatisSQL getMyBatisSQL(String statementID, Object parameterObject, boolean isReplace, SqlSessionFactory ... sqlSessionFactorys) {
        MyBatisSQL ibatisSql = new MyBatisSQL();
        MappedStatement mappedStatement = null;
        for (int i = 0; i < sqlSessionFactorys.length && (mappedStatement = sqlSessionFactorys[i].getConfiguration().getMappedStatement(statementID)) == null; ++i) {
        }
        if (null != mappedStatement) {
            BoundSql boundSql = mappedStatement.getBoundSql(parameterObject);
            String preSQL = boundSql.getSql().replaceAll("[\\s]+", " ");
            ibatisSql.setPreSQL(preSQL);
            Object[] parameters = MyBatisSQLUtils.getParameters(mappedStatement, parameterObject);
            if (parameters != null && parameters.length > 0) {
                String runSQL = preSQL;
                for (Object value : parameters) {
                    runSQL = runSQL.replaceFirst("\\?", MyBatisSQLUtils.getParameterValue(value, isReplace));
                }
                ibatisSql.setRunSQL(runSQL);
            }
            ibatisSql.setParameters(parameters);
        }
        return ibatisSql;
    }
}

