/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.utils;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.result.DefaultResultHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MybatisUtils {
    protected static Logger LOG = LoggerFactory.getLogger(MybatisUtils.class);
    protected static final ConcurrentMap<ObjectFactory, ResultHandler<Object>> handlersMap = new ConcurrentHashMap<ObjectFactory, ResultHandler<Object>>();

    public static Object getTarget(Object target) {
        MetaObject metaTarget = SystemMetaObject.forObject((Object)target);
        if (metaTarget.hasGetter("h") || metaTarget.hasGetter("target")) {
            while (metaTarget.hasGetter("h")) {
                target = metaTarget.getValue("h");
                metaTarget = SystemMetaObject.forObject((Object)target);
            }
            while (metaTarget.hasGetter("target")) {
                target = metaTarget.getValue("target");
                metaTarget = SystemMetaObject.forObject((Object)target);
            }
            return MybatisUtils.getTarget(target);
        }
        return target;
    }

    public static TransactionFactory getTransactionFactoryFromEnvironment(Configuration configuration) {
        Environment environment = configuration.getEnvironment();
        return MybatisUtils.getTransactionFactoryFromEnvironment(environment);
    }

    public static TransactionFactory getTransactionFactoryFromEnvironment(Environment environment) {
        if (environment == null || environment.getTransactionFactory() == null) {
            return new ManagedTransactionFactory();
        }
        return environment.getTransactionFactory();
    }

    public static DataSource getDataSourceFromEnvironment(Configuration configuration) {
        Environment environment = configuration.getEnvironment();
        return environment.getDataSource();
    }

    public static Executor newExecutor(Configuration configuration) {
        Environment environment = configuration.getEnvironment();
        if (environment == null) {
            throw new ExecutorException("Environment was not configured.");
        }
        DataSource ds = environment.getDataSource();
        if (ds == null) {
            throw new ExecutorException("DataSource was not configured.");
        }
        TransactionFactory transactionFactory = environment.getTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(ds, null, false);
        return configuration.newExecutor(tx, ExecutorType.SIMPLE);
    }

    public static Executor newExecutor(Configuration configuration, Connection connection) {
        Environment environment = configuration.getEnvironment();
        if (environment == null) {
            throw new ExecutorException("Environment was not configured.");
        }
        TransactionFactory transactionFactory = environment.getTransactionFactory();
        Transaction tx = transactionFactory.newTransaction(connection);
        return configuration.newExecutor(tx, ExecutorType.SIMPLE);
    }

    public static ResultHandler<Object> newResultHandler(Configuration configuration) {
        return MybatisUtils.newResultHandler(configuration.getObjectFactory());
    }

    public static ResultHandler<Object> newResultHandler(ObjectFactory objectFactory) {
        ResultHandler resultHandler = null;
        if (handlersMap.containsKey(objectFactory)) {
            resultHandler = (ResultHandler)handlersMap.get(objectFactory.hashCode());
        } else {
            handlersMap.putIfAbsent(objectFactory, (ResultHandler<Object>)new DefaultResultHandler(objectFactory));
        }
        return resultHandler;
    }

    public static SqlSource newSqlSource(Configuration configuration, String originalSql, Class<?> parameterType) {
        return MybatisUtils.newSqlSource(configuration, originalSql, parameterType, null);
    }

    public static SqlSource newSqlSource(Configuration configuration, String originalSql, Class<?> parameterType, Map<String, Object> additionalParameters) {
        SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
        return builder.parse(originalSql, parameterType, additionalParameters);
    }

    public static CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds) {
        return MybatisUtils.createCacheKey(ms, parameterObject, rowBounds, ms.getBoundSql(parameterObject));
    }

    public static CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        return MybatisUtils.createCacheKey(ms, parameterObject, rowBounds, boundSql, null);
    }

    public static CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql, Locale locale) {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)(ms.getId() + "_" + locale.getLanguage() + "-" + locale.getCountry()));
        if (locale != null) {
            cacheKey.update((Object)locale.toString());
        }
        cacheKey.update((Object)rowBounds.getOffset());
        cacheKey.update((Object)rowBounds.getLimit());
        cacheKey.update((Object)boundSql.getSql());
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = ms.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        for (int i = 0; i < parameterMappings.size(); ++i) {
            Object value;
            ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
            if (parameterMapping.getMode() == ParameterMode.OUT) continue;
            String propertyName = parameterMapping.getProperty();
            if (boundSql.hasAdditionalParameter(propertyName)) {
                value = boundSql.getAdditionalParameter(propertyName);
            } else if (parameterObject == null) {
                value = null;
            } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                value = parameterObject;
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                value = metaObject.getValue(propertyName);
            }
            cacheKey.update(value);
        }
        if (configuration.getEnvironment() != null) {
            cacheKey.update((Object)configuration.getEnvironment().getId());
        }
        return cacheKey;
    }

    public static List<Object> doQuery(Configuration configuration, String statementID, Object parameterObject, RowBounds rowBounds) {
        try {
            Environment environment = configuration.getEnvironment();
            Connection connection = environment.getDataSource().getConnection();
            TransactionFactory transactionFactory = MybatisUtils.getTransactionFactoryFromEnvironment(configuration);
            Transaction tx = transactionFactory.newTransaction(connection);
            Executor executor = configuration.newExecutor(tx, ExecutorType.SIMPLE);
            MappedStatement ms = configuration.getMappedStatement(statementID);
            DefaultResultHandler resultHandler = new DefaultResultHandler(configuration.getObjectFactory());
            return executor.query(ms, MybatisUtils.wrapCollection(parameterObject), new RowBounds(), (ResultHandler)resultHandler);
        }
        catch (Exception e) {
            LOG.error("Ignore this exception", (Throwable)e);
            return null;
        }
    }

    public static Object wrapCollection(Object object) {
        if (object instanceof Collection) {
            DefaultSqlSession.StrictMap map = new DefaultSqlSession.StrictMap();
            map.put((Object)"collection", object);
            if (object instanceof List) {
                map.put((Object)"list", object);
            }
            return map;
        }
        if (object != null && object.getClass().isArray()) {
            DefaultSqlSession.StrictMap map = new DefaultSqlSession.StrictMap();
            map.put((Object)"array", object);
            return map;
        }
        return object;
    }
}

