/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class ReflectionUtils {
    protected static Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        @Override
        public boolean matches(Field field) {
            return !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
        }
    };
    public static MethodFilter NON_BRIDGED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge();
        }
    };
    public static MethodFilter USER_DECLARED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge() && method.getDeclaringClass() != Object.class;
        }
    };

    public static Field getAccessibleField(Object target, String name) {
        Field field = ReflectionUtils.getField(target, name);
        if (field != null && !field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field getField(Class<?> clazz, String name) {
        return ReflectionUtils.getField(clazz, name, null);
    }

    public static Field getField(Class<?> clazz, String name, Class<?> type) {
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static Field getField(Object target, String name) {
        for (Class<?> superClass = target.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static void setField(String fieldName, Object target, Object value) {
        Field field = ReflectionUtils.getField(target, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not get field [" + fieldName + "] on target [" + target + "]");
        }
        try {
            if (field.isAccessible()) {
                field.set(target, value);
            } else {
                field.setAccessible(true);
                field.set(target, value);
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getMessage());
        }
    }

    public static Object getField(Object target, Field field) {
        try {
            Object result = null;
            if (field.isAccessible()) {
                result = field.get(target);
            } else {
                field.setAccessible(true);
                result = field.get(target);
                field.setAccessible(false);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object getField(String fieldName, Object target) {
        Field field = ReflectionUtils.getField(target, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not get field [" + fieldName + "] on target [" + target + "]");
        }
        Object result = null;
        try {
            if (field.isAccessible()) {
                result = field.get(target);
            } else {
                field.setAccessible(true);
                result = field.get(target);
                field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getMessage());
        }
        return result;
    }

    public static Method getMethod(Class<?> clazz, String name) {
        return ReflectionUtils.getMethod(clazz, name, new Class[0]);
    }

    public static Method getMethod(Object target, String name, Class<?> ... paramTypes) {
        return ReflectionUtils.getMethod(target.getClass(), name, paramTypes);
    }

    public static Method getAccessibleMethod(Object target, String name, Class<?> ... paramTypes) {
        Method method = ReflectionUtils.getMethod(target.getClass(), name, paramTypes);
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeMethod(String methodName, Object target, Class<?>[] parameterTypes, Object[] args) {
        Method method = ReflectionUtils.getMethod(target.getClass(), methodName, parameterTypes);
        try {
            ReflectionUtils.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeGetterMethod(String propertyName, Object target) {
        String getterMethodName = "get" + StringUtils.capitalize((String)propertyName);
        return ReflectionUtils.invokeMethod(getterMethodName, target, new Class[0], new Object[0]);
    }

    public static Object invokeGetterMethod(Object target, String propertyName) {
        return ReflectionUtils.invokeGetterMethod(propertyName, target);
    }

    public static void invokeSetterMethod(String propertyName, Object target, Object value) {
        ReflectionUtils.invokeSetterMethod(propertyName, target, value, null);
    }

    public static void invokeSetterMethod(String propertyName, Object target, Object value, Class<?> propertyType) {
        Class<?> type = propertyType != null ? propertyType : value.getClass();
        String setterMethodName = "set" + StringUtils.capitalize((String)propertyName);
        ReflectionUtils.invokeMethod(setterMethodName, target, new Class[]{type}, new Object[]{value});
    }

    public static Object invokeJdbcMethod(Method method, Object target) throws SQLException {
        return ReflectionUtils.invokeJdbcMethod(method, target, new Object[0]);
    }

    public static Object invokeJdbcMethod(Method method, Object target, Object ... args) throws SQLException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException) {
                throw (SQLException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isInterface(Class<?> clazz, Class<?> targetInterface) {
        Class<?>[] face = clazz.getInterfaces();
        int j = face.length;
        for (int i = 0; i < j; ++i) {
            if (face[i].getName().equals(targetInterface.getName())) {
                return true;
            }
            Class<?>[] face1 = face[i].getInterfaces();
            for (int x = 0; x < face1.length; ++x) {
                if (face1[x].getName().equals(targetInterface.getName())) {
                    return true;
                }
                if (!ReflectionUtils.isInterface(face1[x], targetInterface)) continue;
                return true;
            }
        }
        if (null != clazz.getSuperclass()) {
            return ReflectionUtils.isInterface(clazz.getSuperclass(), targetInterface);
        }
        return false;
    }

    public static boolean isObjectMethod(Method method) {
        if (method == null) {
            return false;
        }
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static Field[] getAllDeclaredFields(Class<?> leafClass) {
        final ArrayList fields = new ArrayList(32);
        ReflectionUtils.doWithFields(leafClass, new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                fields.add(field);
            }
        });
        return fields.toArray(new Field[fields.size()]);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = targetClass.getDeclaredFields()) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field);
                Object srcValue = field.get(src);
                field.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static boolean checkFieldValueNotNull(Object entity) {
        return false;
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

