/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.cache;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.utils.ObjectUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;

public class BeanMethodDefinition {
    protected BeanDefinition beanDefinition;
    protected String beanName;
    protected String[] aliases;
    protected Class<?> beanClass;
    protected String beanClassName;
    protected static final ConcurrentMap<String, Method> COMPLIED_METHODS = new ConcurrentHashMap<String, Method>();

    public BeanMethodDefinition(String beanName, String[] aliases, BeanDefinition beanDefinition, Class<?> beanClass) {
        this.beanDefinition = beanDefinition;
        this.beanName = beanName;
        this.aliases = aliases;
        this.beanClass = beanClass;
        this.beanClassName = beanClass.getName();
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod(String methodName, Class<?>[] paramTypes) {
        String uid;
        Method ret;
        StringBuilder builder = new StringBuilder(this.getBeanClassName()).append(".").append(methodName);
        if (!ObjectUtils.isEmpty(paramTypes)) {
            builder.append("[");
            for (Class<?> paramType : paramTypes) {
                builder.append(".").append(paramType.getName());
            }
            builder.append("]");
        }
        if ((ret = (Method)COMPLIED_METHODS.get(uid = DigestUtils.md5DigestAsHex((byte[])builder.toString().getBytes()))) != null) {
            return ret;
        }
        Class<?> clazz = this.beanClass;
        synchronized (clazz) {
            for (Class<?> searchType = this.beanClass; searchType != null; searchType = searchType.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getAllDeclaredMethods(searchType)) {
                    if (!methodName.equals(method.getName()) || !ObjectUtils.isEmpty(paramTypes) && !this.equals(paramTypes, method.getParameterTypes())) continue;
                    ret = method;
                    Method existing = COMPLIED_METHODS.putIfAbsent(uid, ret);
                    if (existing != null) {
                        ret = existing;
                    }
                    return ret;
                }
            }
        }
        return ret;
    }

    public boolean equals(Class<?>[] a, Class<?>[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Class<?> class1 = a[i];
            Class<?> class2 = a2[i];
            if (class1 != null ? class1.equals(class2) || class2.isAssignableFrom(class1) : class2 == null) continue;
            return false;
        }
        return true;
    }
}

