/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.cache;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.utils.MybatisUtils;
import org.apache.ibatis.utils.ReflectionUtils;
import org.mybatis.spring.cache.BeanMethodDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;

public class BeanMethodDefinitionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BeanMethodDefinitionFactory.class);
    protected static final ConcurrentMap<String, BeanMethodDefinition> COMPLIED_BEAN_METHODS = new ConcurrentHashMap<String, BeanMethodDefinition>();

    public static BeanMethodDefinition getBeanMethodDefinition(String className) {
        return BeanMethodDefinitionFactory.getBeanMethodDefinition(className, null);
    }

    public static BeanMethodDefinition getBeanMethodDefinition(String className, BeanMethodDefinition definition) {
        BeanMethodDefinition existing;
        BeanMethodDefinition ret = (BeanMethodDefinition)COMPLIED_BEAN_METHODS.get(className);
        if (ret != null) {
            return ret;
        }
        if (definition != null && (existing = COMPLIED_BEAN_METHODS.putIfAbsent(className, definition)) != null) {
            ret = existing;
        }
        return ret;
    }

    public static BeanDefinition getBeanDefinition(String className) {
        BeanMethodDefinition definition = BeanMethodDefinitionFactory.getBeanMethodDefinition(className);
        if (definition == null) {
            return null;
        }
        return definition.getBeanDefinition();
    }

    public static Method getMethodDefinition(String mappedStatementId) {
        return BeanMethodDefinitionFactory.getMethodDefinition(mappedStatementId, null);
    }

    public static Method getMethodDefinition(String mappedStatementId, Class<?>[] paramTypes) {
        int index = mappedStatementId.lastIndexOf(".");
        String className = mappedStatementId.substring(0, index);
        String methodName = mappedStatementId.substring(index + 1);
        BeanMethodDefinition definition = BeanMethodDefinitionFactory.getBeanMethodDefinition(className);
        if (definition == null) {
            return null;
        }
        return definition.getMethod(methodName, paramTypes);
    }

    public static BeanMethodDefinition setBeanMethodDefinition(String className, BeanMethodDefinition definition) {
        BeanMethodDefinition ret = definition;
        BeanMethodDefinition existing = COMPLIED_BEAN_METHODS.putIfAbsent(className, definition);
        if (existing != null) {
            ret = existing;
        }
        return ret;
    }

    public static void setBeanDefinitions(BeanFactory beanFactory, Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitions) {
            try {
                String beanName = beanDefinitionHolder.getBeanName();
                Object target = MybatisUtils.getTarget(beanFactory.getBean(beanName));
                Class beanClass = (Class)ReflectionUtils.getAccessibleField(target, "mapperInterface").get(target);
                String className = beanClass.getName();
                BeanMethodDefinition definition = new BeanMethodDefinition(beanName, beanDefinitionHolder.getAliases(), beanDefinitionHolder.getBeanDefinition(), beanClass);
                BeanMethodDefinitionFactory.setBeanMethodDefinition(className, definition);
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

