/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.cache;

import java.util.List;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.spring.cache.CacheKeyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultCacheKeyHandler
implements CacheKeyHandler {
    protected static Logger LOG = LoggerFactory.getLogger(DefaultCacheKeyHandler.class);

    @Override
    public CacheKey createCacheKey(MappedStatement mappedStatement, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        Configuration configuration = mappedStatement.getConfiguration();
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)mappedStatement.getId());
        cacheKey.update((Object)rowBounds.getOffset());
        cacheKey.update((Object)rowBounds.getLimit());
        List parameterMappings = boundSql.getParameterMappings();
        if (StringUtils.isEmpty((Object)boundSql.getSql())) {
            String newSql = null;
            try {
                if (SqlCommandType.SELECT.ordinal() == mappedStatement.getSqlCommandType().ordinal()) {
                    // empty if block
                }
                SqlSource sqlSource = this.buildSqlSource(configuration, newSql, parameterObject.getClass());
                parameterMappings = sqlSource.getBoundSql(parameterObject).getParameterMappings();
                cacheKey.update(newSql);
            }
            catch (Exception e) {
                LOG.error("Update cacheKey error.", (Throwable)e);
            }
        } else {
            cacheKey.update((Object)boundSql.getSql());
        }
        MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                cacheKey.update(parameterObject);
            } else {
                for (ParameterMapping parameterMapping : parameterMappings) {
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        cacheKey.update(metaObject.getValue(propertyName));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    cacheKey.update(boundSql.getAdditionalParameter(propertyName));
                }
            }
        }
        return cacheKey;
    }

    public SqlSource buildSqlSource(Configuration configuration, String originalSql, Class<?> parameterType) {
        SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
        return builder.parse(originalSql, parameterType, null);
    }
}

