/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.mapper;

import java.util.Set;
import org.apache.ibatis.utils.MybatisUtils;
import org.apache.ibatis.utils.ReflectionUtils;
import org.mybatis.spring.cache.BeanMethodDefinition;
import org.mybatis.spring.cache.BeanMethodDefinitionFactory;
import org.mybatis.spring.mapper.ClassPathMapperScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;

public class MybatisClassPathMapperScanner
extends ClassPathMapperScanner {
    protected Logger LOG = LoggerFactory.getLogger(MybatisClassPathMapperScanner.class);
    protected ApplicationContext applicationContext;

    public MybatisClassPathMapperScanner(ApplicationContext applicationContext, BeanDefinitionRegistry registry) {
        super(registry);
        this.applicationContext = applicationContext;
    }

    public int scan(String ... basePackages) {
        int count = 0;
        try {
            count = super.scan(basePackages);
        }
        catch (Throwable e) {
            this.LOG.error(e.getLocalizedMessage(), e);
        }
        return count;
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitions) {
            try {
                String beanName = beanDefinitionHolder.getBeanName();
                Object target = MybatisUtils.getTarget(this.applicationContext.getBean(beanName));
                Class beanClass = (Class)ReflectionUtils.getAccessibleField(target, "mapperInterface").get(target);
                String className = beanClass.getName();
                BeanMethodDefinition definition = new BeanMethodDefinition(beanName, beanDefinitionHolder.getAliases(), beanDefinitionHolder.getBeanDefinition(), beanClass);
                BeanMethodDefinitionFactory.setBeanMethodDefinition(className, definition);
            }
            catch (Exception e) {
                this.LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return beanDefinitions;
    }

    protected void postProcessBeanDefinition(AbstractBeanDefinition beanDefinition, String beanName) {
        try {
            super.postProcessBeanDefinition(beanDefinition, beanName);
        }
        catch (Throwable e) {
            this.LOG.error(e.getLocalizedMessage(), e);
        }
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definitionHolder, BeanDefinitionRegistry registry) {
        try {
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)definitionHolder, (BeanDefinitionRegistry)registry);
        }
        catch (Throwable e) {
            this.LOG.error(e.getLocalizedMessage(), e);
        }
    }
}

