/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring.utils;

import java.util.HashSet;
import org.apache.ibatis.exception.MybatisException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class PackageScanUtils {
    public static ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
    public static MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);

    public static String[] scanTypeAliasesPackage(String typeAliasesPackage) {
        String pkg = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)typeAliasesPackage) + "/*.class";
        try {
            HashSet<String> set = new HashSet<String>();
            Resource[] resources = resolver.getResources(pkg);
            if (resources != null && resources.length > 0) {
                MetadataReader metadataReader = null;
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    set.add(Class.forName(metadataReader.getClassMetadata().getClassName()).getPackage().getName());
                }
            }
            if (!set.isEmpty()) {
                return set.toArray(new String[0]);
            }
            throw new MybatisException("not find typeAliasesPackage:" + pkg);
        }
        catch (Exception e) {
            throw new MybatisException("not find typeAliasesPackage:" + pkg, e);
        }
    }
}

