/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.RedisKey;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.CollectionUtils;

public class GeoTemplate
extends AbstractOperations<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(GeoTemplate.class);
    private BoundGeoOperations<String, Object> boundGeoOperations;

    public GeoTemplate() {
        super(null);
    }

    public GeoTemplate(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.boundGeoOperations = redisTemplate.boundGeoOps((Object)RedisKey.GEO_LOCATION_KEY.getKey());
    }

    public double getDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1 = Math.PI / 180 * latitude1;
        double lat2 = Math.PI / 180 * latitude2;
        double lon1 = Math.PI / 180 * longitude1;
        double lon2 = Math.PI / 180 * longitude2;
        double R = 6371.0;
        double d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * R;
        return d * 1000.0;
    }

    public double getSphereDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.Sphere, latitude1, longitude1, latitude2, longitude2);
    }

    public double getWGS84Distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.WGS84, latitude1, longitude1, latitude2, longitude2);
    }

    public double getDistance(Ellipsoid ellipsoid, double latitude1, double longitude1, double latitude2, double longitude2) {
        GlobalCoordinates gpsFrom = new GlobalCoordinates(latitude1, longitude1);
        GlobalCoordinates gpsTo = new GlobalCoordinates(latitude2, longitude2);
        return this.getDistance(gpsFrom, gpsTo, ellipsoid);
    }

    public double getDistance(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }

    public Long geoAdd(RedisGeoCommands.GeoLocation<Object> location) {
        return this.getBoundGeoOperations().add(location);
    }

    public Long geoAdd(Iterable<RedisGeoCommands.GeoLocation<Object>> locations) {
        return this.getBoundGeoOperations().add(locations);
    }

    public Long geoAdd(Point point, Object member) {
        return this.getBoundGeoOperations().add(point, member);
    }

    public Long geoAdd(Map<Object, Point> memberCoordinateMap) {
        return this.getBoundGeoOperations().add(memberCoordinateMap);
    }

    public Long geoAdd(String member, double longitude, double latitude) {
        Point point = new Point(longitude, latitude);
        return this.getBoundGeoOperations().add(point, (Object)member);
    }

    public Distance distance(String uid1, String uid2) {
        Distance distance = this.boundGeoOperations.distance((Object)uid1, (Object)uid2);
        log.info("UserId {} >> UserId {} . distance = {}{}", new Object[]{uid1, uid2, distance.getValue(), distance.getUnit()});
        System.out.println(distance);
        return distance;
    }

    public double distanceValue(String uid1, String uid2) {
        Distance distance = this.distance(uid1, uid2);
        return distance.getValue();
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> getCircleUsersByDistance(String uid, double distance) {
        RedisGeoCommands.GeoRadiusCommandArgs geoRadiusArgs = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
        geoRadiusArgs = geoRadiusArgs.includeCoordinates().includeDistance();
        geoRadiusArgs.sortAscending();
        GeoResults geoResults = this.boundGeoOperations.radius((Object)uid, new Distance(distance), geoRadiusArgs);
        return geoResults;
    }

    public <T> List<T> getCircleUsersByDistance(String uid, double distance, Function<GeoResult<RedisGeoCommands.GeoLocation<Object>>, T> mapper) {
        GeoResults<RedisGeoCommands.GeoLocation<Object>> geoResults = this.getCircleUsersByDistance(uid, distance);
        List geoResultList = geoResults.getContent();
        if (CollectionUtils.isEmpty((Collection)geoResultList)) {
            return new ArrayList();
        }
        return geoResultList.stream().map(mapper).collect(Collectors.toList());
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> getCircleUsersByRadius(String uid, double radius) {
        Circle within = new Circle((Point)this.boundGeoOperations.position(new Object[]{uid}).get(0), radius);
        RedisGeoCommands.GeoRadiusCommandArgs geoRadiusArgs = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
        geoRadiusArgs = geoRadiusArgs.includeCoordinates().includeDistance();
        geoRadiusArgs.sortAscending();
        GeoResults geoResults = this.boundGeoOperations.radius(within, geoRadiusArgs);
        return geoResults;
    }

    public <T> List<T> getCircleUsersByRadius(String uid, double radius, Function<GeoResult<RedisGeoCommands.GeoLocation<Object>>, T> mapper) {
        GeoResults<RedisGeoCommands.GeoLocation<Object>> geoResults = this.getCircleUsersByRadius(uid, radius);
        List geoResultList = geoResults.getContent();
        if (CollectionUtils.isEmpty((Collection)geoResultList)) {
            return new ArrayList();
        }
        return geoResultList.stream().map(mapper).collect(Collectors.toList());
    }

    public BoundGeoOperations<String, Object> getBoundGeoOperations() {
        return this.boundGeoOperations;
    }
}

