/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.function.Function;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisKey;
import reactor.core.publisher.Flux;

public class ReactiveGeoTemplate {
    private static final String USER_GEO_KEY = RedisKey.GEO_LOCATION_KEY.getKey();
    private ReactiveRedisTemplate<Object, Object> reactiveRedisTemplate;

    public ReactiveGeoTemplate() {
    }

    public ReactiveGeoTemplate(ReactiveRedisTemplate<Object, Object> reactiveRedisTemplate) {
        this.reactiveRedisTemplate = reactiveRedisTemplate;
    }

    public double getDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1 = Math.PI / 180 * latitude1;
        double lat2 = Math.PI / 180 * latitude2;
        double lon1 = Math.PI / 180 * longitude1;
        double lon2 = Math.PI / 180 * longitude2;
        double R = 6371.0;
        double d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * R;
        return d * 1000.0;
    }

    public double getSphereDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.Sphere, latitude1, longitude1, latitude2, longitude2);
    }

    public double getWGS84Distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.WGS84, latitude1, longitude1, latitude2, longitude2);
    }

    public double getDistance(Ellipsoid ellipsoid, double latitude1, double longitude1, double latitude2, double longitude2) {
        GlobalCoordinates gpsFrom = new GlobalCoordinates(latitude1, longitude1);
        GlobalCoordinates gpsTo = new GlobalCoordinates(latitude2, longitude2);
        return this.getDistance(gpsFrom, gpsTo, ellipsoid);
    }

    public double getDistance(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }

    public void setLocation(String uid, double longitude, double latitude) {
        Point point = new Point(longitude, latitude);
        this.getReactiveRedisTemplate().opsForGeo().add((Object)USER_GEO_KEY, point, (Object)uid);
    }

    public String distance(String uid1, String uid2) {
        return (String)this.getReactiveRedisTemplate().opsForGeo().distance((Object)USER_GEO_KEY, (Object)uid1, (Object)uid2).map(obj -> String.valueOf(obj.getValue() + obj.getUnit())).cast(String.class).block();
    }

    public <T> Flux<T> getCircleUsersByDistance(String uid, double distance, Function<GeoResult<RedisGeoCommands.GeoLocation<Object>>, T> mapper) {
        RedisGeoCommands.GeoRadiusCommandArgs geoRadiusArgs = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs();
        geoRadiusArgs = geoRadiusArgs.includeCoordinates().includeDistance();
        geoRadiusArgs.sortAscending();
        return this.getReactiveRedisTemplate().opsForGeo().radius((Object)USER_GEO_KEY, (Object)uid, new Distance(distance), geoRadiusArgs).map(geoResult -> mapper.apply((GeoResult<RedisGeoCommands.GeoLocation<Object>>)geoResult));
    }

    public ReactiveRedisTemplate<Object, Object> getReactiveRedisTemplate() {
        return this.reactiveRedisTemplate;
    }
}

