/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveSubscription;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.MapUtils;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisKey;
import org.springframework.data.redis.core.RedisOperationException;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;

public class ReactiveRedisOperationTemplate {
    private static final Logger log = LoggerFactory.getLogger(ReactiveRedisOperationTemplate.class);
    private static final Long LOCK_SUCCESS = 1L;
    private static final Long LOCK_EXPIRED = -1L;
    private static final RedisScript<Long> LOCK_LUA_SCRIPT = RedisScript.of((String)"if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then return redis.call('pexpire', KEYS[1], ARGV[2]) else return -1 end", Long.class);
    private static final RedisScript<Long> UNLOCK_LUA_SCRIPT = RedisScript.of((String)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return -1 end", Long.class);
    public static final RedisScript<Long> INCR_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBY', KEYS[1], num);end;return -3;", Long.class);
    public static final RedisScript<Long> DECR_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBY', KEYS[1], 0 - num);    end;    return -2;end;return -3;", Long.class);
    public static final RedisScript<Object> INCR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBYFLOAT', KEYS[1], num);end;return -3;", Object.class);
    public static final RedisScript<Object> DECR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBYFLOAT', KEYS[1], 0 - num);    end;    return -2;end;return -3;", Object.class);
    public static final RedisScript<Long> HINCR_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBY', KEYS[1], KEYS[2], num);end;return -3;", Long.class);
    public static final RedisScript<Long> HDECR_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBY', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;", Long.class);
    public static final RedisScript<Object> HINCR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], num);end;return -3;", Object.class);
    public static final RedisScript<Object> HDECR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;", Object.class);
    public static final Function<Object, String> TO_STRING = member -> Objects.toString(member, null);
    public static final Function<Object, Double> TO_DOUBLE = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Double ? ((Double)member).doubleValue() : new BigDecimal(member.toString()).doubleValue();
    };
    public static final Function<Object, Long> TO_LONG = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Long ? ((Long)member).longValue() : new BigDecimal(member.toString()).longValue();
    };
    public static final Function<Object, Integer> TO_INTEGER = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Integer ? ((Integer)member).intValue() : new BigDecimal(member.toString()).intValue();
    };
    private final ReactiveRedisTemplate<String, Object> reactiveRedisTemplate;

    public ReactiveRedisOperationTemplate(ReactiveRedisTemplate<String, Object> reactiveRedisTemplate) {
        this.reactiveRedisTemplate = reactiveRedisTemplate;
    }

    protected <T> Mono<T> monoError(Exception e) {
        log.error(e.getMessage());
        return Mono.error((Throwable)((Object)new RedisOperationException(e.getMessage())));
    }

    protected <T> Flux<T> fluxError(Exception e) {
        log.error(e.getMessage());
        return Flux.error((Throwable)((Object)new RedisOperationException(e.getMessage())));
    }

    public ByteBuffer getRawKey(String key) {
        return this.reactiveRedisTemplate.getSerializationContext().getStringSerializationPair().write((Object)key);
    }

    public <V> ByteBuffer getRawValue(V value) {
        if (value instanceof ByteBuffer) {
            return (ByteBuffer)value;
        }
        return this.reactiveRedisTemplate.getSerializationContext().getValueSerializationPair().write(value);
    }

    public <V> List<ByteBuffer> getRawValues(Collection<V> values) {
        return values.stream().map(value -> this.reactiveRedisTemplate.getSerializationContext().getValueSerializationPair().write(value)).collect(Collectors.toList());
    }

    public <HK> ByteBuffer getRawHashKey(HK hashKey) {
        return this.reactiveRedisTemplate.getSerializationContext().getHashKeySerializationPair().write(hashKey);
    }

    public <HK> List<ByteBuffer> getRawHashKeys(HK ... hashKeys) {
        return Stream.of(hashKeys).map(hashKey -> this.reactiveRedisTemplate.getSerializationContext().getHashKeySerializationPair().write(hashKey)).collect(Collectors.toList());
    }

    public <HV> ByteBuffer getRawHashValue(HV value) {
        return this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair().write(value);
    }

    public Set<Object> getDeserializeValues(Set<ByteBuffer> rawValues) {
        return rawValues.stream().map(rawValue -> this.reactiveRedisTemplate.getSerializationContext().getValueSerializationPair().read(rawValue)).collect(Collectors.toSet());
    }

    public List<Object> getDeserializeValues(List<ByteBuffer> rawValues) {
        return rawValues.stream().map(rawValue -> this.reactiveRedisTemplate.getSerializationContext().getValueSerializationPair().read(rawValue)).collect(Collectors.toList());
    }

    public <T> Set<T> getDeserializeHashKeys(Set<ByteBuffer> rawKeys) {
        return rawKeys.stream().map(rawKey -> this.reactiveRedisTemplate.getSerializationContext().getHashKeySerializationPair().read(rawKey)).collect(Collectors.toSet());
    }

    public <T> List<T> getDeserializeHashValues(List<ByteBuffer> rawValues) {
        return rawValues.stream().map(rawValue -> this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair().read(rawValue)).collect(Collectors.toList());
    }

    public String getDeserializeKey(ByteBuffer rawKey) {
        return (String)this.reactiveRedisTemplate.getSerializationContext().getStringSerializationPair().read(rawKey);
    }

    public Set<String> getDeserializeKeys(Set<ByteBuffer> rawKeys) {
        return rawKeys.stream().map(rawKey -> (String)this.reactiveRedisTemplate.getSerializationContext().getStringSerializationPair().read(rawKey)).collect(Collectors.toSet());
    }

    public Object getDeserializeValue(ByteBuffer rawValue) {
        return this.reactiveRedisTemplate.getSerializationContext().getValueSerializationPair().read(rawValue);
    }

    public String getDeserializeString(ByteBuffer rawValue) {
        return (String)this.reactiveRedisTemplate.getSerializationContext().getStringSerializationPair().read(rawValue);
    }

    public <HK> HK getDeserializeHashKey(ByteBuffer rawKey) {
        return (HK)this.reactiveRedisTemplate.getSerializationContext().getHashKeySerializationPair().read(rawKey);
    }

    public <HV> HV getDeserializeHashValue(ByteBuffer rawValue) {
        return (HV)this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair().read(rawValue);
    }

    public ZSetOperations.TypedTuple<Object> getDeserializeTuple(RedisZSetCommands.Tuple raw) {
        return new DefaultTypedTuple(this.getDeserializeValue(ByteBuffer.wrap(raw.getValue())), raw.getScore());
    }

    public Mono<Boolean> expire(String key, long seconds) {
        return this.expire(key, Duration.ofSeconds(seconds));
    }

    public Mono<Boolean> expire(String key, Duration duration) {
        if (Objects.isNull(duration)) {
            return Mono.just((Object)Boolean.FALSE);
        }
        try {
            return this.reactiveRedisTemplate.expire((Object)key, duration);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> expireAt(String key, Instant expireAt) {
        if (Objects.isNull(expireAt)) {
            return Mono.just((Object)Boolean.FALSE);
        }
        try {
            return this.reactiveRedisTemplate.expireAt((Object)key, expireAt);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Duration> getExpire(String key) {
        try {
            return this.reactiveRedisTemplate.getExpire((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hasKey(String key) {
        try {
            return this.reactiveRedisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<String> getKey(String pattern) {
        try {
            if (Objects.isNull(pattern)) {
                return Flux.empty();
            }
            return this.reactiveRedisTemplate.keys((Object)pattern);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> getVagueKey(String pattern) {
        try {
            return this.reactiveRedisTemplate.keys((Object)("*" + pattern + "*"));
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> getValueKeyByPrefix(String prefixPattern) {
        try {
            return this.reactiveRedisTemplate.keys((Object)(prefixPattern + "*"));
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Boolean> set(String key, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForValue().set((Object)key, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> set(String key, Object value, long seconds) {
        try {
            if (seconds > 0L) {
                return this.reactiveRedisTemplate.opsForValue().set((Object)key, value, Duration.ofSeconds(seconds));
            }
            return this.set(key, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> set(String key, Object value, Duration duration) {
        if (Objects.isNull(duration) || duration.isNegative()) {
            return Mono.just((Object)Boolean.FALSE);
        }
        try {
            return this.reactiveRedisTemplate.opsForValue().set((Object)key, value, duration);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> setNX(String key, Object value) {
        try {
            Assert.hasLength((String)key, (String)"key must not be empty");
            return this.reactiveRedisTemplate.opsForValue().setIfAbsent((Object)key, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> setNx(String key, Object value, long milliseconds) {
        try {
            return this.reactiveRedisTemplate.opsForValue().setIfAbsent((Object)key, value, Duration.ofMillis(milliseconds));
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> setNx(String key, Object value, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForValue().setIfAbsent((Object)key, value, timeout);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> get(String key) {
        try {
            return !StringUtils.hasText((String)key) ? Mono.empty() : this.reactiveRedisTemplate.opsForValue().get((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> getDouble(String key) {
        return this.getFor(key, TO_DOUBLE);
    }

    public Mono<Long> getLong(String key) {
        return this.getFor(key, TO_LONG);
    }

    public Mono<Integer> getInteger(String key) {
        return this.getFor(key, TO_INTEGER);
    }

    public Mono<String> getString(String key) {
        return this.getFor(key, TO_STRING);
    }

    public <T> Mono<T> getFor(String key, Class<T> clazz) {
        return this.getFor(key, (Object member) -> clazz.cast(member));
    }

    public <T> Mono<T> getFor(String key, Function<Object, T> mapper) {
        Mono<Object> obj = this.get(key);
        return obj.map(mapper);
    }

    public Mono<List<Object>> mGet(String pattern) {
        try {
            if (!StringUtils.hasText((String)pattern)) {
                return Mono.empty();
            }
            Collection keys = (Collection)this.reactiveRedisTemplate.keys((Object)pattern).collectList().block();
            return this.reactiveRedisTemplate.opsForValue().multiGet(keys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<List<Double>> mGetDouble(Collection keys) {
        return this.mGetFor(keys, TO_DOUBLE);
    }

    public Mono<List<Long>> mGetLong(Collection keys) {
        return this.mGetFor(keys, TO_LONG);
    }

    public Mono<List<Integer>> mGetInteger(Collection keys) {
        return this.mGetFor(keys, TO_INTEGER);
    }

    public Mono<List<String>> mGetString(Collection keys) {
        return this.mGetFor(keys, TO_STRING);
    }

    public <T> Mono<List<T>> mGetFor(Collection keys, Class<T> clazz) {
        return this.mGetFor(keys, (Object member) -> clazz.cast(member));
    }

    public <T> Mono<List<T>> mGetFor(Collection keys, Function<Object, T> mapper) {
        return this.mGet(keys).map(members -> members.stream().map(mapper).collect(Collectors.toList()));
    }

    public Mono<List<Object>> mGet(Collection keys) {
        try {
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return Mono.empty();
            }
            return this.reactiveRedisTemplate.opsForValue().multiGet(keys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<List<Object>> mGet(Collection<Object> keys, String redisPrefix) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Mono.empty();
            }
            Collection newKeys = keys.stream().map(key -> RedisKey.getKeyStr(redisPrefix, key.toString())).collect(Collectors.toList());
            return this.reactiveRedisTemplate.opsForValue().multiGet(newKeys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> incr(String key, long delta) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> incr(String key, long delta, long seconds) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
            return increment.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> incr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
            return increment.doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> incr(String key, double delta) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> incr(String key, double delta, long seconds) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
            return increment.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> incr(String key, double delta, Duration timeout) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, delta);
            return increment.doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> decr(String key, long delta) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> decr(String key, long delta, long seconds) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
            return increment.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> decr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
            return increment.doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> decr(String key, double delta) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> decr(String key, double delta, long seconds) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
            return increment.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> decr(String key, double delta, Duration timeout) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForValue().increment((Object)key, -delta);
            return increment.doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> del(String ... keys) {
        try {
            if (keys != null && keys.length > 0) {
                if (keys.length == 1) {
                    return this.reactiveRedisTemplate.delete((Object[])new String[]{keys[0]});
                }
                return this.reactiveRedisTemplate.delete((Object[])keys);
            }
        }
        catch (Exception e) {
            return this.monoError(e);
        }
        return Mono.just((Object)0L);
    }

    public Flux<Object> lRange(String key, long start, long end) {
        try {
            return this.reactiveRedisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> lRangeString(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_STRING);
    }

    public Flux<Double> lRangeDouble(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_DOUBLE);
    }

    public Flux<Long> lRangeLong(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_LONG);
    }

    public Flux<Integer> lRangeInteger(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_INTEGER);
    }

    public <T> Flux<T> lRangeFor(String key, long start, long end, Class<T> clazz) {
        return this.lRangeFor(key, start, end, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> lRangeFor(String key, long start, long end, Function<Object, T> mapper) {
        Flux members = this.lRange(key, start, end).map(mapper);
        return members;
    }

    public Mono<Object> lIndex(String key, long index) {
        try {
            return this.reactiveRedisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushDistinct(String key, V value) {
        try {
            return this.reactiveRedisTemplate.createMono(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ByteBuffer rawValue = this.getRawValue(value);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.lRem(rawKey, Long.valueOf(0L), rawValue).then(listCommands.lPush(rawKey, Arrays.asList(rawValue)));
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPush(String key, V value) {
        return this.lLeftPush(key, value, 0L);
    }

    public <V> Mono<Long> lLeftPush(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lLeftPushAll(key, (Collection)value, seconds);
        }
        try {
            return this.reactiveRedisTemplate.opsForList().leftPush((Object)key, value).doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPush(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lLeftPushAll(key, (Collection)value, timeout);
        }
        try {
            return this.reactiveRedisTemplate.opsForList().leftPush((Object)key, value).doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushAll(String key, Collection<V> values) {
        try {
            return this.reactiveRedisTemplate.opsForList().leftPushAll((Object)key, values.toArray());
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushAll(String key, Collection<V> values, long seconds) {
        try {
            return this.reactiveRedisTemplate.opsForList().leftPushAll((Object)key, values.toArray()).doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushAll(String key, Collection<V> values, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForList().leftPushAll((Object)key, values.toArray()).doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushx(String key, V value) {
        return this.lLeftPushx(key, value, 0L);
    }

    public <V> Mono<Long> lLeftPushx(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lLeftPushxAll(key, (Collection)value, seconds);
        }
        try {
            return this.reactiveRedisTemplate.opsForList().leftPushIfPresent((Object)key, value).doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushx(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lLeftPushxAll(key, (Collection)value, timeout);
        }
        try {
            return this.reactiveRedisTemplate.opsForList().leftPushIfPresent((Object)key, value).doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushxAll(String key, Collection<V> values, long seconds) {
        try {
            return Flux.fromIterable(values).flatMap(value -> this.reactiveRedisTemplate.opsForList().leftPushIfPresent((Object)key, value)).count().doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lLeftPushxAll(String key, Collection<V> values, Duration timeout) {
        try {
            return Flux.fromIterable(values).flatMap(value -> this.reactiveRedisTemplate.opsForList().leftPushIfPresent((Object)key, value)).count().doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> lLeftPop(String key) {
        try {
            return this.reactiveRedisTemplate.opsForList().leftPop((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Object> lLeftPopAndLrem(String key) {
        try {
            return this.reactiveRedisTemplate.createMono(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.lPop(rawKey).doOnSuccess(rawValue -> listCommands.lRem(rawKey, Long.valueOf(0L), rawValue)).map(rawValue -> this.getDeserializeValue((ByteBuffer)rawValue));
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> lLeftPop(String key, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForList().leftPop((Object)key, timeout);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> lLeftPop(String key, Integer count) {
        try {
            return this.reactiveRedisTemplate.createFlux(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.lRange(rawKey, 0L, (long)(count - 1)).doOnNext(rawValue -> listCommands.lTrim(rawKey, (long)count.intValue(), -1L)).map(rawValue -> this.getDeserializeValue((ByteBuffer)rawValue));
            });
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public <T> Flux<T> lLeftPop(String key, Integer count, Class<T> clazz) {
        try {
            Flux<Object> range = this.lLeftPop(key, count);
            return range.map(member -> clazz.cast(member));
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public <V> Mono<Long> lRightPushDistinct(String key, V value) {
        try {
            return this.reactiveRedisTemplate.createMono(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ByteBuffer rawValue = this.getRawValue(value);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.lRem(rawKey, Long.valueOf(0L), rawValue).then(listCommands.rPush(rawKey, Arrays.asList(rawValue)));
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPush(String key, V value) {
        return this.lRightPush(key, value, 0L);
    }

    public <V> Mono<Long> lRightPush(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lRightPushAll(key, (Collection)value, seconds);
        }
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPush((Object)key, value);
            return rt.doOnSuccess(c -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPush(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lRightPushAll(key, (Collection)value, timeout);
        }
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPush((Object)key, value);
            return rt.doOnSuccess(c -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushAll(String key, Collection<V> values) {
        try {
            return this.reactiveRedisTemplate.opsForList().rightPushAll((Object)key, values.toArray());
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushAll(String key, Collection<V> values, long seconds) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPushAll((Object)key, values.toArray());
            return rt.doOnSuccess(c -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushAll(String key, Collection<V> values, Duration timeout) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPushAll((Object)key, values.toArray());
            return rt.doOnSuccess(c -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushx(String key, V value) {
        return this.lRightPushx(key, value, 0L);
    }

    public <V> Mono<Long> lRightPushx(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lRightPushxAll(key, (Collection)value, seconds);
        }
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPushIfPresent((Object)key, value);
            return rt.doOnSuccess(c -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushx(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lRightPushxAll(key, (Collection)value, timeout);
        }
        try {
            Mono rt = this.reactiveRedisTemplate.opsForList().rightPushIfPresent((Object)key, value);
            return rt.doOnSuccess(c -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushxAll(String key, Collection<V> values, long seconds) {
        try {
            return Flux.fromIterable(values).flatMap(value -> this.reactiveRedisTemplate.opsForList().rightPushIfPresent((Object)key, value)).next().doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Long> lRightPushxAll(String key, Collection<V> values, Duration timeout) {
        try {
            return Flux.fromIterable(values).flatMap(value -> this.reactiveRedisTemplate.opsForList().rightPushIfPresent((Object)key, value)).next().doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> lRightPop(String key) {
        try {
            return this.reactiveRedisTemplate.opsForList().rightPop((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <V> Mono<Object> lRightPopAndLrem(String key) {
        try {
            return this.reactiveRedisTemplate.createMono(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.rPop(rawKey).doOnSuccess(rawValue -> listCommands.lRem(rawKey, Long.valueOf(0L), rawValue)).map(rawValue -> this.getDeserializeValue((ByteBuffer)rawValue));
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> lRightPop(String key, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForList().rightPop((Object)key, timeout);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> lRightPop(String key, Integer count) {
        try {
            return this.reactiveRedisTemplate.createFlux(connection -> {
                ByteBuffer rawKey = this.getRawKey(key);
                ReactiveListCommands listCommands = connection.listCommands();
                return listCommands.lRange(rawKey, (long)(-(count - 1)), -1L).map(rawValue -> this.getDeserializeValue((ByteBuffer)rawValue)).doOnNext(rawValue -> listCommands.lTrim(rawKey, 0L, (long)(-(count - 1))));
            });
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Object> lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        try {
            return this.reactiveRedisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> lRightPopAndLeftPush(String sourceKey, String destinationKey, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> lSet(String key, long index, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForList().set((Object)key, index, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> lSize(String key) {
        try {
            return this.reactiveRedisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> lRem(String key, long count, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> lTrim(String key, long start, long end) {
        try {
            return this.reactiveRedisTemplate.opsForList().trim((Object)key, start, end);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hDecr(String key, String hashKey, int delta) {
        if (delta < 0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, (long)(-delta));
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hDecr(String key, String hashKey, long delta) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, -delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> hDecr(String key, String hashKey, double delta) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, -delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hDel(String key, Object ... hashKeys) {
        try {
            return this.reactiveRedisTemplate.opsForHash().remove((Object)key, hashKeys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public void hDel(String bigHashKey) {
        try {
            this.hScan(bigHashKey, entry -> this.hDel(bigHashKey, ((Map.Entry)entry.get()).getKey()));
            this.del(bigHashKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Mono<Object> hGet(String key, String hashKey) {
        try {
            return this.reactiveRedisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Object> hGet(String key, String hashKey, Object defaultVal) {
        try {
            Mono rtVal = this.reactiveRedisTemplate.opsForHash().get((Object)key, (Object)hashKey);
            return rtVal.defaultIfEmpty(defaultVal);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<String> hGetString(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_STRING);
    }

    public Mono<String> hGetString(String key, String hashKey, String defaultVal) {
        Mono<String> rtVal = this.hGetString(key, hashKey);
        return rtVal.defaultIfEmpty((Object)defaultVal);
    }

    public Mono<Double> hGetDouble(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_DOUBLE);
    }

    public Mono<Double> hGetDouble(String key, String hashKey, double defaultVal) {
        Mono<Double> rtVal = this.hGetDouble(key, hashKey);
        return rtVal.defaultIfEmpty((Object)defaultVal);
    }

    public Mono<Long> hGetLong(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_LONG);
    }

    public Mono<Long> hGetLong(String key, String hashKey, long defaultVal) {
        Mono<Long> rtVal = this.hGetLong(key, hashKey);
        return rtVal.defaultIfEmpty((Object)defaultVal);
    }

    public Mono<Integer> hGetInteger(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_INTEGER);
    }

    public Mono<Integer> hGetInteger(String key, String hashKey, int defaultVal) {
        Mono<Integer> rtVal = this.hGetInteger(key, hashKey);
        return rtVal.defaultIfEmpty((Object)defaultVal);
    }

    public <T> Mono<T> hGetFor(String key, String hashKey, Class<T> clazz) {
        return this.hGetFor(key, hashKey, (Object member) -> clazz.cast(member));
    }

    public <T> Mono<T> hGetFor(String key, String hashKey, Function<Object, T> mapper) {
        Mono<Object> rt = this.hGet(key, hashKey);
        return rt.map(mapper);
    }

    public Flux<String> hGetString(Collection<String> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_STRING);
    }

    public Flux<Double> hGetDouble(Collection<String> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_DOUBLE);
    }

    public Flux<Long> hGetLong(Collection<String> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_LONG);
    }

    public Flux<Integer> hGetInteger(Collection<String> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_INTEGER);
    }

    public <T> Flux<T> hGetFor(Collection<String> keys, String hashKey, Class<T> clazz) {
        return this.hGetFor(keys, hashKey, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> hGetFor(Collection<String> keys, String hashKey, Function<Object, T> mapper) {
        Flux<Object> members = this.hGet(keys, hashKey);
        return members.map(mapper);
    }

    public Flux<Object> hGet(Collection<String> keys, String hashKey) {
        try {
            return Flux.fromIterable(keys).flatMap(key -> this.reactiveRedisTemplate.opsForHash().get(key, (Object)hashKey));
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> hGet(Collection<String> keys, String redisPrefix, String hashKey) {
        try {
            return Flux.fromIterable(keys).flatMap(key -> {
                String nkey = RedisKey.getKeyStr(redisPrefix, String.valueOf(key));
                return this.reactiveRedisTemplate.opsForHash().get((Object)nkey, (Object)hashKey);
            });
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Boolean> hHasKey(String key, String hashKey) {
        try {
            return this.reactiveRedisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Map.Entry<Object, Object>> hmGet(String key) {
        try {
            return this.reactiveRedisTemplate.opsForHash().entries((Object)key).last();
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Map.Entry<Object, Object>> hmGet(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Flux.empty();
        }
        return Flux.fromIterable(keys).flatMap(key -> this.reactiveRedisTemplate.opsForHash().entries(key));
    }

    public Flux<Map.Entry<Object, Object>> hmGet(Collection<String> keys, String redisPrefix) {
        if (CollectionUtils.isEmpty(keys)) {
            return Flux.empty();
        }
        return Flux.fromIterable(keys).flatMap(key -> {
            String nkey = RedisKey.getKeyStr(redisPrefix, key);
            return this.reactiveRedisTemplate.opsForHash().entries((Object)nkey);
        });
    }

    public Mono<List<Object>> hMultiGet(String key, Collection<Object> hashKeys) {
        try {
            return this.reactiveRedisTemplate.opsForHash().multiGet((Object)key, hashKeys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Map<String, Object>> hmMultiGet(String key, Collection<Object> hashKeys) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForHash().multiGet((Object)key, hashKeys);
            return rt.map(list -> {
                HashMap ans = new HashMap(hashKeys.size());
                int index = 0;
                for (Object hashKey : hashKeys) {
                    ans.put(hashKey.toString(), list.get(index));
                    ++index;
                }
                return ans;
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Map<String, Object>> hmMultiGet(Collection<String> keys, Collection<Object> hashKeys) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(hashKeys)) {
            return Flux.empty();
        }
        return Flux.fromIterable(keys).flatMap(key -> this.hmMultiGet((String)key, hashKeys));
    }

    public Mono<Map<String, Map<String, Object>>> hmMultiGet(Collection<String> keys, String identityHashKey, Collection<Object> hashKeys) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(hashKeys)) {
            return Mono.empty();
        }
        return Flux.fromIterable(keys).flatMap(key -> this.hmMultiGet((String)key, hashKeys)).collect(Collectors.toMap(kv -> MapUtils.getString(kv, identityHashKey), Function.identity()));
    }

    public Flux<Map.Entry<Object, Object>> hmMultiGetAll(Collection<String> keys) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Flux.empty();
            }
            return Flux.fromIterable(keys).flatMap(key -> this.reactiveRedisTemplate.opsForHash().entries(key));
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Map.Entry<Object, Object>> hmMultiGetAll(Collection<String> keys, String redisPrefix) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Flux.empty();
            }
            return Flux.fromIterable(keys).flatMap(key -> {
                String nkey = RedisKey.getKeyStr(redisPrefix, String.valueOf(key));
                return this.reactiveRedisTemplate.opsForHash().entries((Object)nkey);
            });
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Boolean> hmMultiSet(String key, Collection<String> hashKeys, Object value) {
        if (CollectionUtils.isEmpty(hashKeys) || !StringUtils.hasText((String)key)) {
            return Mono.just((Object)false);
        }
        try {
            return Flux.fromIterable(hashKeys).flatMap(hashKey -> this.reactiveRedisTemplate.opsForHash().put((Object)key, (Object)hashKeys, value)).all(rt -> rt == true);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hmSet(String key, Map<String, Object> map) {
        try {
            return this.reactiveRedisTemplate.opsForHash().putAll((Object)key, map);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hmSet(String key, Map<String, Object> map, long seconds) {
        try {
            return this.reactiveRedisTemplate.opsForHash().putAll((Object)key, map).doOnSuccess(nvalue -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hmSet(String key, Map<String, Object> map, Duration timeout) {
        try {
            return this.reactiveRedisTemplate.opsForHash().putAll((Object)key, map).doOnSuccess(nvalue -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public void hScan(String bigHashKey, Consumer<? super Signal<Map.Entry<Object, Object>>> consumer) {
        this.reactiveRedisTemplate.opsForHash().scan((Object)bigHashKey, ScanOptions.scanOptions().count(Long.MAX_VALUE).build()).doOnEach(consumer);
    }

    public void hScan(String bigHashKey, String pattern, Consumer<? super Signal<Map.Entry<Object, Object>>> consumer) {
        this.reactiveRedisTemplate.opsForHash().scan((Object)bigHashKey, ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build()).doOnEach(consumer);
    }

    public Mono<Boolean> hSet(String key, String hashKey, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hSet(String key, String hashKey, Object value, long seconds) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            return rt.doOnSuccess(nvalue -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hSet(String key, String hashKey, Object value, Duration timeout) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
            return rt.doOnSuccess(nvalue -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> hSetNX(String key, String hashKey, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForHash().putIfAbsent((Object)key, (Object)hashKey, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hSize(String key) {
        try {
            return this.reactiveRedisTemplate.opsForHash().size((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, int delta) {
        if (delta < 0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, int delta, long seconds) {
        if (delta < 0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
            return increment.doOnSuccess(value -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, int delta, Duration timeout) {
        if (delta < 0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
            return increment.doOnSuccess(value -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, long delta) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, long delta, long seconds) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
            return increment.doOnSuccess(value -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> hIncr(String key, String hashKey, long delta, Duration timeout) {
        if (delta < 0L) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
            return increment.doOnSuccess(value -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> hIncr(String key, String hashKey, double delta) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            return this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> hIncr(String key, String hashKey, double delta, long seconds) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
            return increment.doOnSuccess(value -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> hIncr(String key, String hashKey, double delta, Duration timeout) {
        if (delta < 0.0) {
            return Mono.error((Throwable)((Object)new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0")));
        }
        try {
            Mono increment = this.reactiveRedisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta);
            return increment.doOnSuccess(value -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> hKeys(String key) {
        try {
            return this.reactiveRedisTemplate.opsForHash().keys((Object)key);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> sAdd(String key, Object ... values) {
        try {
            return this.reactiveRedisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sAddAndExpire(String key, long seconds, Object ... values) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForSet().add((Object)key, values);
            return rt.doOnSuccess(value -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sAddAndExpire(String key, Duration timeout, Object ... values) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForSet().add((Object)key, values);
            return rt.doOnSuccess(value -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> sDel(String bigSetKey) {
        try {
            this.sScan(bigSetKey, value -> this.reactiveRedisTemplate.opsForSet().remove((Object)bigSetKey, new Object[]{this.getDeserializeValue((ByteBuffer)value.get())}));
            return this.reactiveRedisTemplate.delete((Object[])new String[]{bigSetKey}).map(ct -> ct > 0L);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> sGet(String key) {
        try {
            return this.reactiveRedisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> sGetString(String key) {
        return this.sGetFor(key, TO_STRING);
    }

    public Flux<Double> sGetDouble(String key) {
        return this.sGetFor(key, TO_DOUBLE);
    }

    public Flux<Long> sGetLong(String key) {
        return this.sGetFor(key, TO_LONG);
    }

    public Flux<Integer> sGetInteger(String key) {
        return this.sGetFor(key, TO_INTEGER);
    }

    public <T> Flux<T> sGetFor(String key, Class<T> clazz) {
        return this.sGetFor(key, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> sGetFor(String key, Function<Object, T> mapper) {
        Flux<Object> members = this.sGet(key);
        return members.map(mapper);
    }

    public Flux<Object> sDiff(String key, String otherKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> sDiffAndStore(String key, String otherKey, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sDiffAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().differenceAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sDiffAndStore(Collection<String> keys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().differenceAndStore(keys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> sHasKey(String key, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> sIntersect(String key, String otherKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> sIntersect(String key, Collection<String> otherKeys) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersect((Object)key, otherKeys);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> sIntersect(Collection<String> otherKeys) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersect(otherKeys);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> sIntersectAndStore(String key, String otherKey, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sIntersectAndStore(Collection<String> otherKeys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().intersectAndStore(otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> sRandomSet(String key, long count) {
        try {
            return this.reactiveRedisTemplate.opsForSet().randomMembers((Object)key, count);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> sRandomSetDistinct(String key, long count) {
        try {
            return this.reactiveRedisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> sRemove(String key, Object ... values) {
        try {
            return this.reactiveRedisTemplate.opsForSet().remove((Object)key, values);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public void sScan(String bigSetKey, Consumer<? super Signal<ByteBuffer>> consumer) {
        this.reactiveRedisTemplate.execute(redisConnection -> redisConnection.setCommands().sScan(this.getRawKey(bigSetKey), ScanOptions.scanOptions().count(Long.MAX_VALUE).build()).doOnEach(consumer));
    }

    public void sScan(String bigSetKey, String pattern, Consumer<? super Signal<ByteBuffer>> consumer) {
        this.reactiveRedisTemplate.execute(redisConnection -> redisConnection.setCommands().sScan(this.getRawKey(bigSetKey), ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build()).doOnEach(consumer));
    }

    public Mono<Long> sSetAndTime(String key, long seconds, Object ... values) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForSet().add((Object)key, values);
            return rt.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sSize(String key) {
        try {
            return this.reactiveRedisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> sUnion(String key, String otherKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().union((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> sUnion(String key, Collection<String> keys) {
        try {
            return this.reactiveRedisTemplate.opsForSet().union((Object)key, keys);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> sUnion(Collection<String> keys) {
        try {
            return this.reactiveRedisTemplate.opsForSet().union(keys);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> sUnionAndStore(String key, String otherKey, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sUnionAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().unionAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sUnionAndStore(Collection<String> keys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForSet().unionAndStore(keys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> zAdd(String key, Object value, double score) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().add((Object)key, value, score);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> tuples) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().addAll((Object)key, tuples);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zCard(String key) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().size((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> zHas(String key, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().score((Object)key, value).flatMap(score -> Mono.just((Object)Objects.nonNull(score)));
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zCount(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().count((Object)key, range);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> zDel(String bigZsetKey) {
        try {
            this.zScan(bigZsetKey, tuple -> this.zRem(bigZsetKey, ((ZSetOperations.TypedTuple)tuple.get()).getValue()));
            return this.reactiveRedisTemplate.delete((Object[])new String[]{bigZsetKey}).map(ct -> ct > 0L);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> zIncr(String key, Object value, double delta) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().incrementScore((Object)key, value, delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> zIncr(String key, Object value, double delta, long seconds) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForZSet().incrementScore((Object)key, value, delta);
            return rt.doOnSuccess(newDelta -> {
                if (seconds > 0L) {
                    this.expire(key, seconds);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> zIncr(String key, Object value, double delta, Duration timeout) {
        try {
            Mono rt = this.reactiveRedisTemplate.opsForZSet().incrementScore((Object)key, value, delta);
            return rt.doOnSuccess(newDelta -> {
                if (!timeout.isNegative()) {
                    this.expire(key, timeout);
                }
            });
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zIntersectAndStore(String key, String otherKey, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zIntersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey, aggregate);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zIntersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey, aggregate, weights);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zRem(String key, Object ... values) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().remove((Object)key, values);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zRemByScore(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().removeRangeByScore((Object)key, range);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<Object> zRange(String key, Range<Long> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().range((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> zRangeString(String key, Range<Long> range) {
        return this.zRangeFor(key, range, TO_STRING);
    }

    public Flux<Double> zRangeDouble(String key, Range<Long> range) {
        return this.zRangeFor(key, range, TO_DOUBLE);
    }

    public Flux<Long> zRangeLong(String key, Range<Long> range) {
        return this.zRangeFor(key, range, TO_LONG);
    }

    public Flux<Integer> zRangeInteger(String key, Range<Long> range) {
        return this.zRangeFor(key, range, TO_INTEGER);
    }

    public <T> Flux<T> zRangeFor(String key, Range<Long> range, Class<T> clazz) {
        return this.zRangeFor(key, range, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> zRangeFor(String key, Range<Long> range, Function<Object, T> mapper) {
        Flux<Object> members = this.zRange(key, range);
        return members.map(mapper);
    }

    public Flux<Object> zRangeByScore(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().rangeByScore((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> zRangeStringByScore(String key, Range<Double> range) {
        return this.zRangeByScoreFor(key, range, TO_STRING);
    }

    public Flux<Double> zRangeDoubleByScore(String key, Range<Double> range) {
        return this.zRangeByScoreFor(key, range, TO_DOUBLE);
    }

    public Flux<Long> zRangeLongByScore(String key, Range<Double> range) {
        return this.zRangeByScoreFor(key, range, TO_LONG);
    }

    public Flux<Integer> zRangeIntegerByScore(String key, Range<Double> range) {
        return this.zRangeByScoreFor(key, range, TO_INTEGER);
    }

    public <T> Flux<T> zRangeByScoreFor(String key, Range<Double> range, Class<T> clazz) {
        return this.zRangeByScoreFor(key, range, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> zRangeByScoreFor(String key, Range<Double> range, Function<Object, T> mapper) {
        Flux<Object> members = this.zRangeByScore(key, range);
        return members.map(mapper);
    }

    public Flux<ZSetOperations.TypedTuple<Object>> zRangeWithScores(String key, Range<Long> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().rangeWithScores((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> zRangeByLex(String key, Range range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().rangeByLex((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> zRangeByLex(String key, Range range, RedisZSetCommands.Limit limit) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().rangeByLex((Object)key, range, limit);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> zRevrange(String key, Range<Long> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().reverseRange((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> zRevrangeString(String key, Range<Long> range) {
        return this.zRevrangeFor(key, range, TO_STRING);
    }

    public Flux<Double> zRevrangeDouble(String key, Range<Long> range) {
        return this.zRevrangeFor(key, range, TO_DOUBLE);
    }

    public Flux<Long> zRevrangeLong(String key, Range<Long> range) {
        return this.zRevrangeFor(key, range, TO_LONG);
    }

    public Flux<Integer> zRevrangeInteger(String key, Range<Long> range) {
        return this.zRevrangeFor(key, range, TO_INTEGER);
    }

    public <T> Flux<Object> zRevrangeFor(String key, Range<Long> range, Class<T> clazz) {
        return this.zRevrangeFor(key, range, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> zRevrangeFor(String key, Range<Long> range, Function<Object, T> mapper) {
        Flux<Object> members = this.zRevrange(key, range);
        return members.map(mapper);
    }

    public Flux<ZSetOperations.TypedTuple<Object>> zRevrangeWithScores(String key, Range<Long> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().reverseRangeWithScores((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<Object> zRevrangeByScore(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().reverseRangeByScore((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Flux<String> zRevrangeStringByScore(String key, Range<Double> range) {
        return this.zRevrangeForByScore(key, range, TO_STRING);
    }

    public Flux<Double> zRevrangeDoubleByScore(String key, Range<Double> range) {
        return this.zRevrangeForByScore(key, range, TO_DOUBLE);
    }

    public Flux<Long> zRevrangeLongByScore(String key, Range<Double> range) {
        return this.zRevrangeForByScore(key, range, TO_LONG);
    }

    public Flux<Integer> zRevrangeIntegerByScore(String key, Range<Double> range) {
        return this.zRevrangeForByScore(key, range, TO_INTEGER);
    }

    public <T> Flux<T> zRevrangeForByScore(String key, Range<Double> range, Class<T> clazz) {
        return this.zRevrangeForByScore(key, range, (Object member) -> clazz.cast(member));
    }

    public <T> Flux<T> zRevrangeForByScore(String key, Range<Double> range, Function<Object, T> mapper) {
        Flux<Object> members = this.zRevrangeByScore(key, range);
        return members.map(mapper);
    }

    public Flux<ZSetOperations.TypedTuple<Object>> zRevrangeByScoreWithScores(String key, Range<Double> range) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, range);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Long> zRevRank(String key, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().reverseRank((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void zScan(String bigZsetKey, Consumer<? super Signal<ZSetOperations.TypedTuple<Object>>> consumer) {
        this.reactiveRedisTemplate.opsForZSet().scan((Object)bigZsetKey, ScanOptions.scanOptions().count(Long.MAX_VALUE).build()).doOnEach(consumer);
    }

    public void zScan(String bigZsetKey, String pattern, Consumer<? super Signal<ZSetOperations.TypedTuple<Object>>> consumer) {
        this.reactiveRedisTemplate.opsForZSet().scan((Object)bigZsetKey, ScanOptions.scanOptions().match(pattern).count(Long.MAX_VALUE).build()).doOnEach(consumer);
    }

    public Mono<Double> zScore(String key, Object value) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().score((Object)key, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zUnionAndStore(String key, String otherKey, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zUnionAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().unionAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zUnionAndStore(String key, Collection<String> keys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().unionAndStore((Object)key, keys, (Object)destKey, aggregate);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> zUnionAndStore(String key, Collection<String> keys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        try {
            return this.reactiveRedisTemplate.opsForZSet().unionAndStore((Object)key, keys, (Object)destKey, aggregate, weights);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> pfAdd(String key, Object ... values) {
        try {
            return this.reactiveRedisTemplate.opsForHyperLogLog().add((Object)key, values);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> pfDel(String key) {
        try {
            return this.reactiveRedisTemplate.opsForHyperLogLog().delete((Object)key);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> pfCount(String ... keys) {
        try {
            return this.reactiveRedisTemplate.opsForHyperLogLog().size((Object[])keys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> pfMerge(String destination, String ... sourceKeys) {
        try {
            return this.reactiveRedisTemplate.opsForHyperLogLog().union((Object)destination, (Object[])sourceKeys);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> setBit(String key, long offset, boolean value) {
        try {
            return this.reactiveRedisTemplate.opsForValue().setBit((Object)key, offset, value);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> getBit(String key, long offset) {
        try {
            return this.reactiveRedisTemplate.opsForValue().getBit((Object)key, offset);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> sendMessage(String channel, String message) {
        try {
            return this.reactiveRedisTemplate.convertAndSend(channel, (Object)message);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Flux<? extends ReactiveSubscription.Message<String, Object>> listenTo(Topic ... topics) {
        try {
            return this.reactiveRedisTemplate.listenTo(topics);
        }
        catch (Exception e) {
            return this.fluxError(e);
        }
    }

    public Mono<Boolean> tryBlockLock(String lockKey, int seconds) {
        try {
            return this.reactiveRedisTemplate.createMono(redisConnection -> {
                long expireAt = (Long)redisConnection.serverCommands().time().block() + (long)(seconds * 1000) + 1L;
                Boolean acquire = (Boolean)redisConnection.stringCommands().setNX(this.getRawKey(lockKey), ByteBuffer.wrap(String.valueOf(expireAt).getBytes())).block();
                if (acquire.booleanValue()) {
                    return Mono.just((Object)true);
                }
                redisConnection.listCommands().brPop(Arrays.asList(this.getRawKey(lockKey + ":list")), Duration.ofSeconds(seconds));
                return Mono.just((Object)false);
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return this.monoError(e);
        }
    }

    public Mono<Boolean> unBlockLock(String lockKey, String requestId) {
        try {
            return this.reactiveRedisTemplate.opsForValue().delete((Object)lockKey).then(this.reactiveRedisTemplate.opsForList().rightPush((Object)(lockKey + ":list"), (Object)requestId)).map(rt -> rt > 0L);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Boolean> tryLock(String lockKey, Duration timeout) {
        return this.tryLock(lockKey, timeout.toMillis());
    }

    public Mono<Boolean> tryLock(String lockKey, long expireMillis) {
        try {
            return this.reactiveRedisTemplate.createMono(redisConnection -> {
                long expireTime;
                ByteBuffer serLockKey = this.getRawKey(lockKey);
                long expireAt = (Long)redisConnection.serverCommands().time().block() + expireMillis + 1L;
                Boolean acquire = (Boolean)redisConnection.stringCommands().setNX(serLockKey, ByteBuffer.wrap(String.valueOf(expireAt).getBytes())).block();
                if (acquire.booleanValue()) {
                    return Mono.just((Object)true);
                }
                ByteBuffer buffer = (ByteBuffer)redisConnection.stringCommands().get(serLockKey).block();
                if (Objects.nonNull(buffer) && buffer.hasArray() && (expireTime = Long.parseLong(new String(buffer.array()))) < (Long)redisConnection.serverCommands().time().block()) {
                    ByteBuffer set = (ByteBuffer)redisConnection.stringCommands().getSet(serLockKey, ByteBuffer.wrap(String.valueOf((Long)redisConnection.serverCommands().time().block() + expireMillis + 1L).getBytes())).block();
                    return Mono.just((Object)(Long.parseLong(new String(set.array())) < (Long)redisConnection.serverCommands().time().block() ? 1 : 0));
                }
                return Mono.just((Object)false);
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return Mono.just((Object)false);
        }
    }

    public Mono<Boolean> unlock(String lockKey) {
        try {
            return this.reactiveRedisTemplate.delete((Object[])new String[]{lockKey}).map(ct -> ct > 0L);
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Mono<Boolean> tryLock(String lockKey, String requestId, Duration timeout, int retryTimes, long retryInterval) {
        return this.tryLock(lockKey, requestId, timeout.toMillis(), retryTimes, retryInterval);
    }

    public Mono<Boolean> tryLock(String lockKey, String requestId, long expire, int retryTimes, long retryInterval) {
        try {
            return this.reactiveRedisTemplate.createMono(redisConnection -> {
                Long result = (Long)this.executeLuaScript(LOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId, expire).block();
                if (LOCK_SUCCESS.equals(result)) {
                    log.info("locked... redisK = {}", (Object)lockKey);
                    return Mono.just((Object)true);
                }
                int count = 0;
                while (count < retryTimes) {
                    try {
                        Thread.sleep(retryInterval);
                        result = (Long)this.executeLuaScript(LOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId, expire).block();
                        if (LOCK_SUCCESS.equals(result)) {
                            log.info("locked... redisK = {}", (Object)lockKey);
                            return Mono.just((Object)true);
                        }
                        log.warn("{} times try to acquire lock", (Object)(count + 1));
                        ++count;
                    }
                    catch (Exception e) {
                        log.error("acquire redis occurred an exception", (Throwable)e);
                    }
                }
                log.info("fail to acquire lock {}", (Object)lockKey);
                return Mono.just((Object)false);
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return Mono.just((Object)false);
        }
    }

    public Mono<Boolean> unlock(String lockKey, String requestId) {
        log.info("unlock... redisK = {}", (Object)lockKey);
        try {
            Long result = (Long)this.executeLuaScript(UNLOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId).block();
            if (LOCK_SUCCESS.equals(result)) {
                log.info("release lock success. redisK = {}", (Object)lockKey);
                return Mono.just((Object)true);
            }
            if (LOCK_EXPIRED.equals(result)) {
                log.warn("release lock exception, key has expired or released");
            } else {
                log.error("release lock failed");
            }
        }
        catch (Exception e) {
            log.error("release lock occurred an exception", (Throwable)e);
            throw new RedisOperationException(e.getMessage());
        }
        return Mono.just((Object)false);
    }

    public Mono<Long> luaIncr(String key, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(INCR_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> luaIncr(String key, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            Mono<Object> rst = this.executeLuaScript(INCR_BYFLOAT_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
            return rst.map(TO_DOUBLE);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> luaDecr(String key, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(DECR_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> luaDecr(String key, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            Mono<Object> rst = this.executeLuaScript(DECR_BYFLOAT_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
            return rst.map(TO_DOUBLE);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> luaHincr(String key, String hashKey, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            RedisSerializationContext.SerializationPair serializationPair = this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair();
            Flux rst = this.reactiveRedisTemplate.execute(HINCR_SCRIPT, (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), Arrays.asList(delta), serializationPair.getWriter(), serializationPair.getReader());
            return rst.last().map(TO_LONG);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> luaHincr(String key, String hashKey, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            RedisSerializationContext.SerializationPair serializationPair = this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair();
            Flux rst = this.reactiveRedisTemplate.execute(HINCR_BYFLOAT_SCRIPT, (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), Arrays.asList(delta), serializationPair.getWriter(), serializationPair.getReader());
            return rst.last().map(TO_DOUBLE);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> luaHdecr(String key, String hashKey, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            RedisSerializationContext.SerializationPair serializationPair = this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair();
            Flux rst = this.reactiveRedisTemplate.execute(HDECR_SCRIPT, (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), Arrays.asList(delta), serializationPair.getWriter(), serializationPair.getReader());
            return rst.last().map(TO_LONG);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Double> luaHdecr(String key, String hashKey, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            RedisSerializationContext.SerializationPair serializationPair = this.reactiveRedisTemplate.getSerializationContext().getHashValueSerializationPair();
            Flux rst = this.reactiveRedisTemplate.execute(HDECR_BYFLOAT_SCRIPT, (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), Arrays.asList(delta), serializationPair.getWriter(), serializationPair.getReader());
            return rst.last().map(TO_DOUBLE);
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <T> Mono<T> executeLuaScript(String luaScript, Class<T> returnType, List<String> keys, Object ... values) {
        try {
            RedisScript redisScript = RedisScript.of((String)luaScript, returnType);
            return this.reactiveRedisTemplate.execute(redisScript, keys, Arrays.asList(values)).last();
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <T> Mono<T> executeLuaScript(RedisScript<T> luaScript, List<String> keys, Object ... values) {
        try {
            return this.reactiveRedisTemplate.execute(luaScript, keys, Arrays.asList(values)).last();
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public <T> Mono<T> executeLuaScript(Resource luaScript, Class<T> returnType, List<String> keys, Object ... values) {
        try {
            RedisScript redisScript = RedisScript.of((Resource)luaScript, returnType);
            return this.reactiveRedisTemplate.execute(redisScript, keys, Arrays.asList(values)).last();
        }
        catch (Exception e) {
            return this.monoError(e);
        }
    }

    public Mono<Long> timeNow() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().time());
    }

    public Mono<Long> period(long expiration) {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().time().map(time -> expiration - time));
    }

    public Mono<Long> dbSize() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().dbSize());
    }

    public Mono<Long> lastSave() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().lastSave());
    }

    public Mono<String> bgReWriteAof() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().bgReWriteAof());
    }

    public Mono<String> bgSave() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().bgSave());
    }

    public Mono<String> save() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().save());
    }

    public Mono<String> flushDb() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().flushDb());
    }

    public Mono<String> flushAll() {
        return this.reactiveRedisTemplate.createMono(redisConnection -> redisConnection.serverCommands().flushAll());
    }
}

