/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public enum RedisKey {
    GEO_LOCATION_KEY("\u7528\u6237\u5750\u6807", userId -> RedisKey.getKeyStr("geo:location")),
    IP_REGION_INFO("\u7528\u6237\u5750\u6807\u5bf9\u5e94\u7684\u5730\u533a\u7f16\u7801\u7f13\u5b58", ip -> RedisKey.getKeyStr("ip:region", ip)),
    IP_LOCATION_INFO("\u7528\u6237\u5750\u6807\u5bf9\u5e94\u7684\u5730\u7406\u4f4d\u7f6e\u7f13\u5b58", ip -> RedisKey.getKeyStr("ip:location", ip)),
    IP_LOCATION_BAIDU_INFO("IP\u5750\u6807\u7f13\u5b58\uff08\u767e\u5ea6\u670d\u52a1\u7f13\u5b58\uff09", ip -> RedisKey.getKeyStr("baidu:ip:location", ip)),
    IP_LOCATION_PCONLINE_INFO("IP\u5750\u6807\u7f13\u5b58\uff08\u592a\u5e73\u6d0b\u7f51\u7edc\uff09", ip -> RedisKey.getKeyStr("pconline:ip:location", ip));

    private String desc;
    private Function<Object, String> function;
    public static String REDIS_PREFIX;
    public static final String DELIMITER = ":";

    private RedisKey(String desc, Function<Object, String> function) {
        this.desc = desc;
        this.function = function;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getKey() {
        return this.function.apply(null);
    }

    public String getKey(Object key) {
        return this.function.apply(key);
    }

    public static String getKeyStr(Object ... args) {
        StringJoiner tempKey = new StringJoiner(DELIMITER);
        tempKey.add(REDIS_PREFIX);
        for (Object s : args) {
            if (Objects.isNull(s) || !StringUtils.hasText((String)s.toString())) continue;
            tempKey.add(s.toString());
        }
        return tempKey.toString();
    }

    public static String getThreadKeyStr(String prefix, Object ... args) {
        StringJoiner tempKey = new StringJoiner(DELIMITER);
        tempKey.add(prefix);
        tempKey.add(String.valueOf(Thread.currentThread().getId()));
        for (Object s : args) {
            if (Objects.isNull(s) || !StringUtils.hasText((String)s.toString())) continue;
            tempKey.add(s.toString());
        }
        return tempKey.toString();
    }

    public static void main(String[] args) {
        System.out.println(RedisKey.getKeyStr(233, ""));
    }

    static {
        REDIS_PREFIX = "rds";
    }
}

