/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

public class RedisLua {
    public static final String LOCK_LUA_SCRIPT = "if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then return redis.call('pexpire', KEYS[1], ARGV[2]) else return -1 end";
    public static final String UNLOCK_LUA_SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return -1 end";
    public static final String INCR_SCRIPT = "if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBY', KEYS[1], num);end;return -3;";
    public static final String INCR_BYFLOAT_SCRIPT = "if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBYFLOAT', KEYS[1], num);end;return -3;";
    public static final String DECR_SCRIPT = "if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBY', KEYS[1], 0 - num);    end;    return -2;end;return -3;";
    public static final String DIV_SCRIPT = "if (redis.call('EXISTS', KEYS[1]) == 1) then    local total = tonumber(redis.call('GET', KEYS[1]));    local divided = tonumber(ARGV[1]);    if (divided <= 0) then        return -3;    end;    if (total <= 0) then        return -1;    end;    return tonumber(total/divided);end;return -2;";
    public static final String DECR_BYFLOAT_SCRIPT = "if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBYFLOAT', KEYS[1], 0 - num);    end;    return -2;end;return -3;";
    public static final String HINCR_SCRIPT = "if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBY', KEYS[1], KEYS[2], num);end;return -3;";
    public static final String HDECR_SCRIPT = "if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBY', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;";
    public static final String HDIV_SCRIPT = "if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local total = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local divided = tonumber(ARGV[1]);    if (divided <= 0) then        return -3;    end;    if (total <= 0) then        return -1;    end;    return tonumber(total/divided);end;return -2;";
    public static final String HINCR_BYFLOAT_SCRIPT = "if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], num);end;return -3;";
    public static final String HDECR_BYFLOAT_SCRIPT = "if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;";
}

