/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.MapUtils;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKey;
import org.springframework.data.redis.core.RedisOperationException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedisOperationTemplate
extends AbstractOperations<String, Object> {
    private static final Logger log = LoggerFactory.getLogger(RedisOperationTemplate.class);
    private static final Long LOCK_SUCCESS = 1L;
    private static final Long LOCK_EXPIRED = -1L;
    private static final RedisScript<Long> LOCK_LUA_SCRIPT = RedisScript.of((String)"if redis.call('setnx', KEYS[1], ARGV[1]) == 1 then return redis.call('pexpire', KEYS[1], ARGV[2]) else return -1 end", Long.class);
    private static final RedisScript<Long> UNLOCK_LUA_SCRIPT = RedisScript.of((String)"if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return -1 end", Long.class);
    public static final RedisScript<Long> INCR_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBY', KEYS[1], num);end;return -3;", Long.class);
    public static final RedisScript<Long> DECR_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBY', KEYS[1], 0 - num);    end;    return -2;end;return -3;", Long.class);
    public static final RedisScript<Long> DIV_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local total = tonumber(redis.call('GET', KEYS[1]));    local divided = tonumber(ARGV[1]);    if (divided <= 0) then        return -3;    end;    if (total <= 0) then        return -1;    end;    return tonumber(total/divided);end;return -2;", Long.class);
    public static final RedisScript<Double> INCR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('INCRBYFLOAT', KEYS[1], num);end;return -3;", Double.class);
    public static final RedisScript<Double> DECR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('EXISTS', KEYS[1]) == 1) then    local stock = tonumber(redis.call('GET', KEYS[1]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('INCRBYFLOAT', KEYS[1], 0 - num);    end;    return -2;end;return -3;", Double.class);
    public static final RedisScript<Long> HINCR_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBY', KEYS[1], KEYS[2], num);end;return -3;", Long.class);
    public static final RedisScript<Long> HDECR_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBY', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;", Long.class);
    public static final RedisScript<Long> HDIV_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local total = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local divided = tonumber(ARGV[1]);    if (divided <= 0) then        return -3;    end;    if (total <= 0) then        return -1;    end;    return tonumber(total/divided);end;return -2;", Long.class);
    public static final RedisScript<Double> HINCR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local num = tonumber(ARGV[1]);    if (num < 0) then     \t  return -4;    end;    return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], num);end;return -3;", Double.class);
    public static final RedisScript<Double> HDECR_BYFLOAT_SCRIPT = RedisScript.of((String)"if (redis.call('HEXISTS', KEYS[1], KEYS[2]) == 1) then    local stock = tonumber(redis.call('HGET', KEYS[1], KEYS[2]));    local num = tonumber(ARGV[1]);    if (num <= 0) then        return -4;    end;    if (stock <= 0) then        return -1;    end;    if (stock >= num) then        return redis.call('HINCRBYFLOAT', KEYS[1], KEYS[2], 0 - num);    end;    return -2;end;return -3;", Double.class);
    public static final Function<Object, String> TO_STRING = member -> Objects.toString(member, null);
    public static final Function<Object, Double> TO_DOUBLE = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Double ? ((Double)member).doubleValue() : new BigDecimal(member.toString()).doubleValue();
    };
    public static final Function<Object, Long> TO_LONG = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Long ? ((Long)member).longValue() : new BigDecimal(member.toString()).longValue();
    };
    public static final Function<Object, Integer> TO_INTEGER = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Integer ? ((Integer)member).intValue() : new BigDecimal(member.toString()).intValue();
    };
    private final RedisTemplate<String, Object> redisTemplate;

    public RedisOperationTemplate(RedisTemplate<String, Object> redisTemplate) {
        super(redisTemplate);
        this.redisTemplate = redisTemplate;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public byte[] getRawKey(Object key) {
        return this.rawKey(key);
    }

    public byte[] getRawString(String key) {
        return this.rawString(key);
    }

    public byte[] getRawValue(Object value) {
        return this.rawValue(value);
    }

    public <V> byte[][] getRawValues(Collection<V> values) {
        return this.rawValues(new Object[]{values});
    }

    public <HK> byte[] getRawHashKey(HK hashKey) {
        return this.rawHashKey(hashKey);
    }

    public <HK> byte[][] getRawHashKeys(HK ... hashKeys) {
        return this.rawHashKeys(hashKeys);
    }

    public <HV> byte[] getRawHashValue(HV value) {
        return this.rawHashValue(value);
    }

    public byte[][] getRawKeys(String key, String otherKey) {
        return this.rawKeys(key, otherKey);
    }

    public byte[][] getRawKeys(Collection<String> keys) {
        return this.rawKeys(keys);
    }

    public byte[][] getRawKeys(String key, Collection<String> keys) {
        return this.rawKeys(key, keys);
    }

    public Set<Object> getDeserializeValues(Set<byte[]> rawValues) {
        return this.deserializeValues(rawValues);
    }

    public Set<ZSetOperations.TypedTuple<Object>> getDeserializeTupleValues(Set<RedisZSetCommands.Tuple> rawValues) {
        return this.deserializeTupleValues(rawValues);
    }

    public List<ZSetOperations.TypedTuple<Object>> getDeserializeTupleValues(List<RedisZSetCommands.Tuple> rawValues) {
        return this.deserializeTupleValues(rawValues);
    }

    public ZSetOperations.TypedTuple<Object> getDeserializeTuple(RedisZSetCommands.Tuple tuple) {
        return this.deserializeTuple(tuple);
    }

    public Set<RedisZSetCommands.Tuple> getRawTupleValues(Set<ZSetOperations.TypedTuple<Object>> values) {
        return this.rawTupleValues(values);
    }

    public List<Object> getDeserializeValues(List<byte[]> rawValues) {
        return this.deserializeValues(rawValues);
    }

    public <T> Set<T> getDeserializeHashKeys(Set<byte[]> rawKeys) {
        return this.deserializeHashKeys(rawKeys);
    }

    public <T> List<T> getDeserializeHashValues(List<byte[]> rawValues) {
        return this.deserializeHashValues(rawValues);
    }

    public <HK, HV> Map<HK, HV> getDeserializeHashMap(@Nullable Map<byte[], byte[]> entries) {
        return this.deserializeHashMap(entries);
    }

    public String getDeserializeKey(byte[] value) {
        return (String)this.deserializeKey(value);
    }

    public Set<String> getDeserializeKeys(Set<byte[]> keys) {
        return this.deserializeKeys(keys);
    }

    public Object getDeserializeValue(byte[] value) {
        return this.deserializeValue(value);
    }

    public String getDeserializeString(byte[] value) {
        return this.deserializeString(value);
    }

    public <HK> HK getDeserializeHashKey(byte[] value) {
        return (HK)this.deserializeHashKey(value);
    }

    public <HV> HV getDeserializeHashValue(byte[] value) {
        return (HV)this.deserializeHashValue(value);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<Object>> getDeserializeGeoResults(GeoResults<RedisGeoCommands.GeoLocation<byte[]>> source) {
        return this.deserializeGeoResults(source);
    }

    public Boolean hasKey(String key) {
        try {
            return this.getOperations().hasKey((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean expire(String key, long seconds) {
        try {
            return this.getOperations().expire((Object)key, seconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean expire(String key, Duration timeout) {
        try {
            return this.getOperations().expire((Object)key, timeout);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean expireAt(String key, Date date) {
        try {
            return this.getOperations().expireAt((Object)key, date);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long getExpire(String key) {
        try {
            return this.getOperations().getExpire((Object)key, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long getExpire(String key, TimeUnit unit) {
        try {
            return this.getOperations().getExpire((Object)key, unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> keys(String pattern) {
        try {
            if (Objects.isNull(pattern)) {
                return null;
            }
            Set<String> keys = this.scan(pattern);
            return keys;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }

    public boolean set(String key, Object value) {
        try {
            this.getOperations().opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void setRange(String key, Object value, long offset) {
        this.redisTemplate.opsForValue().set((Object)key, value, offset);
    }

    public boolean set(String key, Object value, long seconds) {
        try {
            if (seconds > 0L) {
                this.getOperations().opsForValue().set((Object)key, value, seconds, TimeUnit.SECONDS);
                return true;
            }
            return this.set(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean set(String key, Object value, Duration timeout) {
        if (Objects.isNull(timeout) || timeout.isNegative()) {
            return false;
        }
        try {
            this.getOperations().opsForValue().set((Object)key, value, timeout);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean setNx(String key, Object value) {
        try {
            return this.getOperations().opsForValue().setIfAbsent((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean setNx(String key, Object value, long milliseconds) {
        try {
            return this.getOperations().opsForValue().setIfAbsent((Object)key, value, Duration.ofMillis(milliseconds));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean setNx(String key, Object value, long timeout, TimeUnit unit) {
        try {
            return this.getOperations().opsForValue().setIfAbsent((Object)key, value, timeout, unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean setNx(String key, Object value, Duration timeout) {
        try {
            return this.getOperations().opsForValue().setIfAbsent((Object)key, value, timeout);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object get(String key) {
        try {
            return this.getOperations().opsForValue().get((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public String getString(String key) {
        return this.getFor(key, TO_STRING);
    }

    public String getString(String key, String defaultVal) {
        String rtVal = this.getString(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Double getDouble(String key) {
        return this.getFor(key, TO_DOUBLE);
    }

    public Double getDouble(String key, double defaultVal) {
        Double rtVal = this.getDouble(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Long getLong(String key) {
        return this.getFor(key, TO_LONG);
    }

    public Long getLong(String key, long defaultVal) {
        Long rtVal = this.getLong(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Integer getInteger(String key) {
        return this.getFor(key, TO_INTEGER);
    }

    public Integer getInteger(String key, int defaultVal) {
        Integer rtVal = this.getInteger(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public <T> T getFor(String key, Class<T> clazz) {
        return (T)this.getFor(key, (Object member) -> clazz.cast(member));
    }

    public <T> T getFor(String key, Function<Object, T> mapper) {
        Object obj = this.get(key);
        if (Objects.nonNull(obj)) {
            return mapper.apply(obj);
        }
        return null;
    }

    public String getRange(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForValue().get((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public String getStringAndSet(String key, Object value) {
        return this.getForAndSet(key, value, TO_STRING);
    }

    public Double getDoubleAndSet(String key, Object value) {
        return this.getForAndSet(key, value, TO_DOUBLE);
    }

    public Long getLongAndSet(String key, Object value) {
        return this.getForAndSet(key, value, TO_LONG);
    }

    public Integer getIntegerAndSet(String key, Object value) {
        return this.getForAndSet(key, value, TO_INTEGER);
    }

    public <T> T getForAndSet(String key, Object value, Function<Object, T> mapper) {
        Object obj = this.getAndSet(key, value);
        if (Objects.nonNull(obj)) {
            return mapper.apply(obj);
        }
        return null;
    }

    public Object getAndSet(String key, Object value) {
        try {
            return this.redisTemplate.opsForValue().getAndSet((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> mGet(String pattern) {
        try {
            if (!StringUtils.hasText((String)pattern)) {
                return Lists.newArrayList();
            }
            Set<String> keys = this.keys(pattern);
            return this.getOperations().opsForValue().multiGet(keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Double> mGetDouble(Collection keys) {
        return this.mGetFor(keys, TO_DOUBLE);
    }

    public List<Long> mGetLong(Collection keys) {
        return this.mGetFor(keys, TO_LONG);
    }

    public List<Integer> mGetInteger(Collection keys) {
        return this.mGetFor(keys, TO_INTEGER);
    }

    public List<String> mGetString(Collection keys) {
        return this.mGetFor(keys, TO_STRING);
    }

    public <T> List<T> mGetFor(Collection keys, Class<T> clazz) {
        return this.mGetFor(keys, (Object member) -> clazz.cast(member));
    }

    public <T> List<T> mGetFor(Collection keys, Function<Object, T> mapper) {
        List<Object> members = this.mGet(keys);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toList());
        }
        return null;
    }

    public List<Object> mGet(Collection keys) {
        try {
            if (CollectionUtils.isEmpty((Collection)keys)) {
                return Lists.newArrayList();
            }
            return this.getOperations().opsForValue().multiGet(keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> mGet(Collection<Object> keys, String redisPrefix) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Lists.newArrayList();
            }
            Collection newKeys = keys.stream().map(key -> RedisKey.getKeyStr(redisPrefix, key.toString())).collect(Collectors.toList());
            return this.getOperations().opsForValue().multiGet(newKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForValue().increment((Object)key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta, long seconds) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForValue().increment((Object)key, delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForValue().increment((Object)key, delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double incr(String key, double delta) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForValue().increment((Object)key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double incr(String key, double delta, long seconds) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForValue().increment((Object)key, delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double incr(String key, double delta, Duration timeout) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForValue().increment((Object)key, delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForValue().increment((Object)key, -delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta, long seconds) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForValue().increment((Object)key, -delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForValue().increment((Object)key, -delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double decr(String key, double delta) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForValue().increment((Object)key, -delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double decr(String key, double delta, long seconds) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForValue().increment((Object)key, -delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double decr(String key, double delta, Duration timeout) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForValue().increment((Object)key, -delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void del(String ... keys) {
        try {
            if (keys != null && keys.length > 0) {
                if (keys.length == 1) {
                    this.getOperations().delete((Object)keys[0]);
                } else {
                    this.getOperations().delete((Collection)Stream.of(keys).collect(Collectors.toList()));
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long delPattern(String pattern) {
        try {
            Set<String> keys = this.keys(pattern);
            if (CollectionUtils.isEmpty(keys)) {
                return 0L;
            }
            return this.getOperations().delete(keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> scan(String pattern, long count) {
        ScanOptions options = ScanOptions.scanOptions().count(count).match(pattern).build();
        return this.scan(options);
    }

    public Set<String> scan(String pattern) {
        ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
        return this.scan(options);
    }

    public Set<String> scan(ScanOptions options) {
        return (Set)this.getOperations().execute(redisConnection -> {
            try (Cursor cursor = redisConnection.scan(options);){
                HashSet<String> keysTmp = new HashSet<String>();
                while (cursor.hasNext()) {
                    keysTmp.add(this.deserializeString((byte[])cursor.next()));
                }
                HashSet<String> hashSet = keysTmp;
                return hashSet;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RedisOperationException(e.getMessage());
            }
        });
    }

    public List<Object> lRange(String key, long start, long end) {
        try {
            return this.getOperations().opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<String> lRangeString(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_STRING);
    }

    public List<Double> lRangeDouble(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_DOUBLE);
    }

    public List<Long> lRangeLong(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_LONG);
    }

    public List<Integer> lRangeInteger(String key, long start, long end) {
        return this.lRangeFor(key, start, end, TO_INTEGER);
    }

    public <T> List<T> lRangeFor(String key, long start, long end, Class<T> clazz) {
        return this.lRangeFor(key, start, end, (Object member) -> clazz.cast(member));
    }

    public <T> List<T> lRangeFor(String key, long start, long end, Function<Object, T> mapper) {
        List<Object> members = this.lRange(key, start, end);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toList());
        }
        return null;
    }

    public Object lIndex(String key, long index) {
        try {
            return this.getOperations().opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public String lIndexString(String key, long index) {
        return this.lIndexFor(key, index, TO_STRING);
    }

    public String glIndexString(String key, long index, String defaultVal) {
        String rtVal = this.lIndexString(key, index);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Double lIndexDouble(String key, long index) {
        return this.lIndexFor(key, index, TO_DOUBLE);
    }

    public Double lIndexDouble(String key, long index, double defaultVal) {
        Double rtVal = this.lIndexDouble(key, index);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Long lIndexLong(String key, long index) {
        return this.lIndexFor(key, index, TO_LONG);
    }

    public Long lIndexLong(String key, long index, long defaultVal) {
        Long rtVal = this.lIndexLong(key, index);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Integer lIndexInteger(String key, long index) {
        return this.lIndexFor(key, index, TO_INTEGER);
    }

    public Integer lIndexInteger(String key, long index, int defaultVal) {
        Integer rtVal = this.lIndexInteger(key, index);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public <T> T lIndexFor(String key, long index, Function<Object, T> mapper) {
        Object member = this.lIndex(key, index);
        if (Objects.nonNull(member)) {
            return mapper.apply(member);
        }
        return null;
    }

    public <V> Long lLeftPushDistinct(String key, V value) {
        try {
            List result = this.getOperations().executePipelined(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                byte[] rawValue = this.rawValue(value);
                redisConnection.lRem(rawKey, 0L, rawValue);
                redisConnection.lPush(rawKey, (byte[][])new byte[][]{rawValue});
                return null;
            }, this.valueSerializer());
            return (Long)result.get(1);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPush(String key, V value) {
        return this.lLeftPush(key, value, 0L);
    }

    public <V> Long lLeftPush(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lLeftPushAll(key, (Collection)value, seconds);
        }
        try {
            Long rt = this.getOperations().opsForList().leftPush((Object)key, value);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPush(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lLeftPushAll(key, (Collection)value, timeout);
        }
        try {
            Long rt = this.getOperations().opsForList().leftPush((Object)key, value);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushAll(String key, Collection<V> values) {
        try {
            Long rt = this.getOperations().opsForList().leftPushAll((Object)key, values.toArray());
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushAll(String key, Collection<V> values, long seconds) {
        try {
            Long rt = this.getOperations().opsForList().leftPushAll((Object)key, values.toArray());
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushAll(String key, Collection<V> values, Duration timeout) {
        try {
            Long rt = this.getOperations().opsForList().leftPushAll((Object)key, values.toArray());
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushx(String key, V value) {
        return this.lLeftPushx(key, value, 0L);
    }

    public <V> Long lLeftPushx(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lLeftPushxAll(key, (Collection)value, seconds);
        }
        try {
            Long rt = this.getOperations().opsForList().leftPushIfPresent((Object)key, value);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushx(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lLeftPushxAll(key, (Collection)value, timeout);
        }
        try {
            Long rt = this.getOperations().opsForList().leftPushIfPresent((Object)key, value);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushxAll(String key, Collection<V> values, long seconds) {
        try {
            long rt = values.stream().map(value -> this.getOperations().opsForList().leftPushIfPresent((Object)key, value)).count();
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lLeftPushxAll(String key, Collection<V> values, Duration timeout) {
        try {
            long rt = values.stream().map(value -> this.getOperations().opsForList().leftPushIfPresent((Object)key, value)).count();
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lLeftPop(String key) {
        try {
            return this.getOperations().opsForList().leftPop((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Object lLeftPopAndLrem(String key) {
        try {
            return this.getOperations().execute(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                byte[] rawValue = redisConnection.lPop(rawKey);
                redisConnection.lRem(rawKey, 0L, rawValue);
                return this.deserializeValue(rawValue);
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lLeftPop(String key, long timeout, TimeUnit unit) {
        try {
            return this.getOperations().opsForList().leftPop((Object)key, timeout, unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lLeftPop(String key, Duration timeout) {
        try {
            return this.getOperations().opsForList().leftPop((Object)key, timeout);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> lLeftPop(String key, Integer count) {
        try {
            List result = this.getOperations().executePipelined(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                redisConnection.lRange(rawKey, 0L, (long)(count - 1));
                redisConnection.lTrim(rawKey, (long)count.intValue(), -1L);
                return null;
            }, this.valueSerializer());
            return (List)result.get(0);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <T> List<T> lLeftPop(String key, Integer count, Class<T> clazz) {
        try {
            List<Object> range = this.lLeftPop(key, count);
            List result = range.stream().map(member -> clazz.cast(member)).collect(Collectors.toList());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushDistinct(String key, V value) {
        try {
            List result = this.getOperations().executePipelined(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                byte[] rawValue = this.rawValue(value);
                redisConnection.lRem(rawKey, 0L, rawValue);
                redisConnection.rPush(rawKey, (byte[][])new byte[][]{rawValue});
                return null;
            }, this.valueSerializer());
            return (Long)result.get(1);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPush(String key, V value) {
        return this.lRightPush(key, value, 0L);
    }

    public <V> Long lRightPush(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lRightPushAll(key, (Collection)value, seconds);
        }
        try {
            Long rt = this.getOperations().opsForList().rightPush((Object)key, value);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPush(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lRightPushAll(key, (Collection)value, timeout);
        }
        try {
            Long rt = this.getOperations().opsForList().rightPush((Object)key, value);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushAll(String key, Collection<V> values) {
        try {
            return this.getOperations().opsForList().rightPushAll((Object)key, values.toArray());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushAll(String key, Collection<V> values, long seconds) {
        try {
            Long rt = this.getOperations().opsForList().rightPushAll((Object)key, values.toArray());
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushAll(String key, Collection<V> values, Duration timeout) {
        try {
            Long rt = this.getOperations().opsForList().rightPushAll((Object)key, values.toArray());
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushx(String key, V value) {
        return this.lRightPushx(key, value, 0L);
    }

    public <V> Long lRightPushx(String key, V value, long seconds) {
        if (value instanceof Collection) {
            return this.lRightPushxAll(key, (Collection)value, seconds);
        }
        try {
            Long rt = this.getOperations().opsForList().rightPushIfPresent((Object)key, value);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushx(String key, V value, Duration timeout) {
        if (value instanceof Collection) {
            return this.lRightPushxAll(key, (Collection)value, timeout);
        }
        try {
            Long rt = this.getOperations().opsForList().rightPushIfPresent((Object)key, value);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushxAll(String key, Collection<V> values, long seconds) {
        try {
            long rt = values.stream().map(value -> this.getOperations().opsForList().rightPushIfPresent((Object)key, value)).count();
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Long lRightPushxAll(String key, Collection<V> values, Duration timeout) {
        try {
            long rt = values.stream().map(value -> this.getOperations().opsForList().rightPushIfPresent((Object)key, value)).count();
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPop(String key) {
        try {
            return this.getOperations().opsForList().rightPop((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> Object lRightPopAndLrem(String key) {
        try {
            return this.getOperations().execute(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                byte[] rawValue = redisConnection.rPop(rawKey);
                redisConnection.lRem(rawKey, 0L, rawValue);
                return this.deserializeValue(rawValue);
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPop(String key, long timeout, TimeUnit unit) {
        try {
            return this.getOperations().opsForList().rightPop((Object)key, timeout, unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPop(String key, Duration timeout) {
        try {
            return this.getOperations().opsForList().rightPop((Object)key, timeout);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> lRightPop(String key, Integer count) {
        try {
            List result = this.getOperations().executePipelined(redisConnection -> {
                byte[] rawKey = this.rawKey(key);
                redisConnection.lRange(rawKey, (long)(-(count - 1)), -1L);
                redisConnection.lTrim(rawKey, 0L, (long)(-(count - 1)));
                return null;
            }, this.valueSerializer());
            return (List)result.get(0);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        try {
            return this.getOperations().opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        try {
            return this.getOperations().opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey, Duration timeout) {
        try {
            return this.getOperations().opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean lSet(String key, long index, Object value) {
        try {
            this.getOperations().opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public long lSize(String key) {
        try {
            return this.getOperations().opsForList().size((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean lTrim(String key, long start, long end) {
        try {
            this.getOperations().opsForList().trim((Object)key, start, end);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long lRem(String key, long count, Object value) {
        try {
            return this.getOperations().opsForList().remove((Object)key, count, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hDecr(String key, String hashKey, int delta) {
        if (delta < 0) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, (long)(-delta));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hDecr(String key, String hashKey, long delta) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, -delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double hDecr(String key, String hashKey, double delta) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, -delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void hDel(String key, Object ... hashKeys) {
        try {
            this.getOperations().opsForHash().delete((Object)key, hashKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void hDel(String bigHashKey) {
        try {
            this.hScan(bigHashKey, (Map.Entry<Object, Object> entry) -> this.hDel(bigHashKey, entry.getKey()));
            this.del(bigHashKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Object hGet(String key, String hashKey) {
        try {
            return this.getOperations().opsForHash().get((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <V> V hGet(String key, String hashKey, V defaultVal) {
        try {
            Object rtVal = this.getOperations().opsForHash().get((Object)key, (Object)hashKey);
            return (V)(Objects.nonNull(rtVal) ? rtVal : defaultVal);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public String hGetString(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_STRING);
    }

    public String hGetString(String key, String hashKey, String defaultVal) {
        String rtVal = this.hGetString(key, hashKey);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Double hGetDouble(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_DOUBLE);
    }

    public Double hGetDouble(String key, String hashKey, double defaultVal) {
        Double rtVal = this.hGetDouble(key, hashKey);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Long hGetLong(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_LONG);
    }

    public Long hGetLong(String key, String hashKey, long defaultVal) {
        Long rtVal = this.hGetLong(key, hashKey);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Integer hGetInteger(String key, String hashKey) {
        return this.hGetFor(key, hashKey, TO_INTEGER);
    }

    public Integer hGetInteger(String key, String hashKey, int defaultVal) {
        Integer rtVal = this.hGetInteger(key, hashKey);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public <T> T hGetFor(String key, String hashKey, Class<T> clazz) {
        return (T)this.hGetFor(key, hashKey, (Object member) -> clazz.cast(member));
    }

    public <T> T hGetFor(String key, String hashKey, Function<Object, T> mapper) {
        Object rt = this.hGet(key, hashKey);
        return Objects.nonNull(rt) ? (T)mapper.apply(rt) : null;
    }

    public List<String> hGetString(Collection<Object> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_STRING);
    }

    public List<Double> hGetDouble(Collection<Object> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_DOUBLE);
    }

    public List<Long> hGetLong(Collection<Object> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_LONG);
    }

    public List<Integer> hGetInteger(Collection<Object> keys, String hashKey) {
        return this.hGetFor(keys, hashKey, TO_INTEGER);
    }

    public <T> List<T> hGetFor(Collection<Object> keys, String hashKey, Class<T> clazz) {
        return this.hGetFor(keys, hashKey, (Object member) -> clazz.cast(member));
    }

    public <T> List<T> hGetFor(Collection<Object> keys, String hashKey, Function<Object, T> mapper) {
        List<Object> members = this.hGet(keys, hashKey);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toList());
        }
        return null;
    }

    public List<Object> hGet(Collection<Object> keys, String hashKey) {
        try {
            List result = this.getOperations().executePipelined(connection -> {
                keys.stream().forEach(key -> connection.hGet(this.rawKey(key), this.rawHashKey(hashKey)));
                return null;
            }, this.valueSerializer());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> hGet(Collection<Object> keys, String redisPrefix, String hashKey) {
        try {
            List result = this.getOperations().executePipelined(connection -> {
                keys.stream().forEach(key -> {
                    byte[] rawKey = this.rawKey(RedisKey.getKeyStr(redisPrefix, String.valueOf(key)));
                    connection.hGet(rawKey, this.rawHashKey(hashKey));
                });
                return null;
            }, this.valueSerializer());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hHasKey(String key, String hashKey) {
        try {
            return this.getOperations().opsForHash().hasKey((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Map<String, Object> hmGet(String key) {
        try {
            HashOperations opsForHash = this.getOperations().opsForHash();
            return opsForHash.entries((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Map<String, Object>> hmGet(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        return keys.parallelStream().map(key -> this.hmGet((String)key)).collect(Collectors.toList());
    }

    public List<Map<String, Object>> hmGet(Collection<String> keys, String redisPrefix) {
        if (CollectionUtils.isEmpty(keys)) {
            return Lists.newArrayList();
        }
        return keys.parallelStream().map(key -> this.hmGet(RedisKey.getKeyStr(redisPrefix, key))).collect(Collectors.toList());
    }

    public List<Object> hMultiGet(String key, Collection<Object> hashKeys) {
        try {
            return this.getOperations().opsForHash().multiGet((Object)key, hashKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Map<String, Object> hmMultiGet(String key, Collection<Object> hashKeys) {
        try {
            List result = this.getOperations().opsForHash().multiGet((Object)key, hashKeys);
            HashMap<String, Object> ans = new HashMap<String, Object>(hashKeys.size());
            int index = 0;
            for (Object hashKey : hashKeys) {
                ans.put(hashKey.toString(), result.get(index));
                ++index;
            }
            return ans;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Map<String, Object>> hmMultiGet(Collection<String> keys, Collection<Object> hashKeys) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(hashKeys)) {
            return Lists.newArrayList();
        }
        return keys.parallelStream().map(key -> this.hmMultiGet((String)key, hashKeys)).collect(Collectors.toList());
    }

    public Map<String, Map<String, Object>> hmMultiGet(Collection<String> keys, String identityHashKey, Collection<Object> hashKeys) {
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(hashKeys)) {
            return Maps.newHashMap();
        }
        return keys.parallelStream().map(key -> this.hmMultiGet((String)key, hashKeys)).collect(Collectors.toMap(kv -> MapUtils.getString(kv, identityHashKey), Function.identity()));
    }

    public List<Map<String, Object>> hmMultiGetAll(Collection<Object> keys) {
        try {
            List result = this.getOperations().executePipelined(connection -> {
                keys.stream().forEach(key -> {
                    byte[] rawKey = this.rawKey(String.valueOf(key));
                    connection.hGetAll(rawKey);
                });
                return null;
            }, this.valueSerializer());
            return result.stream().map(mapper -> (Map)mapper).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> hMultiGet(Collection<Object> keys, String hashKey) {
        try {
            List result = this.getOperations().executePipelined(connection -> {
                byte[] rawHashKey = this.rawHashKey(hashKey);
                keys.stream().forEach(key -> {
                    byte[] rawKey = this.rawKey(String.valueOf(key));
                    connection.hGet(rawKey, rawHashKey);
                });
                return null;
            }, this.valueSerializer());
            return result.stream().collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<String> hMultiGetString(Collection<Object> keys, String hashKey) {
        return this.hMultiGetFor(keys, hashKey, TO_STRING);
    }

    public List<Double> hMultiGetDouble(Collection<Object> keys, String hashKey) {
        return this.hMultiGetFor(keys, hashKey, TO_DOUBLE);
    }

    public List<Long> hMultiGetLong(Collection<Object> keys, String hashKey) {
        return this.hMultiGetFor(keys, hashKey, TO_LONG);
    }

    public List<Integer> hMultiGetInteger(Collection<Object> keys, String hashKey) {
        return this.hMultiGetFor(keys, hashKey, TO_INTEGER);
    }

    public <T> List<T> hMultiGetFor(Collection<Object> keys, String hashKey, Class<T> clazz) {
        return this.hMultiGetFor(keys, hashKey, (Object member) -> clazz.cast(member));
    }

    public <T> List<T> hMultiGetFor(Collection<Object> keys, String hashKey, Function<Object, T> mapper) {
        List<Object> members = this.hMultiGet(keys, hashKey);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toList());
        }
        return null;
    }

    public List<Map<String, Object>> hmMultiGetAll(Collection<Object> keys, String redisPrefix) {
        try {
            List result = this.getOperations().executePipelined(connection -> {
                keys.stream().forEach(key -> {
                    byte[] rawKey = this.rawKey(RedisKey.getKeyStr(redisPrefix, String.valueOf(key)));
                    connection.hGetAll(rawKey);
                });
                return null;
            }, this.valueSerializer());
            return result.stream().map(mapper -> (Map)mapper).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hmMultiSet(String key, Collection<Object> hashKeys, Object value) {
        if (CollectionUtils.isEmpty(hashKeys) || !StringUtils.hasText((String)key)) {
            return false;
        }
        try {
            this.getOperations().executePipelined(connection -> {
                byte[] rawKey = this.rawKey(key);
                byte[] rawHashValue = this.rawHashValue(value);
                for (Object hashKey : hashKeys) {
                    connection.hSet(rawKey, this.rawHashKey(hashKey), rawHashValue);
                }
                return null;
            });
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hmSet(String key, Map<String, Object> map) {
        try {
            this.getOperations().opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hmSet(String key, Map<String, Object> map, long seconds) {
        try {
            this.getOperations().opsForHash().putAll((Object)key, map);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hmSet(String key, Map<String, Object> map, Duration timeout) {
        try {
            this.getOperations().opsForHash().putAll((Object)key, map);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void hScan(String bigHashKey, Consumer<Map.Entry<Object, Object>> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).build();
        this.hScan(bigHashKey, options).forEachRemaining(consumer);
    }

    public void hScan(String bigHashKey, String pattern, Consumer<Map.Entry<Object, Object>> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build();
        this.hScan(bigHashKey, options).forEachRemaining(consumer);
    }

    public void hScan(String bigHashKey, ScanOptions options, Consumer<Map.Entry<Object, Object>> consumer) {
        this.hScan(bigHashKey, options).forEachRemaining(consumer);
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String bigHashKey, ScanOptions options) {
        return this.getOperations().opsForHash().scan((Object)bigHashKey, options);
    }

    public boolean hSet(String key, String hashKey, Object value) {
        try {
            this.getOperations().opsForHash().put((Object)key, (Object)hashKey, value);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hSet(String key, String hashKey, Object value, long seconds) {
        try {
            this.getOperations().opsForHash().put((Object)key, (Object)hashKey, value);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hSet(String key, String hashKey, Object value, Duration timeout) {
        try {
            this.getOperations().opsForHash().put((Object)key, (Object)hashKey, value);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean hSetNX(String key, String hashKey, Object value) {
        try {
            return this.getOperations().opsForHash().putIfAbsent((Object)key, (Object)hashKey, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> hKeys(String key) {
        try {
            return this.getOperations().opsForHash().keys((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hSize(String key) {
        try {
            return this.getOperations().opsForHash().size((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> hValues(String key) {
        try {
            return this.getOperations().opsForHash().values((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, int delta) {
        if (delta < 0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, int delta, long seconds) {
        if (delta < 0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, int delta, Duration timeout) {
        if (delta < 0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, (long)delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, long delta) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, long delta, long seconds) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long hIncr(String key, String hashKey, long delta, Duration timeout) {
        if (delta < 0L) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Long increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double hIncr(String key, String hashKey, double delta) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double hIncr(String key, String hashKey, double delta, long seconds) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double hIncr(String key, String hashKey, double delta, Duration timeout) {
        if (delta < 0.0) {
            throw new RedisOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            Double increment = this.getOperations().opsForHash().increment((Object)key, (Object)hashKey, delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return increment;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sAdd(String key, Object ... values) {
        try {
            return this.getOperations().opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sAddAndExpire(String key, long seconds, Object ... values) {
        try {
            Long rt = this.getOperations().opsForSet().add((Object)key, values);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sAddAndExpire(String key, Duration timeout, Object ... values) {
        try {
            Long rt = this.getOperations().opsForSet().add((Object)key, values);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return rt;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean sDel(String bigSetKey) {
        try {
            this.sScan(bigSetKey, value -> this.getOperations().opsForSet().remove((Object)bigSetKey, new Object[]{this.deserializeValue((byte[])value)}));
            return this.getOperations().delete((Object)bigSetKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sGet(String key) {
        try {
            return this.getOperations().opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> sGetString(String key) {
        return this.sGetFor(key, TO_STRING);
    }

    public Set<Double> sGetDouble(String key) {
        return this.sGetFor(key, TO_DOUBLE);
    }

    public Set<Long> sGetLong(String key) {
        return this.sGetFor(key, TO_LONG);
    }

    public Set<Integer> sGetInteger(String key) {
        return this.sGetFor(key, TO_INTEGER);
    }

    public <T> Set<T> sGetFor(String key, Class<T> clazz) {
        return this.sGetFor(key, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> sGetFor(String key, Function<Object, T> mapper) {
        Set<Object> members = this.sGet(key);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<Object> sDiff(String key, String otherKey) {
        try {
            return this.getOperations().opsForSet().difference((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sDiffAndStore(String key, String otherKey, String destKey) {
        try {
            return this.getOperations().opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sDiffAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.getOperations().opsForSet().differenceAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sDiffAndStore(Collection<String> keys, String destKey) {
        try {
            return this.getOperations().opsForSet().differenceAndStore(keys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.getOperations().opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sIntersect(String key, String otherKey) {
        try {
            return this.getOperations().opsForSet().intersect((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sIntersect(String key, Collection<String> otherKeys) {
        try {
            return this.getOperations().opsForSet().intersect((Object)key, otherKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sIntersect(Collection<String> otherKeys) {
        try {
            return this.getOperations().opsForSet().intersect(otherKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sIntersectAndStore(String key, String otherKey, String destKey) {
        try {
            return this.getOperations().opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        try {
            return this.getOperations().opsForSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sIntersectAndStore(Collection<String> otherKeys, String destKey) {
        try {
            return this.getOperations().opsForSet().intersectAndStore(otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<String> sRandomString(String key, long count) {
        return this.sRandomFor(key, count, TO_STRING);
    }

    public List<Double> sRandomDouble(String key, long count) {
        return this.sRandomFor(key, count, TO_DOUBLE);
    }

    public List<Long> sRandomLong(String key, long count) {
        return this.sRandomFor(key, count, TO_LONG);
    }

    public List<Integer> sRandomInteger(String key, long count) {
        return this.sRandomFor(key, count, TO_INTEGER);
    }

    public <T> List<T> sRandomFor(String key, long count, Class<T> clazz) {
        return this.sRandomFor(key, count, (Object member) -> clazz.cast(member));
    }

    public <T> List<T> sRandomFor(String key, long count, Function<Object, T> mapper) {
        List<Object> members = this.sRandom(key, count);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toList());
        }
        return null;
    }

    public List<Object> sRandom(String key, long count) {
        try {
            return this.getOperations().opsForSet().randomMembers((Object)key, count);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> sRandomDistinctString(String key, long count) {
        return this.sRandomDistinctFor(key, count, TO_STRING);
    }

    public Set<Double> sRandomDistinctDouble(String key, long count) {
        return this.sRandomDistinctFor(key, count, TO_DOUBLE);
    }

    public Set<Long> sRandomDistinctLong(String key, long count) {
        return this.sRandomDistinctFor(key, count, TO_LONG);
    }

    public Set<Integer> sRandomDistinctInteger(String key, long count) {
        return this.sRandomDistinctFor(key, count, TO_INTEGER);
    }

    public <T> Set<T> sRandomDistinctFor(String key, long count, Class<T> clazz) {
        return this.sRandomDistinctFor(key, count, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> sRandomDistinctFor(String key, long count, Function<Object, T> mapper) {
        Set<Object> members = this.sRandomDistinct(key, count);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<Object> sRandomDistinct(String key, long count) {
        try {
            return this.getOperations().opsForSet().distinctRandomMembers((Object)key, count);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sRemove(String key, Object ... values) {
        try {
            Long count = this.getOperations().opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void sScan(String bigSetKey, Consumer<byte[]> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).build();
        this.sScan(bigSetKey, options, consumer);
    }

    public void sScan(String bigSetKey, String pattern, Consumer<byte[]> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build();
        this.sScan(bigSetKey, options, consumer);
    }

    public void sScan(String bigSetKey, ScanOptions options, Consumer<byte[]> consumer) {
        this.getOperations().execute(redisConnection -> {
            try (Cursor cursor = redisConnection.sScan(this.rawKey(bigSetKey), options);){
                cursor.forEachRemaining(consumer);
                Object var7_8 = null;
                return var7_8;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RedisOperationException(e.getMessage());
            }
        });
    }

    public Long sSetAndTime(String key, long seconds, Object ... values) {
        try {
            Long count = this.getOperations().opsForSet().add((Object)key, values);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return count;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sSize(String key) {
        try {
            return this.getOperations().opsForSet().size((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sUnion(String key, String otherKey) {
        try {
            return this.getOperations().opsForSet().union((Object)key, (Object)otherKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sUnion(String key, Collection<String> keys) {
        try {
            return this.getOperations().opsForSet().union((Object)key, keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> sUnion(Collection<String> keys) {
        try {
            return this.getOperations().opsForSet().union(keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sUnionAndStore(String key, String otherKey, String destKey) {
        try {
            return this.getOperations().opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sUnionAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.getOperations().opsForSet().unionAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long sUnionAndStore(Collection<String> keys, String destKey) {
        try {
            return this.getOperations().opsForSet().unionAndStore(keys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zAdd(String key, Object value, double score) {
        try {
            return this.getOperations().opsForZSet().add((Object)key, value, score);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zAdd(String key, Object value, double score, long seconds) {
        try {
            Boolean result = this.getOperations().opsForZSet().add((Object)key, value, score);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zAdd(String key, Object value, double score, Duration timeout) {
        try {
            Boolean result = this.getOperations().opsForZSet().add((Object)key, value, score);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> tuples) {
        try {
            return this.getOperations().opsForZSet().add((Object)key, tuples);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> tuples, long seconds) {
        try {
            Long result = this.getOperations().opsForZSet().add((Object)key, tuples);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> tuples, Duration timeout) {
        try {
            Long result = this.getOperations().opsForZSet().add((Object)key, tuples);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zCard(String key) {
        try {
            return this.getOperations().opsForZSet().zCard((Object)key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zHas(String key, Object value) {
        try {
            return this.getOperations().opsForZSet().score((Object)key, value) != null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zCount(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().count((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zDel(String bigZsetKey) {
        try {
            this.zScan(bigZsetKey, tuple -> this.zRem(bigZsetKey, this.deserializeTuple((RedisZSetCommands.Tuple)tuple).getValue()));
            return this.getOperations().delete((Object)bigZsetKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double zIncr(String key, Object value, double delta) {
        try {
            return this.getOperations().opsForZSet().incrementScore((Object)key, value, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double zIncr(String key, Object value, double delta, long seconds) {
        try {
            Double result = this.getOperations().opsForZSet().incrementScore((Object)key, value, delta);
            if (seconds > 0L) {
                this.expire(key, seconds);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double zIncr(String key, Object value, double delta, Duration timeout) {
        try {
            Double result = this.getOperations().opsForZSet().incrementScore((Object)key, value, delta);
            if (!timeout.isNegative()) {
                this.expire(key, timeout);
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean zIncrAndWatch(String key, Object value, double delta, long start, long end) {
        try {
            byte[] rawKey = this.rawKey(key);
            byte[] rawValue = this.rawValue(value);
            return (Boolean)this.template.execute(redisConnection -> {
                Set zset1 = this.deserializeTupleValues(redisConnection.zRevRangeWithScores(rawKey, start, end));
                redisConnection.zIncrBy(rawKey, delta, rawValue);
                Set zset2 = this.deserializeTupleValues(redisConnection.zRevRangeWithScores(rawKey, start, end));
                if (CollectionUtils.isEmpty((Collection)zset1) && !CollectionUtils.isEmpty((Collection)zset2) || !CollectionUtils.isEmpty((Collection)zset1) && CollectionUtils.isEmpty((Collection)zset2)) {
                    return Boolean.TRUE;
                }
                if (zset1.size() != zset2.size()) {
                    return Boolean.TRUE;
                }
                ArrayList keyList1 = Objects.isNull(zset1) ? Lists.newArrayList() : zset1.stream().map(item -> item.getValue().toString()).collect(Collectors.toList());
                ArrayList keyList2 = Objects.isNull(zset2) ? Lists.newArrayList() : zset2.stream().map(item -> item.getValue().toString()).collect(Collectors.toList());
                for (int i = 0; i < keyList1.size(); ++i) {
                    if (Objects.equals(keyList1.get(i), keyList2.get(i))) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }, true);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zIntersectAndStore(String key, String otherKey, String destKey) {
        try {
            return this.getOperations().opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        try {
            return this.getOperations().opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        try {
            return this.getOperations().opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey, aggregate);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        try {
            return this.getOperations().opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey, aggregate, weights);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zRem(String key, Object ... values) {
        try {
            return this.getOperations().opsForZSet().remove((Object)key, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zRemByScore(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().removeRangeByScore((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> zRangeString(String key, long start, long end) {
        return this.zRangeFor(key, start, end, TO_STRING);
    }

    public Set<Double> zRangeDouble(String key, long start, long end) {
        return this.zRangeFor(key, start, end, TO_DOUBLE);
    }

    public Set<Long> zRangeLong(String key, long start, long end) {
        return this.zRangeFor(key, start, end, TO_LONG);
    }

    public Set<Integer> zRangeInteger(String key, long start, long end) {
        return this.zRangeFor(key, start, end, TO_INTEGER);
    }

    public <T> Set<T> zRangeFor(String key, long start, long end, Class<T> clazz) {
        return this.zRangeFor(key, start, end, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> zRangeFor(String key, long start, long end, Function<Object, T> mapper) {
        Set<Object> members = this.zRange(key, start, end);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<Object> zRange(String key, long start, long end) {
        try {
            return this.getOperations().opsForZSet().range((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> zRangeStringByScore(String key, double min, double max) {
        return this.zRangeByScoreFor(key, min, max, TO_STRING);
    }

    public Set<Double> zRangeDoubleByScore(String key, double min, double max) {
        return this.zRangeByScoreFor(key, min, max, TO_DOUBLE);
    }

    public Set<Long> zRangeLongByScore(String key, double min, double max) {
        return this.zRangeByScoreFor(key, min, max, TO_LONG);
    }

    public Set<Integer> zRangeIntegerByScore(String key, double min, double max) {
        return this.zRangeByScoreFor(key, min, max, TO_INTEGER);
    }

    public <T> Set<T> zRangeByScoreFor(String key, double min, double max, Class<T> clazz) {
        return this.zRangeByScoreFor(key, min, max, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> zRangeByScoreFor(String key, double min, double max, Function<Object, T> mapper) {
        Set<Object> members = this.zRangeByScore(key, min, max);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<Object> zRangeByScore(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().rangeByScore((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(String key, long start, long end) {
        try {
            return this.getOperations().opsForZSet().rangeWithScores((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().rangeByScoreWithScores((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> zRangeByLex(String key, RedisZSetCommands.Range range) {
        try {
            return this.getOperations().opsForZSet().rangeByLex((Object)key, range);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> zRangeByLex(String key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        try {
            return this.getOperations().opsForZSet().rangeByLex((Object)key, range, limit);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> zRevrange(String key, long start, long end) {
        try {
            return this.getOperations().opsForZSet().reverseRange((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> zRevrangeString(String key, long start, long end) {
        return this.zRevrangeFor(key, start, end, TO_STRING);
    }

    public Set<Double> zRevrangeDouble(String key, long start, long end) {
        return this.zRevrangeFor(key, start, end, TO_DOUBLE);
    }

    public Set<Long> zRevrangeLong(String key, long start, long end) {
        return this.zRevrangeFor(key, start, end, TO_LONG);
    }

    public Set<Integer> zRevrangeInteger(String key, long start, long end) {
        return this.zRevrangeFor(key, start, end, TO_INTEGER);
    }

    public <T> Set<T> zRevrangeFor(String key, long start, long end, Class<T> clazz) {
        return this.zRevrangeFor(key, start, end, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> zRevrangeFor(String key, long start, long end, Function<Object, T> mapper) {
        Set<Object> members = this.zRevrange(key, start, end);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRevrangeWithScores(String key, long start, long end) {
        try {
            return this.getOperations().opsForZSet().reverseRangeWithScores((Object)key, start, end);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<Object> zRevrangeByScore(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().reverseRangeByScore((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Set<String> zRevrangeStringByScore(String key, double min, double max) {
        return this.zRevrangeForByScore(key, min, max, TO_STRING);
    }

    public Set<Double> zRevrangeDoubleByScore(String key, double min, double max) {
        return this.zRevrangeForByScore(key, min, max, TO_DOUBLE);
    }

    public Set<Long> zRevrangeLongByScore(String key, double min, double max) {
        return this.zRevrangeForByScore(key, min, max, TO_LONG);
    }

    public Set<Integer> zRevrangeIntegerByScore(String key, double min, double max) {
        return this.zRevrangeForByScore(key, min, max, TO_INTEGER);
    }

    public <T> Set<T> zRevrangeForByScore(String key, double min, double max, Class<T> clazz) {
        return this.zRevrangeForByScore(key, min, max, (Object member) -> clazz.cast(member));
    }

    public <T> Set<T> zRevrangeForByScore(String key, double min, double max, Function<Object, T> mapper) {
        Set<Object> members = this.zRevrangeByScore(key, min, max);
        if (Objects.nonNull(members)) {
            return members.stream().map(mapper).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return null;
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRevrangeByScoreWithScores(String key, double min, double max) {
        try {
            return this.getOperations().opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zRevRank(String key, Object value) {
        try {
            return this.getOperations().opsForZSet().reverseRank((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void zScan(String bigZsetKey, Consumer<RedisZSetCommands.Tuple> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).build();
        this.zScan(bigZsetKey, options, consumer);
    }

    public void zScan(String bigZsetKey, String pattern, Consumer<RedisZSetCommands.Tuple> consumer) {
        ScanOptions options = ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build();
        this.zScan(bigZsetKey, options, consumer);
    }

    public void zScan(String bigZsetKey, ScanOptions options, Consumer<RedisZSetCommands.Tuple> consumer) {
        this.getOperations().execute(redisConnection -> {
            try (Cursor cursor = redisConnection.zScan(this.rawKey(bigZsetKey), options);){
                cursor.forEachRemaining(consumer);
                Object var7_8 = null;
                return var7_8;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new RedisOperationException(e.getMessage());
            }
        });
    }

    public Double zScore(String key, Object value, double defaultVal) {
        Double rtVal = this.zScore(key, value);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Double zScore(String key, Object value) {
        try {
            return this.getOperations().opsForZSet().score((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zUnionAndStore(String key, String otherKey, String destKey) {
        try {
            return this.getOperations().opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zUnionAndStore(String key, Collection<String> keys, String destKey) {
        try {
            return this.getOperations().opsForZSet().unionAndStore((Object)key, keys, (Object)destKey);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zUnionAndStore(String key, Collection<String> keys, String destKey, RedisZSetCommands.Aggregate aggregate) {
        try {
            return this.getOperations().opsForZSet().unionAndStore((Object)key, keys, (Object)destKey, aggregate);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long zUnionAndStore(String key, Collection<String> keys, String destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        try {
            return this.getOperations().opsForZSet().unionAndStore((Object)key, keys, (Object)destKey, aggregate, weights);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long pfAdd(String key, Object ... values) {
        try {
            return this.getOperations().opsForHyperLogLog().add((Object)key, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean pfDel(String key) {
        try {
            this.getOperations().opsForHyperLogLog().delete((Object)key);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long pfCount(String ... keys) {
        try {
            return this.getOperations().opsForHyperLogLog().size((Object[])keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long pfMerge(String destination, String ... sourceKeys) {
        try {
            return this.getOperations().opsForHyperLogLog().union((Object)destination, (Object[])sourceKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean setBit(String key, long offset, boolean value) {
        try {
            return this.getOperations().opsForValue().setBit((Object)key, offset, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Boolean getBit(String key, long offset) {
        try {
            return this.getOperations().opsForValue().getBit((Object)key, offset);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Integer append(String key, String value) {
        try {
            return this.getOperations().opsForValue().append((Object)key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void sendMessage(String channel, String message) {
        try {
            this.getOperations().convertAndSend(channel, (Object)message);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean tryBlockLock(String lockKey, int seconds) {
        try {
            return (Boolean)this.redisTemplate.execute(redisConnection -> {
                long expireAt = redisConnection.time() + (long)(seconds * 1000) + 1L;
                Boolean acquire = redisConnection.setNX(this.rawKey(lockKey), String.valueOf(expireAt).getBytes());
                if (acquire.booleanValue()) {
                    return true;
                }
                redisConnection.bRPop(seconds, (byte[][])new byte[][]{this.rawKey(lockKey + ":list")});
                return false;
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return false;
        }
    }

    public boolean unBlockLock(String lockKey, String requestId) {
        try {
            return (Boolean)this.redisTemplate.execute(redisConnection -> {
                redisConnection.del((byte[][])new byte[][]{this.rawKey(lockKey)});
                byte[] rawKey = this.rawKey(lockKey + ":list");
                byte[] rawValue = this.rawValue(requestId);
                redisConnection.rPush(rawKey, (byte[][])new byte[][]{rawValue});
                return true;
            }, true);
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean tryLock(String lockKey, Duration timeout) {
        return this.tryLock(lockKey, timeout.toMillis());
    }

    public boolean tryLock(String lockKey, long expireMillis) {
        try {
            return (Boolean)this.redisTemplate.execute(redisConnection -> {
                long expireTime;
                long expireAt;
                byte[] serLockKey = this.rawString(lockKey);
                Boolean acquire = redisConnection.setNX(serLockKey, String.valueOf(expireAt = redisConnection.time() + expireMillis + 1L).getBytes());
                if (acquire.booleanValue()) {
                    return true;
                }
                byte[] bytes = redisConnection.get(serLockKey);
                if (Objects.nonNull(bytes) && bytes.length > 0 && (expireTime = Long.parseLong(new String(bytes))) < redisConnection.time()) {
                    byte[] set = redisConnection.getSet(serLockKey, String.valueOf(redisConnection.time() + expireMillis + 1L).getBytes());
                    return Long.parseLong(new String(set)) < redisConnection.time();
                }
                return false;
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return false;
        }
    }

    public boolean unlock(String lockKey) {
        try {
            return this.getOperations().delete((Object)lockKey);
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            throw new RedisOperationException(e.getMessage());
        }
    }

    public boolean tryLock(String lockKey, String requestId, Duration timeout, int retryTimes, long retryInterval) {
        return this.tryLock(lockKey, requestId, timeout.toMillis(), retryTimes, retryInterval);
    }

    public boolean tryLock(String lockKey, String requestId, long expire, int retryTimes, long retryInterval) {
        try {
            return (Boolean)this.redisTemplate.execute(redisConnection -> {
                Long result = this.executeLuaScript(LOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId, expire);
                if (LOCK_SUCCESS.equals(result)) {
                    log.info("locked... redisK = {}", (Object)lockKey);
                    return true;
                }
                int count = 0;
                while (count < retryTimes) {
                    try {
                        Thread.sleep(retryInterval);
                        result = this.executeLuaScript(LOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId, expire);
                        if (LOCK_SUCCESS.equals(result)) {
                            log.info("locked... redisK = {}", (Object)lockKey);
                            return true;
                        }
                        log.warn("{} times try to acquire lock", (Object)(count + 1));
                        ++count;
                    }
                    catch (Exception e) {
                        log.error("acquire redis occurred an exception", (Throwable)e);
                    }
                }
                log.info("fail to acquire lock {}", (Object)lockKey);
                return false;
            });
        }
        catch (Exception e) {
            log.error("acquire redis occurred an exception", (Throwable)e);
            return false;
        }
    }

    public boolean unlock(String lockKey, String requestId) {
        log.info("unlock... redisK = {}", (Object)lockKey);
        try {
            Long result = this.executeLuaScript(UNLOCK_LUA_SCRIPT, Collections.singletonList(lockKey), requestId);
            if (LOCK_SUCCESS.equals(result)) {
                log.info("release lock success. redisK = {}", (Object)lockKey);
                return true;
            }
            if (LOCK_EXPIRED.equals(result)) {
                log.warn("release lock exception, key has expired or released");
            } else {
                log.error("release lock failed");
            }
        }
        catch (Exception e) {
            log.error("release lock occurred an exception", (Throwable)e);
            throw new RedisOperationException(e.getMessage());
        }
        return false;
    }

    public List<Object> executePipelined(RedisCallback<?> action) {
        try {
            return this.getOperations().executePipelined(action);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public List<Object> executePipelined(RedisCallback<?> action, RedisSerializer<?> resultSerializer) {
        try {
            return this.getOperations().executePipelined(action, resultSerializer);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaIncr(String key, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(INCR_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double luaIncr(String key, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(INCR_BYFLOAT_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaDecr(String key, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(DECR_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaDiv(String key, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(DIV_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double luaDecr(String key, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return this.executeLuaScript(DECR_BYFLOAT_SCRIPT, Lists.newArrayList((Object[])new String[]{key}), delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaHincr(String key, String hashKey, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return (Long)this.getOperations().execute(HINCR_SCRIPT, this.hashValueSerializer(), this.hashValueSerializer(), (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), new Object[]{delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double luaHincr(String key, String hashKey, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return (Double)this.getOperations().execute(HINCR_BYFLOAT_SCRIPT, this.hashValueSerializer(), this.hashValueSerializer(), (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), new Object[]{delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaHdecr(String key, String hashKey, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return (Long)this.getOperations().execute(HDECR_SCRIPT, this.hashValueSerializer(), this.hashValueSerializer(), (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), new Object[]{delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Double luaHdecr(String key, String hashKey, double delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return (Double)this.getOperations().execute(HDECR_BYFLOAT_SCRIPT, this.hashValueSerializer(), this.hashValueSerializer(), (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), new Object[]{delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long luaHdiv(String key, String hashKey, long delta) {
        Assert.hasLength((String)key, (String)"key must not be empty");
        try {
            return (Long)this.getOperations().execute(HDIV_SCRIPT, this.hashValueSerializer(), this.hashValueSerializer(), (List)Lists.newArrayList((Object[])new String[]{key, hashKey}), new Object[]{delta});
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <R> R executeLuaScript(String luaScript, Class<R> returnType, List<String> keys, Object ... values) {
        try {
            RedisScript redisScript = RedisScript.of((String)luaScript, returnType);
            return (R)this.getOperations().execute(redisScript, keys, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <R> R executeLuaScript(RedisScript<R> luaScript, List<String> keys, Object ... values) {
        try {
            return (R)this.getOperations().execute(luaScript, keys, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public <R> R executeLuaScript(Resource luaScript, Class<R> returnType, List<String> keys, Object ... values) {
        try {
            RedisScript redisScript = RedisScript.of((Resource)luaScript, returnType);
            return (R)this.getOperations().execute(redisScript, keys, values);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long timeNow() {
        try {
            return (Long)this.getOperations().execute(redisConnection -> redisConnection.time());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long period(long expiration) {
        try {
            return (Long)this.getOperations().execute(redisConnection -> expiration - redisConnection.time());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long dbSize() {
        try {
            return (Long)this.getOperations().execute(redisConnection -> redisConnection.dbSize());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public Long lastSave() {
        try {
            return (Long)this.getOperations().execute(redisConnection -> redisConnection.lastSave());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void bgReWriteAof() {
        try {
            this.getOperations().execute(redisConnection -> {
                redisConnection.bgReWriteAof();
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void bgSave() {
        try {
            this.getOperations().execute(redisConnection -> {
                redisConnection.bgSave();
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void save() {
        try {
            this.getOperations().execute(redisConnection -> {
                redisConnection.save();
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void flushDb() {
        try {
            this.getOperations().execute(redisConnection -> {
                redisConnection.flushDb();
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }

    public void flushAll() {
        try {
            this.getOperations().execute(redisConnection -> {
                redisConnection.flushAll();
                return null;
            });
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new RedisOperationException(e.getMessage());
        }
    }
}

