/*
 * Decompiled with CFR 0.152.
 */
package redistpl.plus.spring.boot;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.redis.executor")
public class RedisExecutionProperties {
    private final Pool listener = new Pool();
    private final Pool subscription = new Pool();

    public Pool getListener() {
        return this.listener;
    }

    public Pool getSubscription() {
        return this.subscription;
    }

    public static class Pool {
        private int coreSize = 1;
        private int maxSize = Runtime.getRuntime().availableProcessors();
        private int queueCapacity = Integer.MAX_VALUE;
        private Duration keepAlive = Duration.ofSeconds(60L);
        private boolean allowCoreThreadTimeOut = false;
        private String threadNamePrefix = "redis-execution-";

        public void setCoreSize(int coreSize) {
            this.coreSize = coreSize;
        }

        public int getCoreSize() {
            return this.coreSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
        }

        public boolean isAllowCoreThreadTimeOut() {
            return this.allowCoreThreadTimeOut;
        }

        public void setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        public String getThreadNamePrefix() {
            return this.threadNamePrefix;
        }
    }
}

