/*
 * Decompiled with CFR 0.152.
 */
package redistpl.plus.spring.boot;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisOperationTemplate;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, ReactiveRedisTemplate.class, Flux.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@AutoConfigureBefore(value={RedisReactiveAutoConfiguration.class})
public class RedisReactiveCachingConfiguration {
    @Bean(name={"reactiveRedisTemplate"})
    public ReactiveRedisTemplate<String, Object> reactiveRedisTemplate(ReactiveRedisConnectionFactory reactiveRedisConnectionFactory, Jackson2JsonRedisSerializer<Object> jackson2JsonRedisSerializer) {
        RedisSerializationContext.SerializationPair keySerializationPair = RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new RedisSerializer<String>(){

            public byte[] serialize(String t) throws SerializationException {
                return StringRedisSerializer.UTF_8.serialize(t.toString());
            }

            public String deserialize(byte[] bytes) throws SerializationException {
                return StringRedisSerializer.UTF_8.deserialize(bytes);
            }
        });
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key(keySerializationPair).value(jackson2JsonRedisSerializer).hashKey(keySerializationPair).hashValue(jackson2JsonRedisSerializer).build();
        return new ReactiveRedisTemplate(reactiveRedisConnectionFactory, serializationContext);
    }

    @Bean
    public ReactiveRedisOperationTemplate reactiveRedisOperationTemplate(ReactiveRedisTemplate<String, Object> reactiveRedisTemplate) {
        return new ReactiveRedisOperationTemplate(reactiveRedisTemplate);
    }
}

