package com.github.houbb.chars.scan.util;

import java.util.HashSet;
import java.util.Set;

/**
 * 中文名称优化
 *
 * 姓名 = 姓氏+名称
 *
 * 名没有限制，所以此处只判断姓氏
 *
 * @since 1.1.0
 */
public class InnerChineseNameUtil {

    /**
     * 国内的3k+姓氏
     */
    private static final String FAMILY_NAMES = "王李张刘陈杨黄吴赵周徐孙马朱胡林郭何高罗郑梁谢宋唐许邓冯韩曹曾彭肖蔡潘田董袁于余蒋叶杜苏魏程吕丁沈任姚卢钟姜崔谭廖范汪陆金石戴贾韦夏邱方侯邹熊孟秦白毛江闫薛尹付段雷黎史龙钱贺陶顾龚郝邵万严洪赖武傅莫孔汤向常温康施文牛樊葛邢安齐易乔伍庞颜倪庄聂章鲁岳翟申殷詹欧耿关覃兰焦俞左柳甘祝包代宁符阮尚舒纪柯梅童毕凌单季成霍苗裴涂谷曲盛冉翁蓝骆路游靳辛管柴蒙鲍华喻祁房蒲滕萧屈饶解牟艾尤时阳阎穆应农司古吉卓车简连缪项麦褚窦娄戚岑党宫景卜费冷晏卫席柏米隋宗桂瞿全苟楼闵佟臧边卞姬邬和师仇栾丘刁沙商寇荣巫郎桑丛甄敖虞仲池巩明佘查麻苑迟邝封官谈鞠匡惠荆乐冀胥郁南班储芦原栗燕楚鄢扬劳谌奚皮蔺粟冼盘满闻厉伊候仝区郜海阚花权强帅屠朴盖练廉禹井巴漆祖丰支卿国狄平计索宣晋相占初门云容敬来扈晁都芮普阙戈浦伏薄鹿邸雍辜阿羊母亓裘修邰杭赫况那宿鲜逯印隆习茹诸战慕危玉银亢公嵇豆哈湛宾勾茅戎利於呼居干揭但尉斯元束檀衣信阴展昝智幸奉植富衡昌巢郦逄寿由竺贝步东鄂弓过钮濮水蔚郗荀贲别邴才操畅从达凡凤扶贡户滑郏矫经靖琚巨蒯旷历励伦雒茆糜宓木綦谯渠山生侍眭腾铁宛隗沃乌毋咸忻续延言尧英鱼庾招种訾宝保暴闭布藏承福果黑怀宦回汲籍蹇将可里粱冒么年泮郄青秋释双税潭天望位仵香刑轩玄郇要宇员哀爱昂熬傲奥把百摆拜邦北本碧薜伯博补部采彩菜仓苍曽茶产苌倡唱钞超朝潮沉晨呈赤敕崇瘳丑除楮揣传春淳啜慈次爨催翠寸笪答丹旦淡刀道德迪底第佃定冬懂钭堵端敦顿多朵恩尔佴法番藩芳飞斐风酆逢俸苻洑浮甫府复淦刚皋杲格庚恭拱供缑菇贯冠光广归贵呙虢还寒汉行蒿好昊浩禾合河荷恒弘红宏鸿后厚忽湖虎化淮槐环桓皇辉会火伙基稽及戢记继暨加佳家嘉荚甲菅翦见建剑降娇徼缴教接节杰颉介京静酒咎菊句具俱剧矍军君俊卡开凯勘堪考科克空库郐奎蒉阔喇稂朗勒蕾类梨礼理力立丽莲良疗寥列吝泠零另令留庐炉禄洛闾侣律绿买曼卯枚美梦弥弭秘密妙闽敏名谬磨墨默沐牧睦纳娜乃铙能尼念乜甯鸥偶攀朋蓬澎骈溥柒其奇祈耆千乾潜羌钦琴勤清庆求璩却荛绕仁日融如汝瑞闰润若撒萨赛伞森厦闪陕善赏上韶卲绍厍莘神甚慎升绳圣诗拾矢士世是守首殳书疏树顺思松送素睢随所锁塔台太泰郯塘桃淘藤提遆帖通同徒脱陀庹拓完旺威巍伟未问瓮无吾兀西希息溪袭洗喜霞仙先贤线湘象宵箫潇晓孝校星兴雄吁须顼绪禤学雪寻牙雅焉岩彦艳宴洋仰养样幺侥药冶野业依仪夷怡宜乙蚁弋义奕羿益裔翼盈营永勇犹油友有迂羽遇誉毓源远院月悦越允运恽载宰迮增甑粘斩长仉掌钊兆肇折真阵镇征正政只职郅治中忠衷皱邾珠竹主壮禚资子紫自字纵俎佐";

    private static final Set<Character> FAMILY_NAME_SET;

    static {
        FAMILY_NAME_SET = new HashSet<Character>(FAMILY_NAMES.length());
        for(int i = 0; i < FAMILY_NAMES.length(); i++) {
            FAMILY_NAME_SET.add(FAMILY_NAMES.charAt(i));
        }
    }

    /**
     * 是否为姓氏
     *
     * O（1）
     * @param c 字符
     * @return 结果
     * @since 1.1.0
     */
    public static boolean isFamilyName(char c) {
        return FAMILY_NAME_SET.contains(c);
    }

}
