/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.hash;

import com.github.houbb.chars.scan.api.ICharsReplaceHash;
import com.github.houbb.chars.scan.constant.CharsScanReplaceHashTypeEnum;
import com.github.houbb.chars.scan.exception.CharsScanException;
import com.github.houbb.chars.scan.support.hash.CharsReplaceHashMd5;
import com.github.houbb.chars.scan.support.hash.CharsReplaceHashNone;

public final class CharsReplaceHashes {
    private static final ICharsReplaceHash MD5 = new CharsReplaceHashMd5();
    private static final ICharsReplaceHash NONE = new CharsReplaceHashNone();

    public static ICharsReplaceHash md5() {
        return MD5;
    }

    public static ICharsReplaceHash none() {
        return NONE;
    }

    public static ICharsReplaceHash defaults() {
        return MD5;
    }

    public static ICharsReplaceHash newInstance(String idCode) {
        String lowerCode = idCode.toLowerCase();
        if (CharsScanReplaceHashTypeEnum.MD5.getId().equals(lowerCode)) {
            return CharsReplaceHashes.md5();
        }
        if (CharsScanReplaceHashTypeEnum.NONE.getId().equals(lowerCode)) {
            return CharsReplaceHashes.none();
        }
        throw new CharsScanException(idCode + " match hash not found!");
    }
}

