/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.replace;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.replace.AbstractCharReplace;
import com.github.houbb.heaven.util.util.ArrayUtil;

public class EmailCharsReplace
extends AbstractCharReplace {
    @Override
    public String getScanType() {
        return CharsScanTypeEnum.EMAIL.getScanType();
    }

    @Override
    public void doReplace(StringBuilder stringBuilder, char[] chars, CharsScanMatchItem charsScanMatchItem, CharsScanContext context) {
        int lastAtIx = ArrayUtil.lastIndexOf((char[])chars, (char)'@', (int)charsScanMatchItem.getStartIndex(), (int)charsScanMatchItem.getEndIndex());
        int prefixLen = lastAtIx - charsScanMatchItem.getStartIndex();
        int maskStartIx = charsScanMatchItem.getStartIndex() + Math.min(4, prefixLen);
        int maskEndIx = lastAtIx - 1;
        super.replaceByIndex(stringBuilder, chars, charsScanMatchItem, context, maskStartIx, maskEndIx);
    }
}

