/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.replace;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.replace.AbstractCharReplace;

public class EmailCharsReplaceByIx
extends AbstractCharReplace {
    @Override
    public String getScanType() {
        return CharsScanTypeEnum.EMAIL.getScanType();
    }

    @Override
    public void doReplace(StringBuilder stringBuilder, char[] chars, CharsScanMatchItem charsScanMatchItem, CharsScanContext context) {
        int plainLenBeforeAt = 0;
        int startIx = charsScanMatchItem.getStartIndex();
        int endIx = charsScanMatchItem.getEndIndex();
        boolean beforeAtFlag = true;
        for (int i = startIx; i <= endIx; ++i) {
            char c = chars[i];
            if (c == '@') {
                beforeAtFlag = false;
            }
            if (beforeAtFlag) {
                if (++plainLenBeforeAt <= 4) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append('*');
                continue;
            }
            stringBuilder.append(c);
        }
    }
}

