/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.api.CharsScanMatchItem;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractConditionCharScan;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.List;

public abstract class AbstractExpandConditionCharScan
extends AbstractConditionCharScan {
    @Override
    @Deprecated
    protected boolean isCharMatchCondition(int i, char c, char[] chars) {
        return false;
    }

    protected CharsScanTypeEnum isExpandStartCondition(int i, char c, char[] chars, CharsScanContext context) {
        int lastIx;
        List<CharsScanMatchItem> oldList = super.getMatchList();
        if (CollectionUtil.isNotEmpty(oldList) && i <= (lastIx = oldList.get(oldList.size() - 1).getEndIndex())) {
            return null;
        }
        return this.isExpandStartCharCondition(i, c, chars, context);
    }

    protected abstract CharsScanTypeEnum isExpandStartCharCondition(int var1, char var2, char[] var3, CharsScanContext var4);

    protected boolean isLeftExpandMatchCondition(int leftIx, char leftChar, char[] chars, CharsScanContext context) {
        return false;
    }

    protected boolean isLeftBufferMatch(int middleIx, int startIx, char[] chars, CharsScanContext context) {
        return false;
    }

    protected boolean isRightExpandMatchCondition(int rightIx, char rightChar, char[] chars, CharsScanContext context) {
        return false;
    }

    protected boolean isRightBufferMatch(int middleIx, int startIx, int endIx, char[] chars, CharsScanContext context) {
        return false;
    }

    protected int loopHandleLeft(int i, char[] chars, CharsScanContext context, CharsScanTypeEnum scanTypeEnum) {
        char cc;
        StringBuilder buffer = super.getBuffer();
        int leftIx = i - 1;
        for (leftIx = i - 1; leftIx >= 0 && this.isLeftExpandMatchCondition(leftIx, cc = chars[leftIx], chars, context); --leftIx) {
            buffer.append(cc);
        }
        boolean isMatchPrefix = super.isPrefixMatch(i, chars[i], chars, context);
        if (!isMatchPrefix) {
            return -1;
        }
        int actualLeftIx = leftIx + 1;
        if (!this.isLeftBufferMatch(i, actualLeftIx, chars, context)) {
            return -1;
        }
        this.clearBuffer();
        return actualLeftIx;
    }

    protected int loopHandleRight(int leftIx, int i, char[] chars, CharsScanContext context, CharsScanTypeEnum scanTypeEnum) {
        char cc;
        StringBuilder buffer = super.getBuffer();
        int rightIx = i + 1;
        for (rightIx = i + 1; rightIx < chars.length && this.isRightExpandMatchCondition(rightIx, cc = chars[rightIx], chars, context); ++rightIx) {
            buffer.append(cc);
        }
        int actualRightIx = rightIx - 1;
        if (!this.isRightBufferMatch(i, leftIx, actualRightIx, chars, context)) {
            return -1;
        }
        return actualRightIx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan(int i, char c, char[] chars, CharsScanContext context) {
        CharsScanTypeEnum scanTypeEnum = this.isExpandStartCondition(i, c, chars, context);
        if (scanTypeEnum != null) {
            try {
                this.clearBuffer();
                int leftIx = this.loopHandleLeft(i, chars, context, scanTypeEnum);
                if (leftIx < 0) {
                    return;
                }
                int rightIx = this.loopHandleRight(leftIx, i, chars, context, scanTypeEnum);
                if (rightIx < 0) {
                    return;
                }
                this.addExpandScanMatchItem(i, chars, context, leftIx, rightIx, scanTypeEnum);
            }
            finally {
                this.clearBuffer();
            }
        }
    }

    protected void addExpandScanMatchItem(int middleIx, char[] chars, CharsScanContext context, int leftIx, int rightIx, CharsScanTypeEnum scanTypeEnum) {
        CharsScanMatchItem charsScanMatchItem = new CharsScanMatchItem();
        charsScanMatchItem.setStartIndex(leftIx);
        charsScanMatchItem.setEndIndex(rightIx);
        charsScanMatchItem.setScanType(scanTypeEnum.getScanType());
        charsScanMatchItem.setPriority(scanTypeEnum.getPriority());
        super.getMatchList().add(charsScanMatchItem);
    }
}

