/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan;

import com.github.houbb.chars.scan.api.CharsScanContext;
import com.github.houbb.chars.scan.constant.CharsScanTypeEnum;
import com.github.houbb.chars.scan.support.scan.AbstractExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.AddressExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.ChineseNameExpandConditionCharScan;
import com.github.houbb.chars.scan.support.scan.EmailExpandConditionCharScan;
import com.github.houbb.chars.scan.util.InnerCharUtil;
import com.github.houbb.chars.scan.util.InnerChineseNameUtil;
import com.github.houbb.heaven.util.common.ArgUtil;
import java.util.Arrays;
import java.util.Collection;

public class MergeExpandConditionCharScan
extends AbstractExpandConditionCharScan {
    private final Collection<String> scanTypeCollect;

    public MergeExpandConditionCharScan() {
        this(Arrays.asList(CharsScanTypeEnum.EMAIL.getScanType(), CharsScanTypeEnum.CHINESE_NAME.getScanType(), CharsScanTypeEnum.ADDRESS.getScanType()));
    }

    public MergeExpandConditionCharScan(Collection<String> scanTypeEnums) {
        ArgUtil.notNull(scanTypeEnums, (String)"scanTypeEnums");
        this.scanTypeCollect = scanTypeEnums;
    }

    @Override
    public int getPriority() {
        return CharsScanTypeEnum.MERGE_EXPAND.getPriority();
    }

    @Override
    public String getScanType() {
        return CharsScanTypeEnum.MERGE_EXPAND.getScanType();
    }

    @Override
    protected CharsScanTypeEnum isExpandStartCharCondition(int i, char c, char[] chars, CharsScanContext context) {
        if (this.scanTypeCollect.contains(CharsScanTypeEnum.EMAIL.getScanType()) && c == '@') {
            return CharsScanTypeEnum.EMAIL;
        }
        if (this.scanTypeCollect.contains(CharsScanTypeEnum.ADDRESS.getScanType()) && InnerCharUtil.isAddressKeyword(c)) {
            return CharsScanTypeEnum.ADDRESS;
        }
        if (this.scanTypeCollect.contains(CharsScanTypeEnum.CHINESE_NAME.getScanType()) && InnerChineseNameUtil.isFamilyName(c)) {
            return CharsScanTypeEnum.CHINESE_NAME;
        }
        return null;
    }

    @Override
    protected int loopHandleLeft(int i, char[] chars, CharsScanContext context, CharsScanTypeEnum scanTypeEnum) {
        EmailExpandConditionCharScan emailExpandConditionCharScan = new EmailExpandConditionCharScan();
        AddressExpandConditionCharScan addressExpandConditionCharScan = new AddressExpandConditionCharScan();
        ChineseNameExpandConditionCharScan chineseNameExpandConditionCharScan = new ChineseNameExpandConditionCharScan();
        if (CharsScanTypeEnum.EMAIL.equals(scanTypeEnum)) {
            return emailExpandConditionCharScan.loopHandleLeft(i, chars, context, scanTypeEnum);
        }
        if (CharsScanTypeEnum.ADDRESS.equals(scanTypeEnum)) {
            return addressExpandConditionCharScan.loopHandleLeft(i, chars, context, scanTypeEnum);
        }
        if (CharsScanTypeEnum.CHINESE_NAME.equals(scanTypeEnum)) {
            return chineseNameExpandConditionCharScan.loopHandleLeft(i, chars, context, scanTypeEnum);
        }
        return -1;
    }

    @Override
    protected int loopHandleRight(int leftIx, int i, char[] chars, CharsScanContext context, CharsScanTypeEnum scanTypeEnum) {
        EmailExpandConditionCharScan emailExpandConditionCharScan = new EmailExpandConditionCharScan();
        AddressExpandConditionCharScan addressExpandConditionCharScan = new AddressExpandConditionCharScan();
        ChineseNameExpandConditionCharScan chineseNameExpandConditionCharScan = new ChineseNameExpandConditionCharScan();
        if (CharsScanTypeEnum.EMAIL.equals(scanTypeEnum)) {
            return ((AbstractExpandConditionCharScan)emailExpandConditionCharScan).loopHandleRight(leftIx, i, chars, context, scanTypeEnum);
        }
        if (CharsScanTypeEnum.ADDRESS.equals(scanTypeEnum)) {
            return addressExpandConditionCharScan.loopHandleRight(leftIx, i, chars, context, scanTypeEnum);
        }
        if (CharsScanTypeEnum.CHINESE_NAME.equals(scanTypeEnum)) {
            return chineseNameExpandConditionCharScan.loopHandleRight(leftIx, i, chars, context, scanTypeEnum);
        }
        return -1;
    }
}

