/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.support.scan.factory;

import com.github.houbb.chars.scan.api.ICharsScan;
import com.github.houbb.chars.scan.api.ICharsScanFactory;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class CharsScanFactoryThreadLocal {
    private static final ThreadLocal<ConcurrentHashMap<String, List<ICharsScan>>> THREAD_LOCAL = new ThreadLocal();

    public static List<ICharsScan> getAndCache(ICharsScanFactory charScanFactory) {
        String key;
        List<String> scanTypeCodeList = charScanFactory.scanTypeList();
        ConcurrentHashMap<String, List<ICharsScan>> scanConcurrentHashMap = THREAD_LOCAL.get();
        List<ICharsScan> scanList = scanConcurrentHashMap.get(key = scanTypeCodeList.toString());
        if (scanList == null) {
            scanList = charScanFactory.allCharScanList();
            scanConcurrentHashMap.putIfAbsent(key, scanList);
        }
        return scanList;
    }

    public static void clearAll(ICharsScanFactory charScanFactory) {
        List<ICharsScan> scanCollection = CharsScanFactoryThreadLocal.getAndCache(charScanFactory);
        if (CollectionUtil.isNotEmpty(scanCollection)) {
            for (ICharsScan charsScan : scanCollection) {
                charsScan.clear();
            }
        }
    }

    static {
        THREAD_LOCAL.set(new ConcurrentHashMap());
    }
}

