/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chars.scan.util;

import com.github.houbb.chars.scan.util.InnerCharUtil;

public final class InnerBankLuhnHelper {
    private InnerBankLuhnHelper() {
    }

    public static boolean isValidBankNo(StringBuilder cardNo) {
        int sum = InnerBankLuhnHelper.calcSum(cardNo, 1);
        return sum % 10 == 0;
    }

    private static int calcSum(StringBuilder cardNo, int count) {
        int length = cardNo.length();
        int sum = 0;
        for (int i = length; i > 0; --i) {
            int num = InnerCharUtil.getCharInt(cardNo.charAt(i - 1));
            if (count % 2 != 0) {
                sum += num;
            } else {
                int doubleNum = num * 2;
                if (doubleNum < 10) {
                    sum += doubleNum;
                } else {
                    int doubleNumFirst = doubleNum / 10;
                    int doubleNumSecond = doubleNum % 10;
                    sum += doubleNumFirst;
                    sum += doubleNumSecond;
                }
            }
            ++count;
        }
        return sum;
    }
}

