/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.consistent.hashing.bs;

import com.github.houbb.consistent.hashing.api.IConsistentHashing;
import com.github.houbb.consistent.hashing.api.impl.ConsistentHashing;
import com.github.houbb.hash.api.IHashCode;
import com.github.houbb.hash.core.code.HasheCodes;
import com.github.houbb.heaven.util.common.ArgUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.util.Collection;
import java.util.HashSet;

public final class ConsistentHashingBs<T> {
    private int virtualNum = 16;
    private IHashCode hashCode = HasheCodes.jdk();
    private Collection<T> nodes = new HashSet<T>();

    public static <T> ConsistentHashingBs<T> newInstance() {
        return new ConsistentHashingBs<T>();
    }

    public ConsistentHashingBs<T> virtualNum(int virtualNum) {
        ArgUtil.gt((String)"virtualNum", (long)virtualNum, (long)0L);
        this.virtualNum = virtualNum;
        return this;
    }

    public ConsistentHashingBs<T> hashCode(IHashCode hashCode) {
        ArgUtil.notNull((Object)hashCode, (String)"hashCode");
        this.hashCode = hashCode;
        return this;
    }

    public ConsistentHashingBs<T> nodes(Collection<T> nodes) {
        ArgUtil.notEmpty(nodes, (String)"nodes");
        this.nodes = nodes;
        return this;
    }

    public IConsistentHashing<T> build() {
        ConsistentHashing<T> hashing = new ConsistentHashing<T>(this.virtualNum, this.hashCode);
        if (CollectionUtil.isNotEmpty(this.nodes)) {
            for (T node : this.nodes) {
                hashing.add(node);
            }
        }
        return hashing;
    }
}

