/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.bs;

import com.github.houbb.csv.support.context.DefaultReadContext;
import com.github.houbb.csv.support.csv.DefaultCsv;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.support.sort.impl.NoSort;
import java.util.List;

public class CsvReadBs {
    private String charset = "UTF-8";
    private int startIndex = 1;
    private int endIndex = Integer.MAX_VALUE;
    private ISort sort = new NoSort();
    private String path;

    private CsvReadBs() {
    }

    public static CsvReadBs newInstance(String path) {
        CsvReadBs csvBs = new CsvReadBs();
        csvBs.path(path);
        return csvBs;
    }

    public CsvReadBs charset(String charset) {
        this.charset = charset;
        return this;
    }

    public CsvReadBs sort(ISort sort) {
        this.sort = sort;
        return this;
    }

    public CsvReadBs path(String path) {
        this.path = path;
        return this;
    }

    public CsvReadBs startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public CsvReadBs endIndex(int endIndex) {
        this.endIndex = endIndex;
        return this;
    }

    public <T> List<T> read(Class<T> tClass) {
        DefaultReadContext context = new DefaultReadContext();
        context.charset(this.charset).path(this.path).startIndex(this.startIndex).endIndex(this.endIndex).sort(this.sort).readClass(tClass);
        DefaultCsv csv = new DefaultCsv();
        return csv.read(context);
    }
}

