/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.bs;

import com.github.houbb.csv.support.context.DefaultWriteContext;
import com.github.houbb.csv.support.csv.DefaultCsv;
import com.github.houbb.heaven.support.sort.ISort;
import com.github.houbb.heaven.support.sort.impl.NoSort;
import java.util.List;

public class CsvWriteBs {
    private boolean writeHead = true;
    private boolean writeBom = true;
    private String charset = "UTF-8";
    private ISort sort = new NoSort();
    private String path;

    private CsvWriteBs() {
    }

    public static CsvWriteBs newInstance(String path) {
        CsvWriteBs csvBs = new CsvWriteBs();
        csvBs.path(path);
        return csvBs;
    }

    public CsvWriteBs writeHead(boolean writeHead) {
        this.writeHead = writeHead;
        return this;
    }

    public CsvWriteBs writeBom(boolean writeBom) {
        this.writeBom = writeBom;
        return this;
    }

    public CsvWriteBs charset(String charset) {
        this.charset = charset;
        return this;
    }

    public CsvWriteBs sort(ISort sort) {
        this.sort = sort;
        return this;
    }

    public CsvWriteBs path(String path) {
        this.path = path;
        return this;
    }

    public <T> void write(List<T> list) {
        DefaultWriteContext context = new DefaultWriteContext();
        context.charset(this.charset).list(list).writeHead(this.writeHead).writeBom(this.writeBom).path(this.path).sort(this.sort);
        DefaultCsv csv = new DefaultCsv();
        csv.write(context);
    }
}

