/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.write;

import com.github.houbb.csv.api.IWriteConverter;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.write.StringWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.ArrayWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.CollectionWriteConverter;
import com.github.houbb.csv.support.convert.write.collection.MapWriteConverter;
import com.github.houbb.csv.support.convert.write.entry.EntryWriteConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.csv.util.CsvInnerUtil;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.reflect.ClassTypeUtil;

public class CommonWriteConverter
implements IWriteConverter {
    @Override
    public String convert(SingleWriteContext context) {
        Object value = context.element();
        if (ObjectUtil.isNull((Object)value)) {
            return "";
        }
        Class<?> type = value.getClass();
        if (ClassTypeUtil.isArray(type)) {
            return ((ArrayWriteConverter)Instances.singletion(ArrayWriteConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isMap(type)) {
            return ((MapWriteConverter)Instances.singletion(MapWriteConverter.class)).convert(context);
        }
        if (ClassTypeUtil.isCollection(type)) {
            return ((CollectionWriteConverter)Instances.singletion(CollectionWriteConverter.class)).convert(context);
        }
        if (CsvFieldUtil.isEntryAble(context.field())) {
            String split = CsvInnerUtil.getNextSplit(context.split());
            SingleWriteContext singleWriteContext = new SingleWriteContext();
            singleWriteContext.sort(context.sort());
            singleWriteContext.element(context.value());
            singleWriteContext.split(split);
            return ((EntryWriteConverter)Instances.singletion(EntryWriteConverter.class)).convert(singleWriteContext);
        }
        return ((StringWriteConverter)Instances.singletion(StringWriteConverter.class)).convert(context);
    }
}

