/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.convert.write.entry;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.api.IWriteConverter;
import com.github.houbb.csv.constant.CsvOperateType;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.write.CommonWriteConverter;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.util.List;

@ThreadSafe
public class EntryWriteConverter
implements IWriteConverter {
    @Override
    public String convert(SingleWriteContext context) {
        Object value = context.element();
        if (ObjectUtil.isNull((Object)value)) {
            return "";
        }
        Class<?> clazz = value.getClass();
        List<FieldBean> fieldBeanList = CsvFieldUtil.getSortedFields(clazz, context.sort(), CsvOperateType.WRITE);
        if (CollectionUtil.isEmpty(fieldBeanList)) {
            return "";
        }
        return this.buildWriteLine(context, value, fieldBeanList);
    }

    private String buildWriteLine(SingleWriteContext context, Object t, List<FieldBean> fieldBeans) {
        if (ObjectUtil.isNull((Object)t)) {
            return "";
        }
        List stringList = Guavas.newArrayList((int)fieldBeans.size());
        IWriteConverter converter = (IWriteConverter)Instances.singletion(CommonWriteConverter.class);
        try {
            for (FieldBean bean : fieldBeans) {
                Optional csvOptional = bean.annotationOptByType(Csv.class);
                if (csvOptional.isPresent()) {
                    converter = ((Csv)csvOptional.get()).writeConverter().newInstance();
                }
                Object object = bean.field().get(t);
                SingleWriteContext entryContext = new SingleWriteContext();
                entryContext.value(object).field(bean.field()).element(t).sort(context.sort()).split(",");
                String string = converter.convert(entryContext);
                stringList.add(string);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
        return CollectionUtil.join((List)stringList, (String)context.split());
    }
}

