/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.csv.support.csv;

import com.github.houbb.csv.annotation.Csv;
import com.github.houbb.csv.api.ICsv;
import com.github.houbb.csv.api.IReadContext;
import com.github.houbb.csv.api.IWriteContext;
import com.github.houbb.csv.constant.CsvOperateType;
import com.github.houbb.csv.support.context.SingleReadContext;
import com.github.houbb.csv.support.context.SingleWriteContext;
import com.github.houbb.csv.support.convert.read.entry.EntryReadConverter;
import com.github.houbb.csv.support.convert.write.entry.EntryWriteConverter;
import com.github.houbb.csv.util.CsvBomUtil;
import com.github.houbb.csv.util.CsvFieldUtil;
import com.github.houbb.heaven.reflect.model.FieldBean;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.nio.PathUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.heaven.util.util.Optional;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DefaultCsv<T>
implements ICsv<T> {
    @Override
    public void write(IWriteContext<T> context) {
        List<T> writeList = context.list();
        if (CollectionUtil.isEmpty(writeList)) {
            return;
        }
        Optional firstOpt = CollectionUtil.firstNotNullElem(writeList);
        if (firstOpt.isNotPresent()) {
            return;
        }
        Object elem = firstOpt.get();
        List<FieldBean> fieldBeanList = CsvFieldUtil.getSortedFields(elem.getClass(), context.sort(), CsvOperateType.WRITE);
        if (CollectionUtil.isEmpty(fieldBeanList)) {
            return;
        }
        try {
            boolean needWriteHead;
            File file;
            Path path = Paths.get(context.path(), new String[0]);
            File parent = path.getParent().toFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!(file = path.toFile()).exists()) {
                file.createNewFile();
            }
            String charset = context.charset();
            byte[] bomBytes = CsvBomUtil.getBom(charset);
            boolean needWriteBoom = context.writeBom() && file.length() <= 0L;
            boolean bl = needWriteHead = context.writeHead() && file.length() <= (long)bomBytes.length;
            if (needWriteBoom) {
                Files.write(path, bomBytes, StandardOpenOption.APPEND);
            }
            int size = context.list().size() + 1;
            List list = Guavas.newArrayList((int)size);
            if (needWriteHead) {
                String headLine = this.buildWriteHead(fieldBeanList);
                list.add(headLine);
            }
            EntryWriteConverter entryWriteConverter = new EntryWriteConverter();
            SingleWriteContext singleWriteContext = new SingleWriteContext();
            singleWriteContext.sort(context.sort());
            for (T t : writeList) {
                singleWriteContext.element(t);
                singleWriteContext.split(",");
                String writeLine = entryWriteConverter.convert(singleWriteContext);
                if (StringUtil.isEmpty((String)writeLine)) continue;
                list.add(writeLine);
            }
            Files.write(path, (Iterable<? extends CharSequence>)list, Charset.forName(charset), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
    }

    private String buildWriteHead(List<FieldBean> fieldBeanList) {
        List headList = Guavas.newArrayList((int)fieldBeanList.size());
        for (FieldBean bean : fieldBeanList) {
            String label;
            String name = bean.name();
            Optional csvOptional = bean.annotationOptByType(Csv.class);
            if (csvOptional.isPresent() && StringUtil.isNotEmpty((String)(label = ((Csv)csvOptional.get()).label()))) {
                name = label;
            }
            headList.add(name);
        }
        return StringUtil.join((Collection)headList, (String)",");
    }

    @Override
    public List<T> read(IReadContext<T> context) {
        Map<Integer, FieldBean> readMapping = CsvFieldUtil.getReadMapping(context.readClass(), context.sort());
        if (MapUtil.isEmpty(readMapping)) {
            return Collections.emptyList();
        }
        List readableLines = PathUtil.readAllLines((String)context.path(), (String)context.charset(), (int)context.startIndex(), (int)context.endIndex());
        if (CollectionUtil.isEmpty((Collection)readableLines)) {
            return Collections.emptyList();
        }
        List list = Guavas.newArrayList((int)readableLines.size());
        Class<T> readClass = context.readClass();
        EntryReadConverter readConverter = new EntryReadConverter();
        SingleReadContext singleReadContext = new SingleReadContext();
        singleReadContext.classType(readClass).sort(context.sort()).split(",");
        for (String line : readableLines) {
            if (StringUtil.isEmpty((String)line)) continue;
            singleReadContext.value(line);
            Object instance = readConverter.convert(singleReadContext);
            list.add(instance);
        }
        return list;
    }
}

